#include "stdio.h"
#ifndef mips
#include "stdlib.h"
#endif
#include "xlisp.h"
#include "sound.h"

#include "falloc.h"
#include "sfread.h"

void sfread_free();


typedef struct sfread_susp_struct {
    snd_susp_node susp;

    SFDataPtr inptr;
    int infile;
} sfread_susp_node, *sfread_susp_type;


SFDataType input_buffer[max_sample_block_len];


void sfread__fetch(register sfread_susp_type susp, snd_list_type snd_list)
{
    int cnt = 0; /* how many samples computed */
    int togo;
    int n;
    sample_block_type out;
    register sample_block_values_type out_ptr;

    register sample_block_values_type out_ptr_reg;

    register SFDataPtr inptr_reg;
    falloc_sample_block(out);
    out_ptr = out->samples;
    snd_list->block = out;

    while (cnt < max_sample_block_len) { /* outer loop */
	/* first compute how many samples to generate in inner loop: */
	/* don't overflow the output sample block: */
	togo = max_sample_block_len - cnt;


	{
	    int nread;
	    if (susp->infile < 0) {
		togo = 0;	/* indicate termination */
		break;	/* we're done */
	    }
	    nread = read(susp->infile, (char *)input_buffer, max_sample_block_len * sizeof(SFDataType));
	    if (nread == 0) {
		close(susp->infile);
		susp->infile = -1;
	    }
	    togo = min(nread / sizeof(SFDataType), togo);
	}
	susp->inptr = input_buffer;

	n = togo;
	inptr_reg = susp->inptr;
	out_ptr_reg = out_ptr;
	if (n) do { /* the inner sample computation loop */
*out_ptr_reg++ = *inptr_reg++ / 32768.0;
	} while (--n); /* inner loop */

	out_ptr += togo;
	cnt += togo;
    } /* outer loop */

    /* test for termination */
    if (togo == 0 && cnt == 0) {
	snd_list_terminate(snd_list);
    } else {
	snd_list->block_len = cnt;
	susp->susp.current += cnt;
    }
} /* sfread__fetch */


void sfread_free(sfread_susp_type susp)
{
    ffree_generic(susp, sizeof(sfread_susp_node));
}


void sfread_print_tree(sfread_susp_type susp, int n)
{
}


sound_type snd_make_sfread(time_type t0, rate_type sr, char * filename)
{
    register sfread_susp_type susp;
    /* sr specified as input parameter */
    /* t0 specified as input parameter */
    sample_type scale_factor = 1.0;
    long togo;
    long lsc;

    falloc_generic(susp, sfread_susp_node);
    susp->inptr = NULL;
    susp->infile = open(filename, 0);
    susp->susp.fetch = sfread__fetch;

    /* initialize susp state */
    susp->susp.free = sfread_free;
    susp->susp.sr = sr;
    susp->susp.t0 = t0;
    susp->susp.mark = NULL;
    susp->susp.print_tree = sfread_print_tree;
    susp->susp.name = "sfread";
    susp->susp.log_stop_cnt = UNKNOWN;
    susp->susp.current = 0;
    return sound_create((snd_susp_type)susp, t0, sr, scale_factor);
}


sound_type snd_sfread(time_type t0, rate_type sr, char * filename)
{
    return snd_make_sfread(t0, sr, filename);
}
