; machine.lsp -- machine/system-dependent definitions
; 	rs6000

(if (not (boundp '*default-sf-format*))
    (setf *default-sf-format* snd-head-NeXT))

(if (not (boundp '*default-sound-file*))
    (compute-default-sound-file))

(if (not (boundp '*default-sf-dir*))
    (setf *default-sf-dir* "/tmp/"))

(if (not (boundp '*default-sf-mode*))
    (setf *default-sf-mode* snd-head-mode-pcm))

(if (not (boundp '*default-sf-bits*))
    (setf *default-sf-bits* 16))

(if (not (boundp '*default-plot-file*))
    (setf *default-plot-file* "points.dat"))

(defmacro play (expr)
  `(let ()
     (s-save ',expr 1000000000 *default-sound-file*)
     (play-file *default-sound-file*)))

; PLAY-FILE -- play a file
(defun play-file (name)
  (system (strcat "sfplay " (soundfilename name))))
