/* fileio.h -- Nyquist code to read sound files */

/* for multiple channel files, one susp is shared by all sounds */
/* the susp in turn must point back to all sound list tails */

typedef struct read_susp_struct {
    snd_susp_node susp;
    int inf;
    int nchans;	/* number of channels */
    int mode;	/* pcm, alaw, etc. */
    int bytes_per_sample;    /* bytes per sample */
    snd_list_type *chan;	/* array of back pointers */
    long cnt;	/* how many sample frames to read */
} read_susp_node, *read_susp_type;


#define st_ulaw_to_linear(ulawbyte) ulaw_table[ulawbyte]

extern int ulaw_table[256];

LVAL snd_make_read(unsigned char *filename, time_type offset, time_type t0,
	long *format, long *channels, long *mode, long *bits,
	double *srate, double *dur, long *flags);
/* LISP: (SND-READ STRING ANYNUM ANYNUM FIXNUM* FIXNUM* FIXNUM* 
	  FIXNUM* ANYNUM* ANYNUM* FIXNUM^) */
