// sound.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// The class for storing, playing, and editing digital sound information.

#ifndef SOUND_H
#ifdef __GNUG__
#pragma interface
#endif
#define SOUND_H
#include "localdefs.h"
#include "data.h"

class DataFile;
class Header;
class SoundHeader;
class Converter;
class StatusAction;

class Sound : public Data {
	typedef Data Super;
public:		// class methods
	static int defaultSampleRate() { return default_SampleRate; }
	static DataType defaultDataType() { return default_DataType; }
	static const char* defaultFileSuffix();
	static void setDefaultSampleRate(int rate) { default_SampleRate = rate; }
	static void setDefaultDataType(DataType type) { default_DataType = type; }
public:		// object methods
	Sound(double dur=0.1, int srate=44100, int nchans=1,
		DataType type=ShortData);
	Sound(int len, int srate=44100, int nchans=1, DataType type=ShortData);
	virtual ~Sound();
	redefined Data *newData();
	redefined Data *newData(int length);
	redefined Data *clone(const Range &selection);
	redefined Data *clone(const Range &selection, const Range &chans);
	redefined void copyFrom(const Data *src);
#ifdef sgi
	redefined int read(DataFile* f, Header* header = nil);
	redefined int write(DataFile *f);
#endif
// information methods
	redefined int sRate() const { return sr; }
	redefined void information(class Controller *);
	int nSamps() const { return length(); }
	int nChans() const { return channels(); }
	double duration() const;
	double peakAmp();
// sound data changing methods
	redefined int changeSRate(int rate, boolean filter);
	redefined int changeDataType(DataType newType);
// action methods
	void rescale();
	int play(Converter *, StatusAction *);
	int record(Converter *, StatusAction *);

	redefined FileType fileType() const { return Sound_Data; }
	redefined const char *fileSuffix() const;
// information methods for display objects
	redefined const char* windowClassName() const { return "SoundWindow"; }
	redefined const char* horizontalScaleModeAttribute() const {
		return "SoundWindowHorizontalScale";
	}
	redefined const char* channelDisplayAttribute() const {
		return "SoundWindowDisplayChannels";
	}
	redefined const char* defaultDirAttribute() const {
		return "DefaultSoundFileDir";
	}
	redefined Range frameRange(RangeUnit units) const;
	redefined const char* frameRangeLabel(RangeUnit units) const;
	redefined Scale::NumberDisplay frameRangeDisplay(RangeUnit units) const {
		return (units == FrameTimeUnit) ?
			Scale::AsFloat : Data::frameRangeDisplay(units);
	}
	redefined Range limits(int chan=0, boolean real=false) const;
	redefined void Notify() { Data::Notify(); }
protected:
#ifdef sgi
	redefined int write(DataFile* f, Header* header = nil) {
		return Super::write(f, header);
	}
#endif
	redefined void checkValues();
	redefined Header* createHeader(DataFile *, boolean isNew=false);
	redefined void readFromHeader(Header *);

	// protected ctors for virtual ctors
	Sound(const Sound *s) : Data(s), sr(s->sr) {}
	Sound(const Sound *s, int nwlen) : Data(s, nwlen), sr(s->sr) {}

	// protected ctors for cloning
	Sound(const Sound *, const Range &);
	Sound(const Sound *, const Range &, const Range &);
	
	virtual const char* getDataPointer() const;
	int doPlay(Converter *, StatusAction *);
	int doRecord(Converter *, StatusAction *);
#ifdef NX_COMPILER_RELEASE_3_0
	Data::checkValues();
#endif
private:	// static for class state
	static int default_SampleRate;
	static DataType default_DataType;
	static char* default_FileSuffix;
private:
	int sr;
	friend class RealConverter;	// FIX ME -- should only know of Converter
};

#endif
