// analysisfun.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include "analysisfun.h"
#include "data.h"
#include "envelope.h"
#include "query.h"
#include "request.h"

AnalysisFunction::~AnalysisFunction() {
	Resource::unref(myAnalysis);
}

void
AnalysisFunction::setAnalysis(Data *analysis) {
	Resource::unref(myAnalysis);
	myAnalysis = analysis;
	if(myAnalysis != nil) {
		myAnalysis->ref();
		// check to be sure analysis data object was fully allocated
		ok(getAnalysis()->length() != 0);
	}
}

//********

void
EnvelopeExtracter::initialize() {
	Envelope* envelope = new Envelope(analysisLength());
	envelope->setChannelName(
		(envelopeType == AbsoluteMagnitude) ? "Abs. Amp."
		: (envelopeType == RMSAmplitude) ? "RMS Amp."
		: "Decibels"
	);
	setAnalysis(envelope);
	Super::initialize();
}

const QueryInfo *
EnvelopeExtracter::requestInfo() {
	static QueryLabelInfo labels[] = {
		{ "Extract Amplitude Envelope: " }, { nil }
	};
	static QueryValueInfo values[] = {
		{ "Envelope Length (min. 8): ", "1024", CharCheck::posIntsOnly },
		{ nil }
	};
	static QueryChoiceInfo choices[] = {
		{ "Amplitude Mode:", "|Linear|RMS|Decibel|", Linear, true },
		{ nil }
	};
	static QueryInfo info[] = {
		{ labels, "", values, choices },
		{ nil }
	};
	return info;
}

boolean
EnvelopeExtracter::setValues(Request& request) {
	QueryValue v;
	request.retrieveValues(v);
	envelopeLength = v;
	QueryChoice choice;
	request.retrieveChoices(choice);
	int state = choice;
	envelopeType = (state == Linear) ?
		AbsoluteMagnitude : (state == RMS) ? RMSAmplitude : Decibels;
	return true;
}

int
EnvelopeExtracter::doApply(Data *data) {
	data->getEnvelope(getAnalysis(), 0, envelopeType);
	getAnalysis()->Notify();
	return true;
}
