// query.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <String.h>
#include "localdefs.h"
#include "query.h"

const char* QueryItem::separator = "|";

QueryItem::QueryItem(const char* lbl) {
	 myLabel = new String(lbl);
}

QueryItem::QueryItem(const char* beg, const char* end) {
	 myLabel = new String(beg);
	 *myLabel += end;
}

QueryItem::~QueryItem() {
	 delete myLabel;
}

const char*
QueryItem::label() { return *myLabel; }

/////////

QueryFile::QueryFile(const char* path, const char* suffixes) : QueryItem(""),
	myPath(new QueryValue(path)),
	mySuffixes(new String(suffixes? suffixes : "")) {
}

QueryFile::~QueryFile() {
	delete myPath;
	delete mySuffixes;
}
/////////

QueryButton::QueryButton(const char *lbl, Response r)
	: QueryItem(lbl), myResponse(r) {}

QueryButton::~QueryButton() {}

/////////

QueryChoice::QueryChoice(const char *lbl, const char *list,
		unsigned states, boolean excl) : QueryReturn(lbl),
	myList(list), myState(states), exclusive(excl) {}

QueryChoice::QueryChoice() : QueryReturn(""),
	myList(""), myState(0), exclusive(true) {}

QueryChoice::~QueryChoice() {}

const char *
QueryChoice::value() const {
	// casting away const 'this'
	sprintf(((QueryChoice *) this)->tmpbuf, "%u", myState);
	return tmpbuf;
}

boolean
QueryChoice::set(const char *s) {
	myState = (unsigned) atoi(s);
	return true;
}

// methods new to this class

void
QueryChoice::start() {			// initialize iterators
	iterator = myList;
	stateIterator = myState;
	currentValue = 0x1;		// value of first button 	
}

boolean
QueryChoice::nextValue(int *value) {
	boolean isTrue = stateIterator & 0x1;	// this state currently true?
	*value = int(currentValue);				// value for this button
	stateIterator >>= 1;					// shift to next state
	currentValue <<= 1;						// shift value up to next slot
	return isTrue;
}

const char *
QueryChoice::nextLabel() {
//	iterator = iterator.after(separator);
//	currentLabel = iterator.before(separator);
	SubString a = iterator.after(separator);
	iterator = a;
	SubString b = iterator.before(separator);
	currentLabel = b;
	return currentLabel;	// must store into String to convert to char*
}

/////////

QueryValue::QueryValue(const char* lbl, const char *s, CharCheckFun ccf)
	: QueryReturn(lbl), checkFun(ccf), string(new String(s ? s : "")) {
}

QueryValue::QueryValue(const char* s)
	: checkFun(&CharCheck::anyChar), string(new String(s ? s : "")) {}

QueryValue::QueryValue(const char *lbl, int i, CharCheckFun ccf)
	: QueryReturn(lbl), checkFun(ccf), string(new String(pstring(tmpbuf, i))) {}

QueryValue::QueryValue(int i)
	: checkFun(&CharCheck::anyChar), string(new String(pstring(tmpbuf, i))) {}

QueryValue::QueryValue(const char *lbl, double d, CharCheckFun ccf)
	: QueryReturn(lbl), checkFun(ccf), string(new String(pstring(tmpbuf, d))) {}
	
QueryValue::QueryValue(double d)
	: checkFun(&CharCheck::anyChar), string(new String(pstring(tmpbuf, d))) {}

QueryValue::~QueryValue() {
	 delete string;
}

boolean
QueryValue::set(const char *s) {
	register boolean good = false;
	if(good = isGood(s))
		*string = s;
	return good;
}

const char *
QueryValue::value() const {
	return *string;
}

int
QueryValue::intValue() const {
	return atoi(strlen(*string) > 0 ? (const char *) *string : "0");
}

double
QueryValue::doubleValue() const {
	return atof(strlen(*string) > 0 ? (const char *) *string : "0");
}
