// framedata.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#ifdef __GNUG__
#pragma implementation
#endif

#include "localdefs.h"
#include "application.h"
#include "framedata.h"
#include "header.h"
#include "range.h"
#include "smpte.h"

Data *
FrameData::newData() { return new FrameData(this); }

Data *
FrameData::newData(int nwlen) { return new FrameData(this, nwlen); }

Data *
FrameData::clone(const Range &r) { return new FrameData(this, r); }

Data *
FrameData::clone(const Range &r, const Range &c) {
	return new FrameData(this, r, c);
}

void
FrameData::readFromHeader(Header *h) {
	Data::readFromHeader(h);
	FrameDataHeader *hd = (FrameDataHeader *) h;
	sr = hd->sampleRate(),
	framerate = hd->frameRate();
}

void
FrameData::checkValues() {
	setMaxValue(scanForMaxValue());	// recheck peak amp
}

double 
FrameData::scanForMaxValue() const {
    double ampPeak = 0.0;
    Application::inform("Scanning for peak amp...");
	int chans = rep->realChannels();
    for(int chan = 0; chan < chans; chan += frameChannels()) {
        double chanPeak = Data::limits(chan, true).max();
        ampPeak = max(ampPeak, chanPeak);
    }
    return ampPeak;
}

Range
FrameData::frameRange(RangeUnit units) const {
	return (units == FrameTimeUnit) ? Range(0.0, duration())
	: (units == FrameSmpteUnit) ? Range(0.0, SMPTE::frames(duration()) - 1) 
	: Super::frameRange(units);
}
	
const char*
FrameData::frameRangeLabel(RangeUnit units) const {
	return (units == FrameTimeUnit) ? "Time in Seconds"
		: (units == FrameSmpteUnit) ? "SMPTE Frames" :
		Super::frameRangeLabel(units);
}

Scale::NumberDisplay
FrameData::frameRangeDisplay(RangeUnit units) const {
	return (units == FrameTimeUnit || units == ChannelSpecialUnit) ?
		Scale::AsFloat : Super::frameRangeDisplay(units);
}

