// crossfader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Crossfader is an implementation of a simple cross-fading algorithm:  the
// output Data will be a combination of the input and output according to the
// Envelope used.  The signal will be (Input * x) + (Output * (1 - x)) where x
// falls between 0 and 1.

#ifndef CROSSFADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define CROSSFADER_H

#include "datamodifier.h"

class Combiner : public DataModifier {
public:
	Combiner(Data* target, Data* source);
	~Combiner();
protected:
	redefined boolean confirmValues(Controller *);
	const Data* source() { return theSource; }
private:
	Data* theSource;
};

class Mixer : public Combiner {
public:
	Mixer(Data* target, Data* source);
	static Modifier* create(class DataEditor *);
	virtual ~Mixer();
	redefined const char* message() { return "Mixing..."; }
	redefined int doApply(Data *);
protected:
	redefined boolean setValues(Request &);
private:
	redefined const QueryInfo *requestInfo();
};

class Replacer : public Combiner {
public:
	Replacer(Data* target, Data* source);
	static Modifier* create(class DataEditor *);
	virtual ~Replacer();
	redefined const char* message() { return "Replacing..."; }
	redefined int doApply(Data *);
protected:
	redefined boolean setValues(Request &);
private:
	redefined const QueryInfo *requestInfo();
};

class Splicer : public Combiner {
public:
	Splicer(Data* target, Data* source);
	static Modifier* create(class DataEditor *);
	virtual ~Splicer();
	redefined const char* message() { return "Splicing in..."; }
	redefined int doApply(Data *);
protected:
	redefined boolean setValues(Request &);
private:
	redefined const QueryInfo *requestInfo();
};

class Envelope;

class Crossfader : public Combiner {
	typedef Combiner Super;
public:
	Crossfader(Data* target, Data* source, Envelope *evp, double amp);
	Crossfader(Data* target, Data* source)
		: Combiner(target, source), envelope(nil) {}
	static Modifier* create(class DataEditor *);
	virtual ~Crossfader();
	redefined const char* message() { return "Crossfading..."; }
	redefined int doApply(Data *);
protected:
	redefined boolean setValues(Request &);
	redefined boolean confirmValues(Controller *);
private:
	redefined const QueryInfo *requestInfo();
private:
	Envelope* envelope;
	double gain;
	boolean reverseEnvelope;
	enum EnvelopeType { Linear = 0x1, Exponential = 0x2, OnDisk = 0x4 };
	enum EnvelopeDirection { Forward = 0x1, Reverse = 0x2 };
};

#endif

