// analysisfun.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// AnalysisFunctions are DataModifiers which create an internal analysis data
// object of the correct type, and load the appropriate analysis into it.

#ifndef ANALYSISFUN_H
#ifdef __GNUG__
#pragma interface
#endif
#define ANALYSISFUN_H

#include "datamodifier.h"

class AnalysisFunction : public DataModifier {
public:
	AnalysisFunction(Data* data) : DataModifier(data), myAnalysis(nil) {}
	virtual ~AnalysisFunction();
	virtual Data* getAnalysis() { return myAnalysis; }
protected:
	virtual int analysisLength() = 0;	// for creating analysis object
	void setAnalysis(Data *);
private:
	Data* myAnalysis;
};

// this is not really a modifier of the data, but its interface is identical

class EnvelopeExtracter : public AnalysisFunction {
	typedef AnalysisFunction Super;
public:
	EnvelopeExtracter(Data* d) : AnalysisFunction(d), envelopeLength(0) {}
	static Modifier* create(DataEditor *);
	redefined const char* message() { return "Extracting envelope..."; }
protected:
    redefined void initialize();
	redefined int analysisLength() { return envelopeLength; }
	redefined boolean setValues(Request& r);
	redefined int doApply(Data *);
private:
	redefined const QueryInfo *requestInfo();
private:
	EnvelopeType envelopeType;
	int envelopeLength;
	enum Mode { Linear = 0x1, RMS = 0x2, Decibel = 0x4 };
};

#endif

