#####################################################################
# SPlaY-Tk v2.0p1, (C) Andrew Hobgood                               #
#                                                                   #
# Thanks to:                                                        #
# Chris Monahan - Some of the code, bug testing, and suggestions.   #
# Robert Gash - Bug testing, suggestions, and bitmaps/pixmaps       #
#               (gashalot@gashalot.com)                             #
#                                                                   #
# A little Tcl/Tk frontend to SPlay.                                #
#                                                                   #
# Normally distroed under the GPL, but this version is not distroed.#
#                                                                   #
# andrewh@wpi.edu, Kha0S, +o on EFnet #LinuxOS                      #
#####################################################################

toplevel .splash -background black
wm title .splash "Welcome to SPlay-Tk!"
image create photo splash -file ${images}/splay-tk.gif
label .splash.splash -image splash
label .splash.copyright -text "(C) Andrew Hobgood, 1997" -background black -foreground white
button .splash.kill -text "Okay" -command {destroy .splash}
pack .splash.splash .splash.copyright .splash.kill -side top -pady 2m -padx 2m

set ver "v2.0p1"

wm title . "SPlay-Tk $ver"

set binary "splay"
set pause 0
set playing 0
set mod ""
set mono ""
set buffers 20
set dir [pwd]
set pid 1000000

image create bitmap play -file ${images}/play.xbm
image create bitmap stop -file ${images}/stop.xbm
image create bitmap pause -file ${images}/pause.xbm
image create bitmap quit -file ${images}/quit.xbm
image create bitmap dirs -file ${images}/dirs.xbm
image create bitmap files -file ${images}/files.xbm

label .title -text "SPlay-Tk $ver" -font -*-utopia-*-i-*-*-40-*-*-*-*-*-*-*

frame .buttons
pack .buttons -side bottom -fill x -pady 2m
button .buttons.play -image play -command {
        if [ catch {string match "" [exec ps -hc $pid 2>/dev/null]}] \
        {set pid [playmod $binary -${mono}t$buffers ${dir}/${mod}]}}
button .buttons.pause -image pause -command { \
	if $pause { catch {exec kill -18 $pid >/dev/null 2>/dev/null; set pause 0;}} \
		{ catch {exec kill -19 $pid >/dev/null 2>/dev/null; set pause 1;}} }
button .buttons.stop -image stop -command { catch {exec kill -2 $pid >/dev/null 2>/dev/null}}
button .buttons.quit -image quit -command "destroy ."
pack .buttons.play .buttons.pause .buttons.stop .buttons.quit -expand 1 -side left

frame .mode
radiobutton .mode.stereo -text "Stereo" -variable mono -value ""
radiobutton .mode.mono -text "Mono" -variable mono -value "m"
label .mode.bufferlab -text "Frame Buffers"
entry .mode.framebuffer -width 5 -textvariable buffers
label .mode.spacer -text "            "
pack .mode.stereo .mode.mono .mode.spacer -side left
pack .mode.bufferlab .mode.framebuffer -side right
frame .dir
frame .dir.dirs
frame .dir.files
frame .dir.dirs.listing
frame .dir.files.listing
pack .title .dir .mode -side top -padx 2m -expand 1

label .dir.dirs.title -image dirs
label .dir.files.title -image files

proc refresh {dir} {

	scrollbar .dir.dirs.listing.scroll -command ".dir.dirs.listing.list yview"
	listbox .dir.dirs.listing.list -yscroll ".dir.dirs.listing.scroll set" -relief sunken -width 15 -height 20 \
		-setgrid yes -font -*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*
	scrollbar .dir.files.listing.scroll -command ".dir.files.listing.list yview"
	listbox .dir.files.listing.list -yscroll ".dir.files.listing.scroll set" -relief sunken -width 40 -height 20 \
		-setgrid yes -font -*-helvetica-*-r-*-*-12-*-*-*-*-*-*-*
	pack .dir.dirs.listing.list .dir.dirs.listing.scroll -side left -fill both -pady 2m -expand yes
	pack .dir.files.listing.list .dir.files.listing.scroll -side left -fill both -pady 2m -expand yes

	pack .dir.dirs.title .dir.dirs.listing -side top
	pack .dir.files.title .dir.files.listing -side top
	pack .dir.dirs .dir.files -side left

	foreach i [exec ls -a ${dir}] {
		if [file isdirectory ${dir}/${i}] {.dir.dirs.listing.list insert end $i} \
	}

	foreach i [exec ls -a ${dir}] {
		if [file isfile ${dir}/${i}] {.dir.files.listing.list insert end "$i"} \
	}

	bind .dir.files.listing.list <ButtonRelease-1> {set mod [selection get]}
	bind .dir.dirs.listing.list <Double-Button-1> {set click [selection get]
		if [file isdirectory ${dir}/${click}] {
			set dir ${dir}/${click}
			destroy .dir.dirs.listing.list; destroy .dir.files.listing.list
			destroy .dir.dirs.listing.scroll; destroy .dir.files.listing.scroll
			refresh $dir
		}
	}
	bind .dir.files.listing.list <Double-Button-1> {set click [selection get]
		if [file isfile ${dir}/${click}] {
			set mod $click
			if ![catch {string match "" [exec ps -hc $pid 2>/dev/null]}] {
				catch {exec kill -2 $pid >/dev/null 2>/dev/null}}
			set pid [playmod $binary -${mono}t$buffers ${dir}/${mod}]
		}

	}
}

refresh $dir

proc playmod {binary options mod} {
	set pid [exec $binary $options $mod >/dev/null 2>/dev/null &]
	return $pid
}
