/*

This software module was originally developed by 

Mike Guzewicz (E-mu Systems)


in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3) standard. 
This software module is an implementation of a part of one or more 
MPEG-4 Audio (ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio 
(ISO/IEC 14496-3). ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) 
free license to this software module or modifications thereof for use 
in hardware or software products claiming conformance to the MPEG-4 Audio 
(ISO/IEC 14496-3). Those intending to use this software module in hardware 
or software products are advised that its use may infringe existing patents. 
The original developer of this software module and his/her company, the 
subsequent editors and their companies, and ISO/IEC have no liability for 
use of this software module or modifications thereof in an implementation. 
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming 
products. E-mu Systems retains full right to use the code for his/her own 
purpose, assign or donate the code to a third party and to inhibit third 
parties from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) 
conforming products. This copyright notice must be included in all copies 
or derivative works. 

Copyright (C) 1997 E-mu Systems, Inc.

*/     /*********************************************************************
     
     sfe_omega.cpp
     
     
     *********************************************************************/


//*****************************************************************************
//  @(#)omega.cpp	1.1 12:06:44 3/15/95 12:06:47
// 
// File      : Omega.c
// 
// The module provides the implementation of the class Omega. Omega is a 
// set of routines which set and report error conditions. It is widely
// used within the codebase.
//
//*****************************************************************************

#include "sfe_omega.h"
#ifdef DEBUG
#include <iostream.h>	// used to say "iostream.h"
#endif


///////////////////////////
//    Class Methods      //
///////////////////////////

OmegaClass::OmegaClass(void)
{
 shOmega      = SUCCESS; 
 ErrorArray  = 0;
}

 OmegaClass::OmegaClass(ErrVec *EVec)
{
  shOmega     = SUCCESS; 
  ErrorArray = EVec;
} 




void OmegaClass::ReportError(void)
//*****************************************************************************
// 
// Implementation Notes: 
//
//    This function should be reimplmented in any new class derived 
// from this, that needs a different method for outputing the string values of 
// the error to whatever device is needed. (Windows, to a file, across the 
// net, to the moon, whatever...)
//
// History: 
//
//   Person               Date         Reason
// --------------------   -----------  ---------------------------------------
//
//****************************************************************************
{
#ifdef DEBUG
    cout << GetErrorStr() << endl;
#endif
}

