/**********************************************************************
MPEG-4 Audio VM

This software module was originally developed by
  Y.B. Thomas Kim and S.H. Park (Samsung AIT)
and edited by
  Y.B. Thomas Kim (Samsung AIT) on 1997-11-06

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1997.

**********************************************************************/
#include <stdio.h>
#include <math.h>
#include "common.h"
#include "bitstream.h"
#include "sam_encode.h"

#define	ID_SCE	0x00
#define	ID_CPE	0x01
#define	MAX_PRED_SFB	40

#ifdef __cplusplus
extern "C" {
#endif

static int get_max_scalefactor(int, int *, int, int *);

#ifdef __cplusplus
}
#endif

int sam_encode_frame(
		int id,
		int common_window,
		WINDOW_TYPE block_type,
		Window_shape	window_shape,
		int sfb_offset[],
		int num_window_groups,
		int window_group_length[],
		int	quant[][1024],
		int	scfacs[][112],
		BsBitStream *fixed_stream,
		BsBitBuffer **gcBitBuf,
		int i_ch,
		int w_flag,
		int avr_bits)
{
	int	i, j, b, ch;
	int	maxSfb[2];
	int groupInfo[2][8];
	int	windowSequence[2];
	int	windowShape[2];
	int	scalefactors[2][112];
	int	swb_offset[2][112];
	int	is_info[112];
	int	gain_control_data_present[2];
	int	is_intensity;
	int	stereo_mode;
	int	stereo_info[112];
	int	maxScaleFactor;
	int	frameSize;
	int	fsize_len;
	int	abits;
	int	ubits;
	int	bottom, top;
	int	nch, num_win, nnch;
	static int framecount=0;

	nch = i_ch + 1;

	/*
	 *  START BSAC
	 */

	/* initialize */
	is_intensity = 0;
	stereo_mode = 0;
	windowSequence[i_ch] = block_type;
	windowShape[i_ch] = window_shape;

	for(i = 0; i < 112; i++) {
		scalefactors[i_ch][i] = scfacs[i_ch][i];
		stereo_info[i] = 0;
		swb_offset[i_ch][i] = sfb_offset[i];
	}

	j = 0;
	for(b = 0; b < num_window_groups; b++) {
		groupInfo[i_ch][j++] = 0;
		for(i = 1; i < window_group_length[b]; i++)
			groupInfo[i_ch][j++] = 1;
	}

	if(windowSequence[i_ch] == EIGHT_SHORT_SEQUENCE)
		maxSfb[i_ch] = 11;
	else
		maxSfb[i_ch] = 39;

	if(w_flag) {

	sam_init_bs();

	nch = 1;
	if(id == ID_CPE) {
		for(i = 0; i < 112; i++) {
			scalefactors[1][i] = scfacs[1][i];
			swb_offset[1][i] = swb_offset[0][i];
		}
		windowSequence[1] = windowSequence[0];
		windowShape[1] = windowShape[0];
		maxSfb[1] = maxSfb[0];

		for(i = 0; i < 8; i++)
			groupInfo[1][i] = groupInfo[0][i];
		nch = 2;
	}

	ubits = 0;

	/* make header */
	ubits += sam_putbits2bs(id, 3);	/* id_syn_ele : ID_CPE : 3 */

/* BEGIN single_channel_element() or channel_pair_element */

	ubits += sam_putbits2bs(0x00, 4);	/* element_instance_tag : 4 */

	ubits += sam_putbits2bs(0, 1);	/* nok_ltp_data_present : 1 */

	if(id == ID_CPE)
		ubits += sam_putbits2bs(common_window, 1);	/* common_window : 1 */

/* END single_channel_element() or channel_pair_element */

/* BEGIN bsac_channel_stream() */
	/* max scalefactor */
	for(ch = 0; ch < nch; ch++) {
		maxScaleFactor = get_max_scalefactor(windowSequence[ch],
			scalefactors[ch], maxSfb[ch], groupInfo[ch]);
		ubits += sam_putbits2bs(maxScaleFactor, 8);
	}
		
	nnch = nch;
	if(id == ID_CPE && common_window)
		nnch = 1;


	/***** ics_info() *******/
	for(ch = 0; ch < nnch; ch++) {
		ubits += sam_putbits2bs(0x00, 1);	/* ics_reserved_bit : 1 */

		ubits += sam_putbits2bs((int)windowSequence[ch], 2);
		ubits += sam_putbits2bs((int)windowShape[ch], 1);

		if(windowSequence[ch] == EIGHT_SHORT_SEQUENCE) {
			ubits += sam_putbits2bs(maxSfb[ch], 4);
			for(i = 1; i < 8; i++)
				ubits += sam_putbits2bs(groupInfo[ch][i], 1);
		} else {
			ubits += sam_putbits2bs(maxSfb[ch], 6);
			ubits += sam_putbits2bs(0, 1);	/* predictor_data_present : 1 */
		}
	}
	/****** end of ics_info() ******/


	for(ch = 0; ch < nch; ch++) {
		ubits += sam_putbits2bs(0, 1);	/* tns_data_present : 1 */

		/* gain control data */
		if(gcBitBuf[ch] && (gcBitBuf[ch]->numBit > 0)) {
			ubits += sam_putbits2bs(0x01, 1);
			{
				int	num_bytes, remain_bits;

				num_bytes = gcBitBuf[ch]->numBit/8;
				for(i = 0; i < num_bytes; i++)
					ubits += sam_putbits2bs(gcBitBuf[ch]->data[i], 8);
				remain_bits = gcBitBuf[ch]->numBit - (num_bytes * 8);
				ubits += sam_putbits2bs(gcBitBuf[ch]->data[i]>>(8-remain_bits), remain_bits);
			}
		} else {
			ubits += sam_putbits2bs(0x00, 1);
		}
	}

	fsize_len = 9;
	if(id == ID_CPE) {
		fsize_len = 10;
		ubits += sam_putbits2bs(0, 2);	/* stereo mode */
	}

/**** BEGIN bsac_data() ****/

	ubits += sam_putbits2bs(0x00, fsize_len);	/* frameSize : 9/10 */
	ubits += sam_putbits2bs(48, 6);	/* Top layer bitrate : 2 */

	} else {
		ubits = 47;
		if(gcBitBuf[i_ch] && (gcBitBuf[i_ch]->numBit > 0))
			ubits += gcBitBuf[i_ch]->numBit;
	}

	if(avr_bits == 0)
		abits = 10000;
	else
		abits = avr_bits - 8;

	frameSize = sam_encode_data(common_window, windowSequence, scalefactors,
			groupInfo, quant, maxSfb, swb_offset, stereo_mode, stereo_info,
			ubits, abits, i_ch, nch, w_flag);

	if(w_flag) {
	/* byte alignment */
	if((frameSize % 8)) {
		frameSize += sam_putbits2bs(0x00, (8 - (frameSize % 8)));
	}
	sam_frame_length_rewrite2bs(frameSize, ubits-(6+fsize_len), fsize_len);

	sam_bsflush(fixed_stream, frameSize);
	} else {
		frameSize += 16;
	}

	return frameSize;
}

static int get_max_scalefactor(
	int	window_sequence,
	int	scf[],
	int	max_sfb,
	int	groupinfo[])
{
	int	max, sfb, reg, no_region;

	max = 0;
	if(window_sequence != EIGHT_SHORT_SEQUENCE) {
		for(sfb = 0; sfb < max_sfb; sfb++)
			if (max < scf[sfb]) max = scf[sfb];
	} else {
		no_region = 1;
		for(reg = 1; reg < 8; reg++)
			if(groupinfo[reg] == 0)
				no_region++;

		for (reg=0;reg<no_region;reg++)
			for(sfb=0; sfb < max_sfb; sfb++) {
	    		if(max < scf[sfb+14*reg]) max=scf[sfb+14*reg];
		}
	}

	return max;
}
