/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Akio Jin (NTT)                                                          */
/* and edited by                                                             */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Akio Jin (NTT) on 1997-10-23,                                           */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1997.                                                        */
/*****************************************************************************/

#include "ntt_conf.h"
#include "ntt_scale_conf.h"
#include "mat_def_ntt.h"


void ntt_scale_tf_requantize_spectrum(/* Input */
				      ntt_INDEX *indexp,
				      /* Output */
				      double flat_spectrum[],
				      /* scalable layer ID */
				      int iscl)
{
  int    vq_bits, bits_side_info, n_sf, cb_len_max;
  double *sp_cv0, *sp_cv1;
  
  /*--- Parameter settings ---*/
  switch(indexp->w_type){
  case ONLY_LONG_WINDOW:
  case LONG_SHORT_WINDOW:
  case SHORT_LONG_WINDOW:
  case LONG_MEDIUM_WINDOW:
  case MEDIUM_LONG_WINDOW:
    /* available bits */
    vq_bits = ntt_VQTOOL_BITS_SCL[iscl];
    /* codebooks */
    sp_cv0 = (double *)ntt_codev0_scl[iscl];
    sp_cv1 = (double *)ntt_codev1_scl[iscl];
    cb_len_max = ntt_CB_LEN_READ_SCL[iscl] + ntt_CB_LEN_MGN;
    /* number of subframes in a frame */
    n_sf = ntt_N_SUP;
    break;
  case ONLY_MEDIUM_WINDOW:
  case MEDIUM_SHORT_WINDOW:
  case SHORT_MEDIUM_WINDOW:
    /* available bits */
    vq_bits = ntt_VQTOOL_BITS_M_SCL[iscl];
    /* codebooks */
    sp_cv0 = (double *)ntt_codev0m_scl[iscl];
    sp_cv1 = (double *)ntt_codev1m_scl[iscl];
    cb_len_max = ntt_CB_LEN_READ_M_SCL[iscl] + ntt_CB_LEN_MGN;
    /* number of subframes in a frame */
    n_sf = ntt_N_SUP * ntt_N_MID;
    break;
  case ONLY_SHORT_WINDOW:
    /* available bits */
    vq_bits = ntt_VQTOOL_BITS_S_SCL[iscl];
    /* codebooks */
    sp_cv0 = (double *)ntt_codev0s_scl[iscl];
    sp_cv1 = (double *)ntt_codev1s_scl[iscl];
    cb_len_max = ntt_CB_LEN_READ_S_SCL[iscl] + ntt_CB_LEN_MGN;
    /* number of subframes in a frame */
    n_sf = ntt_N_SUP * ntt_N_SHRT;
    break;
  default:
    fprintf(stderr, "ntt_scale_tf_requantize_spectrum(): %d: No such window type.\n",
	    indexp->w_type);
    exit(1);
  }
  
  /*--- Reconstruction ---*/
  ntt_vex_pn(indexp->wvq,
	     sp_cv0, sp_cv1, cb_len_max,
	     n_sf, ntt_N_FR*ntt_N_SUP,
	     vq_bits,
	     flat_spectrum);
}
