/*****************************************************************************/
/* This software module was originally developed by                          */
/*   Naoki Iwakami (NTT)                                                     */
/* and edited by                                                             */
/*   Naoki Iwakami and Satoshi Miki (NTT) on 1996-05-01,                     */
/*   Naoki Iwakami (NTT) on 1996-08-27,                                      */
/*   Naoki Iwakami (NTT) on 1996-12-06,                                      */
/*   Naoki Iwakami (NTT) on 1997-04-18,                                      */
/*   Naoki Iwakami (NTT) on 1997-07-17,                                      */
/*   Takehiro Moriya (NTT) on 1997-08-01,                                    */
/*   Naoki Iwakami (NTT) on 1997-08-25                                       */
/*   Akio Jin (NTT) on 1997-10-23,                                           */
/* in the course of development of the                                       */
/* MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 14496-1,2 and 3.        */
/* This software module is an implementation of a part of one or more        */
/* MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 Audio */
/* standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio standards   */
/* free license to this software module or modifications thereof for use in  */
/* hardware or software products claiming conformance to the MPEG-2 NBC/     */
/* MPEG-4 Audio  standards. Those intending to use this software module in   */
/* hardware or software products are advised that this use may infringe      */
/* existing patents. The original developer of this software module and      */
/* his/her company, the subsequent editors and their companies, and ISO/IEC  */
/* have no liability for use of this software module or modifications        */
/* thereof in an implementation. Copyright is not released for non           */
/* MPEG-2 NBC/MPEG-4 Audio conforming products. The original developer       */
/* retains full right to use the code for his/her  own purpose, assign or    */
/* donate the code to a third party and to inhibit third party from using    */
/* the code for non MPEG-2 NBC/MPEG-4 Audio conforming products.             */
/* This copyright notice must be included in all copies or derivative works. */
/* Copyright (c)1996.                                                        */
/*****************************************************************************/

/* 06-dec-96   NI   provided 6 kbit/s support */
/* 18-apr-96   NI   minor bug fix */
/* 01-aug-96   TM   provided 6 kbit/s support for 8 kHz*/
/* 25-aug-97   NI   added bandwidth control */

/*---------------------------------------------------------------------------*/
/* twinvq.h                                                                  */
/* Header file of TwinVQ audio coding program                                */
/*---------------------------------------------------------------------------*/

#ifndef _ntt_conf_h
#define _ntt_conf_h

#include <stdio.h>
#include <math.h>
#include <time.h>
#include <stdlib.h>
#include "tf_main.h"
#include "bitstream.h"

/*---------------------------------------------------------------------------*/
/* GENERAL SETTINGS                                                          */
/*---------------------------------------------------------------------------*/

#define	YES		1
#define	NO		0

#define	ON		1
#define	OFF		0

#if 0
enum CHANNEL_CONFIG {
  MONO_LEFT_ONLY,
  STEREO_LEFT_RIGHT,
  MONO_LOW_MONO_HIGH,
  MONO_LOW_STEREO_HIGH,
  STEREO_LOW_STEREO_HIGH,
  MONO_LOW_MONO_MED_MONO_HIGH,
  MONO_LOW_MONO_MED_STEREO_HIGH,
  MONO_LOW_STEREO_MED_STEREO_HIGH,
  STEREO_LOW_STEREO_MED_STEREO_HIGH,
  MONO_MED_MONO_HIGH,
  MONO_MED_STEREO_HIGH,
  STEREO_MED_STEREO_HIGH
};
#endif

/*
Window configuration
The time frequency mapping can be used with different window lengthes which are coded according to the following table:
*/

#if 0
WINDOW_TYPE {
  ONLY_LONG_WINDOW = 0,
  LONG_SHORT_WINDOW,
  ONLY_SHORT_WINDOW,
  SHORT_LONG_WINDOW,
  SHORT_MEDIUM_WINDOW,
  MEDIUM_LONG_WINDOW,
  LONG_MEDIUM_WINDOW,
  MEDIUM_SHORT_WINDOW,
  ONLY_MEDIUM_WINDOW
};
#endif

/* Interleave set mode select */
enum ntt_INTERLEAVE_SET_MODE {
  ntt_INTR_LONG,
  ntt_INTR_MEDIUM,
  ntt_INTR_SHORT,
  ntt_INTR_PITCH,
  ntt_INTR_ALL
};


/* VM perceptual weight mode select */
enum NTT_PW_SELECT {
  NTT_PW_INTERNAL,
  NTT_PW_EXTERNAL
};

/* VM variable bit mode select */
enum NTT_VARBIT{
  NTT_VARBIT_OFF,
  NTT_VARBIT_ON
};

/* Block length */
enum ntt_BLOCK_LENGTH {
  ntt_BLOCK_LONG,
  ntt_BLOCK_MEDIUM,
  ntt_BLOCK_SHORT
};

#define	ntt_max(x,y)	( (x) > (y) ? (x) : (y) )
#define	ntt_min(x,y)	( (x) < (y) ? (x) : (y) )

#ifndef PI
#define	PI	3.141592653189793238462643383279
#endif
#define ntt_SQRT1_2 0.70710678118654752440

/*---------------------------------------------------------------------------*/
/* PROGRAM MODE                                                              */
/*---------------------------------------------------------------------------*/

#define ntt_LSP_TO_WT       YES

#define ntt_N_SUP_MAX       2
#define ntt_N_SUP_MIN       1

#define ntt_SAMPF_MAX         48000
#define ntt_SAMPF_MIN          8000
#define ntt_BPS_MAX           64000
#define ntt_BAND_EXP_MAX        900
#define ntt_BAND_EXP_MIN        150
#define ntt_N_PR_MAX             20
#define ntt_N_PR_MIN             10
#define ntt_N_FR_MAX           2048
#define ntt_N_FR_MIN            512

#define ntt_N_SHRT_MAX            32
#define ntt_N_SHRT_MIN             4

#define ntt_N_FR_S_MAX (ntt_N_FR_MAX/ntt_N_SHRT_MIN) /* Short frame size */
#define ntt_N_FR_S_MIN (ntt_N_FR_MIN/ntt_N_SHRT_MAX) /* Short frame size */

#define ntt_T_SHRT_MAX (ntt_N_SHRT_MAX*ntt_N_SUP_MAX)
#define ntt_T_SHRT_MIN (ntt_N_SHRT_MIN*ntt_N_SUP_MIN)

#define ntt_N_MID_MAX 8
#define ntt_N_MID_MIN 2

#define ntt_N_FR_M_MAX (ntt_N_FR_MAX/ntt_N_MID_MIN) /* Short frame size */
#define ntt_N_FR_M_MIN (ntt_N_FR_MIN/ntt_N_MID_MAX) /* Short frame size */

#define ntt_T_MID_MAX (ntt_N_MID_MAX*ntt_N_SUP_MAX)
#define ntt_T_MID_MIN (ntt_N_MID_MIN*ntt_N_SUP_MIN)

#define ntt_N_WDW_MAX (ntt_N_FR_MAX*2) /* window length */
#define ntt_N_WDW_MIN (ntt_N_FR_MIN*2) /* window length */

#define ntt_T_FR_MAX (ntt_N_FR_MAX*ntt_N_SUP_MAX) /* total input frame size */
#define ntt_T_FR_MIN (ntt_N_FR_MIN*ntt_N_SUP_MIN) /* total input frame size */
#define ntt_T_FR_S_MAX (ntt_N_FR_S_MAX*ntt_N_SUP_MAX)
#define ntt_T_FR_S_MIN (ntt_N_FR_S_MIN*ntt_N_SUP_MIN)
#define ntt_T_FR_M_MAX (ntt_N_FR_M_MAX*ntt_N_SUP_MAX)
#define ntt_T_FR_M_MIN (ntt_N_FR_M_MIN*ntt_N_SUP_MIN)
#define ntt_T_WDW_MAX  (ntt_N_WDW_MAX*ntt_N_SUP_MAX)
#define ntt_T_WDW_MIN  (ntt_N_WDW_MIN*ntt_N_SUP_MIN)

#define ntt_CB_INCLUDE NO

/*---------------------------------------------------------------------------*/
/* LSP QUANTIZATION                                                          */
/*---------------------------------------------------------------------------*/

#define ntt_LSP_BIT0_MAX  1  /* num of bits for prediction switch */
#define ntt_LSP_BIT1_MAX  7  /* num of bits at first stage */
#define ntt_LSP_BIT2_MAX  5  /* num of bits per split vq at second stage */ 
#define ntt_LSP_SPLIT_MAX 4  /* num of split at second stage */

#define ntt_LSP_BIT0_MIN  1  /* num of bits for prediction switch */
#define ntt_LSP_BIT1_MIN  7  /* num of bits at first stage */
#define ntt_LSP_BIT2_MIN  4  /* num of bits per split vq at second stage */ 
#define ntt_LSP_SPLIT_MIN 2  /* num of split at second stage */

#define ntt_NSP     ntt_LSP_SPLIT
#define ntt_NSP_MAX ntt_LSP_SPLIT_MAX
#define ntt_NSP_MIN ntt_LSP_SPLIT_MIN

#define ntt_N_MODE_MAX (1<<ntt_LSP_BIT0_MAX)
#define ntt_N_MODE_MIN (1<<ntt_LSP_BIT0_MIN)

#define ntt_NC0_MAX (1<<ntt_LSP_BIT1_MAX)
#define ntt_NC0_MIN (1<<ntt_LSP_BIT1_MIN)

#define ntt_NC1_MAX (1<<ntt_LSP_BIT2_MAX)
#define ntt_NC1_MIN (1<<ntt_LSP_BIT2_MIN)

#define ntt_LSP_NIDX_MAX \
 (ntt_LSP_BIT0_MAX + ntt_LSP_BIT1_MAX + ntt_LSP_BIT2_MAX*ntt_LSP_SPLIT_MAX)
#define ntt_LSP_NIDX_MIN \
 (ntt_LSP_BIT0_MIN + ntt_LSP_BIT1_MIN + ntt_LSP_BIT2_MIN*ntt_LSP_SPLIT_MIN)

#define ntt_MA_NP      1  /* MA prediction order for LSP */
#define ntt_LSP_NSTAGE 2

#define ntt_SIDE_INF_SW 4           /* side information switch w-size   */

/*---------------------------------------------------------------------------*/
/* GAIN QUANTIZATION                                                         */
/*---------------------------------------------------------------------------*/
#define	ntt_AMP_NM 1024.0        /* Normalized amplitude of resid           */
#define ntt_I_AMP_NM (1./ntt_AMP_NM)    /* Inverse normalized amplitude */
#define	ntt_POW_NORM (ntt_AMP_NM*ntt_AMP_NM)/* Normalized amplitude of resid */

#define ntt_GAIN_BITS_MIN 5
#define ntt_GAIN_BITS_MAX 14
#define ntt_SUB_GAIN_BITS_MIN 2
#define ntt_SUB_GAIN_BITS_MAX 10

#define	  ntt_SUB_AMP_NM   1024.0 /* Normalized amplitude of resid           */

/*---------------------------------------------------------------------------*/
/* FORWARD ENVELOPE QUANTIZATION                                             */
/*---------------------------------------------------------------------------*/

#define ntt_N_CRB_MAX     96
#define ntt_N_CRB_M_MAX   96
#define ntt_N_CRB_S_MAX   12

#define ntt_FW_N_DIV_MAX  16  /* Number of division of envelope codebook */
#define ntt_FW_N_DIV_MIN   4  /* Number of division of envelope codebook */

#define ntt_FW_N_DIV_S_MAX  4      /* Num. div. of env. cb (short frame) */
#define ntt_FW_N_DIV_S_MIN  1      /* Num. div. of env. cb (short frame) */

#define ntt_FW_N_DIV_M_MAX  16      /* Num. div. of env. cb (short frame) */
#define ntt_FW_N_DIV_M_MIN  1      /* Num. div. of env. cb (short frame) */

#define ntt_FW_N_DIV_MX (ntt_max(ntt_FW_N_DIV_MAX,ntt_FW_N_DIV_S_MAX*ntt_N_SHRT_MAX))
                                  /* Envelope index array size per ch. */
#define ntt_FW_N_BIT_MAX  10      /* Envelope codebook bits */
#define ntt_FW_N_BIT_MIN  6       /* Envelope codebook bits */
#define ntt_FW_CB_SIZE_MAX (1<<ntt_FW_N_BIT_MAX)   /* Envelope codebook size */
#define ntt_FW_CB_SIZE_MIN (1<<ntt_FW_N_BIT_MAX)   /* Envelope codebook size */
#define ntt_FW_CB_LEN_MAX (ntt_N_CRB_MAX/ntt_FW_N_DIV_MIN)/* codebook length */

#define ntt_FW_N_BIT_S_MAX  8    /* Envelope codebook bits */
#define ntt_FW_N_BIT_S_MIN  4    /* Envelope codebook bits */
#define ntt_FW_CB_SIZE_S_MAX (1<<ntt_FW_N_BIT_S_MAX) /* codebook size */
#define ntt_FW_CB_SIZE_S_MIN (1<<ntt_FW_N_BIT_S_MAX) /* codebook size */
#define ntt_FW_CB_LEN_S_MAX (ntt_N_CRB_S_MAX/ntt_FW_N_DIV_S_MIN) /* length */

#define ntt_FW_N_BIT_M_MAX  10 /* Envelope codebook bits */
#define ntt_FW_N_BIT_M_MIN  4  /* Envelope codebook bits */
#define ntt_FW_CB_SIZE_M_MAX (1<<ntt_FW_N_BIT_M_MAX) /* codebook size */
#define ntt_FW_CB_SIZE_M_MIN (1<<ntt_FW_N_BIT_M_MAX) /* codebook size */
#define ntt_FW_CB_LEN_M_MAX (ntt_N_CRB_M_MAX/ntt_FW_N_DIV_M_MIN) /* length */

#define ntt_FW_CB_LEN_MX \
(ntt_max(ntt_FW_CB_LEN_MAX, ntt_max(ntt_FW_CB_LEN_M_MAX, ntt_FW_CB_LEN_S_MAX)))

#define ntt_FW_ARQ_NBIT   1 /* prediction coefficient quant. bits */
#define ntt_FW_ARQ_NSTEP  (1<<ntt_FW_ARQ_NBIT)
#define ntt_FW_ALF_MAX  0.5 /* Maximum value of quantized coefficient */
#define ntt_FW_ALF_STEP (ntt_FW_ALF_MAX/(ntt_FW_ARQ_NSTEP-1))
                                  /* Coefficient quantization step width */

#define ntt_FW_LLIM     1.e-1         /* Lower limit of decoded envelope */

#define ntt_FW_TRAIN       NO /* Envelope codebook training switch */
#define ntt_FW_TBIT_MAX   (ntt_FW_N_BIT_MAX*ntt_FW_N_DIV_MAX+ntt_FW_ARQ_NBIT)
#define ntt_FW_TBIT_S_MAX \
(ntt_FW_N_BIT_S_MAX*ntt_FW_N_DIV_S_MAX+ntt_FW_ARQ_NBIT)
#define ntt_FW_TBIT_M_MAX \
(ntt_FW_N_BIT_M_MAX*ntt_FW_N_DIV_M_MAX+ntt_FW_ARQ_NBIT)
#define ntt_FW_TBIT_MIN    (ntt_FW_N_BIT_MIN*ntt_FW_N_DIV_MIN+ntt_FW_ARQ_NBIT)
#define ntt_FW_TBIT_S_MIN \
(ntt_FW_N_BIT_S_MIN*ntt_FW_N_DIV_S_MIN+ntt_FW_ARQ_NBIT)
#define ntt_FW_TBIT_M_MIN \
(ntt_FW_N_BIT_M_MIN*ntt_FW_N_DIV_M_MIN+ntt_FW_ARQ_NBIT)

/*---------------------------------------------------------------------------*/
/* PITCH FILTER                                                              */
/*---------------------------------------------------------------------------*/
#define ntt_N_FR_FFT   512

#define ntt_N_PULSE_MAX 50

#define ntt_PGAIN_MAX    20000.

#define ntt_N_FR_P_MAX   40
#define ntt_N_DIV_P_MAX  20
#define ntt_MAXBIT_SHAPE_P    6 /* maxbit for pitchVQ per channel */
#define ntt_PIT_N_BIT_MAX (ntt_MAXBIT_SHAPE_P+1)
#define ntt_PIT_CB_SIZE_MAX (1<<ntt_PIT_N_BIT_MAX)
#define ntt_POLBITS_P   1
#define ntt_MAXBIT_P    (ntt_MAXBIT_SHAPE_P+ntt_POLBITS_P)

#define ntt_CB_LEN_P_MAX 24

#define ntt_PIT_TRAIN  NO
#define ntt_LSP_TRAIN  NO

/*---------------------------------------------------------------------------*/
/* POST FILTER                                                               */
/*---------------------------------------------------------------------------*/
#define ntt_POSTFILT   YES
#if ntt_POSTFILT
#    define ntt_PF_SW_BIT  2
#else
#    define ntt_PF_SW_BIT  0
#endif
#define ntt_PF_OFF     0      /* Post Filtering off */
#define ntt_PF_LOW     1
#define ntt_PF_MID     2
#define ntt_PF_HIGH    3

/*---------------------------------------------------------------------------*/
/* BIRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/
#define ntt_NTITLE_BITS   16
#define ntt_NCOMMENT_BITS 16
#define ntt_CHAR_BITS      8
#define ntt_CH_MODE_BITS   2
#define ntt_ISAMPF_BITS    6
#define ntt_IBPS_BITS      8

#define ntt_NBITS_FR_MAX \
((int)(ntt_N_FR_MAX*ntt_BPS_MAX/ntt_SAMPF_MIN)) /* Number of bits per frame */
#define ntt_NBITS_FR_MIN \
((int)(ntt_N_FR_MIN*ntt_BPS_MIN/ntt_SAMPF_MAX)) /* Number of bits per frame */

#define ntt_SIDE_INF_MAX \
(GAIN_BIT_MAX+ntt_LSP_SPLIT_MAX*ntt_LSP_BIT2_MAX+ntt_LSP_BIT1_MAX+ntt_LSP_BIT0_MAX+ntt_BASF_BIT)
#define ntt_SIDE_INF_MIN \
(ntt_GAIN_BITS_MIN+ntt_LSP_SPLIT_MIN*ntt_LSP_BIT2_MIN+ntt_LSP_BIT1_MIN+ntt_LSP_BIT0_MIN)

#define ntt_SUB_FRAME_LSP  NO
#    define ntt_SIDE_INF_FR_MAX \
(ntt_SIDE_INF_SW+ntt_LSP_SPLIT_MAX*ntt_LSP_BIT2_MAX+ntt_LSP_BIT1_MAX+ntt_LSP_BIT0_MAX+GAIN_BIT_MAX)
#    define ntt_SIDE_INF_S_MIN (ntt_GAIN_BITS_MIN+ntt_SUB_GAIN_BITS_MIN*ntt_N_SHRT_MIN)
#    define ntt_SIDE_INF_FR_MIN \
(ntt_LSP_SPLIT_MIN*ntt_LSP_BIT2_MIN+ntt_LSP_BIT1_MIN+ntt_LSP_BIT0_MIN+ntt_SIDE_INF_S_MIN)

#define ntt_TBIT_MAX \
(ntt_NBITS_FR_MAX-ntt_SIDE_INF_MIN-ntt_FW_TBIT_MIN-ntt_SIDE_INF_SW)
#define ntt_TBIT_MIN \
(ntt_NBITS_FR_MIN-ntt_SIDE_INF_MAX-ntt_FW_TBIT_MAX-ntt_SIDE_INF_SW)

#define ntt_TBIT_S_MAX \
(ntt_NBITS_FR_MAX-ntt_FW_TBIT_S_MIN*ntt_T_SHRT_MIN-ntt_SIDE_INF_FR_MIN*ntt_N_SUP_MIN-ntt_SIDE_INF_SW)

#define ntt_TBIT_M_MAX \
(ntt_NBITS_FR_MAX-ntt_FW_TBIT_M_MIN*ntt_T_MID_MIN-ntt_SIDE_INF_FR_MIN*ntt_N_SUP_MIN-ntt_SIDE_INF_SW)

/*---------------------------------------------------------------------------*/
/* RESIDUAL SIGNAL QUANTIZATION                                              */
/*---------------------------------------------------------------------------*/
#define ntt_MAXBIT_SHAPE     6
#define ntt_POLBITS          1    /* num bits for polarity per channel */
#define ntt_MAXBIT (ntt_MAXBIT_SHAPE+ntt_POLBITS)     /* max bit per channel */
#define	ntt_CB_SIZE (0x1 << ntt_MAXBIT_SHAPE)
#define	ntt_N_DIV_MAX  500
#define ntt_CB_LEN_MAX 256
#define ntt_CB_LEN_MGN 16

#define	ntt_N_DIV_S_MAX	500
#define ntt_CB_LEN_S_MAX   256

#define	ntt_N_DIV_M_MAX	500
#define ntt_CB_LEN_M_MAX   256

#define ntt_N_CAN_MAX 256
#define ntt_N_CAN_MIN  1

typedef struct {
    int wvq[ntt_max(ntt_N_DIV_MAX*2,ntt_N_DIV_S_MAX*2)];
    int fw[ntt_FW_N_DIV_MX*ntt_N_SUP_MAX];
    int fw_alf[ntt_N_SHRT_MAX*ntt_N_SUP_MAX];
    int pow[(ntt_N_SHRT_MAX+1)*ntt_N_SUP_MAX];
    int lsp[ntt_N_SUP_MAX][ntt_LSP_NIDX_MAX];
    int pit[ntt_N_SUP_MAX];
    int pls[ntt_N_DIV_P_MAX*2];
    int pgain[ntt_N_SUP_MAX];
    int blim_h[ntt_N_SUP_MAX];
    int blim_l[ntt_N_SUP_MAX];
    int pf;
    int w_type;
} ntt_INDEX;

typedef struct{
    int fine_sw;
    int speech_sw;
    int ntt_param_set_flag;  /* used for VM execution control */
} ntt_PARAM;


/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/**********************  EXTERNAL VARIABLES  *********************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#ifdef ntt_MAIN_ROUTINE

/*---------------------------------------------------------------------------*/
/* PROGRAM MODE                                                              */
/*---------------------------------------------------------------------------*/

int ntt_ISAMPF;              /* ID number of sampling frequency   */
int ntt_IBPS;                /* ID number of bitrate              */

/* mode table to assign ID numbers */
int ntt_isampf_t[] ={
    8,        /* mode 0 */
   11,        /* mode 1 */
   12,        /* mode 2 */
   16,        /* mode 3 */
   22,        /* mode 4 */
   24,        /* mode 5 */
   32,        /* mode 6 */
   44,        /* mode 7 */
   48 };      /* mode 8 */
int ntt_nisampft=9;

int ntt_ibps_t[] ={
    2,         /* mode 0 */
    4,         /* mode 1 */ 
    5,         /* mode 2 */ 
    6,	       /* mode 3 */ 
    8,         /* mode 4 */ 
    13,        /* mode 5 */ 
    14,        /* mode 6 */ 
    15,        /* mode 7 */ 
    16,        /* mode 8 */ 
    18,        /* mode 9 */ 
    24,        /* mode 10 */
    28,        /* mode 11 */
    32,        /* mode 12 */
    40,        /* mode 13 */
    56,        /* mode 14 */
    64,        /* mode 15 */
   112,        /* mode 16 */
   128};       /* mode 17 */
int ntt_nibpst=18;


int ntt_CH_MODE;             /* Channel mode */
int ntt_N_SUP;               /* Number of frame per superframe */

double ntt_SAMPF;
double ntt_BPS;

int ntt_N_FR, ntt_N_FR_EX;
int ntt_N_SHRT, ntt_N_MID;
int ntt_N_FR_S, ntt_N_FR_S_EX;
int ntt_N_FR_M, ntt_N_FR_M_EX;
int ntt_N_FR_WDW, ntt_N_FR_S_WDW, ntt_N_FR_M_WDW;

double ntt_BAND_EXP;

/*---------------------------------------------------------------------------*/
/* GAIN QUANTIZATION                                                         */
/*---------------------------------------------------------------------------*/
int    ntt_GAIN_BITS, ntt_NUM_STEP;
double ntt_AMP_MAX, ntt_MU, ntt_STEP;
int    ntt_SUB_GAIN_BITS, ntt_SUB_NUM_STEP;
double ntt_SUB_AMP_MAX, ntt_SUB_STEP;

/*---------------------------------------------------------------------------*/
/* LSP QUANTIZATION                                                          */
/*---------------------------------------------------------------------------*/
int   ntt_N_PR;
char  *ntt_LSPCODEBOOK;
int   ntt_LSP_BIT0, ntt_LSP_BIT1, ntt_LSP_BIT2, ntt_LSP_SPLIT;
int   ntt_N_MODE, ntt_NC0, ntt_NC1;
int   ntt_lsp_csize_base[ntt_LSP_NSTAGE], ntt_lsp_cdim_base[ntt_LSP_NSTAGE];
/*
int    ntt_isp[ntt_NSP_MAX+1];
*/
double *lsp_code_base;
double *lsp_fgcode_base;

/*---------------------------------------------------------------------------*/
/* FORWARD ENVELOPE QUANTIZATION                                             */
/*---------------------------------------------------------------------------*/
char *ntt_FW_CB_NAME, *ntt_FW_CB_NAME_S, *ntt_FW_CB_NAME_M;
int  ntt_FW_N_DIV, ntt_FW_N_DIV_S, ntt_FW_N_DIV_M;
int  ntt_FW_N_BIT, ntt_FW_N_BIT_S, ntt_FW_N_BIT_M;
int  ntt_FW_CB_SIZE, ntt_FW_CB_LEN, ntt_FW_CB_SIZE_S, ntt_FW_CB_LEN_S;
int  ntt_FW_CB_SIZE_M, ntt_FW_CB_LEN_M;
int  ntt_N_CRB, ntt_N_CRB_S, ntt_N_CRB_M;
int  *ntt_crb_tbl, *ntt_crb_tbl_s, *ntt_crb_tbl_m;

double *ntt_fwcodev, *ntt_fwcodevm, *ntt_fwcodevs;


/*---------------------------------------------------------------------------*/
/* PITCH EXCITATION                                                          */
/*---------------------------------------------------------------------------*/
int ntt_BASF_BIT, ntt_BASF_STEP;
int ntt_N_PULSE, ntt_T_PULSE, ntt_PLS_OFST;
int ntt_PIT_N_BIT, ntt_PIT_CB_SIZE, ntt_PIT_CB_LEN;
int ntt_PIT_TBIT;
char *ntt_PIT_CB_NAME;
int ntt_PGAIN_BIT, ntt_PGAIN_NSTEP;
double ntt_PGAIN_STEP, ntt_PGAIN_MU;
int ntt_N_DIV_P, ntt_PIT_SHRT, ntt_N_FR_P;
int ntt_TBIT_P;
int ntt_CB_LEN_P;

double ntt_codevp0[ntt_PIT_CB_SIZE_MAX][ntt_CB_LEN_P_MAX];
short  ntt_BIT_REVp[ntt_T_FR_MAX];
short  ntt_SMP_ACCp[ntt_N_DIV_P_MAX];
int  ntt_N_CAN_P;

/*---------------------------------------------------------------------------*/
/* BITRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/
int ntt_NBITS_FR;
int  ntt_NMTOOL_BITS, ntt_NMTOOL_BITS_M, ntt_NMTOOL_BITS_S;
int  ntt_VQTOOL_BITS, ntt_VQTOOL_BITS_M, ntt_VQTOOL_BITS_S;

/*---------------------------------------------------------------------------*/
/* RESIDUAL SIGNAL QUANTIZATION                                              */
/*---------------------------------------------------------------------------*/

char *ntt_CB_NAME0, *ntt_CB_NAME1;
char *ntt_CB_NAME0m, *ntt_CB_NAME1m;
char *ntt_CB_NAME0s, *ntt_CB_NAME1s;
int  ntt_N_CAN, ntt_N_CAN_S, ntt_N_CAN_M;
int  ntt_CB_LEN_READ, ntt_CB_LEN_READ_M, ntt_CB_LEN_READ_S;

double	*ntt_codev0, *ntt_codev1;
double	*ntt_codev0m, *ntt_codev1m;
double	*ntt_codev0s, *ntt_codev1s;

/*---------------------------------------------------------------------------*/
/* BANDWIDTH CONTROL                                                         */
/*---------------------------------------------------------------------------*/

int    ntt_BLIM_BITS_H, ntt_BLIM_BITS_L, ntt_BWID_BITS, ntt_BLIM_STEP_H;
double ntt_CUT_M_H, ntt_CUT_M_L;
double ntt_BAND_UPPER, ntt_BAND_LOWER;

/*---------------------------------------------------------------------------*/
/* SIN TABLE FOR MDCT WINDOWING                                              */
/*---------------------------------------------------------------------------*/

double ntt_sinTwdl[ntt_N_FR_MAX], ntt_sinTwds[ntt_N_FR_S_MAX], ntt_sinTwdm[ntt_N_FR_M_MAX];
double ntt_cos_TT[ntt_N_FR_MAX*2];

/*<<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<>><<*/

#else
/*---------------------------------------------------------------------------*/
/* PROGRAM MODE                                                              */
/*---------------------------------------------------------------------------*/

extern int ntt_ISAMPF;              /* ID number of sampling frequency   */
extern int ntt_IBPS;                /* ID number of bitrate              */

/* mode table to assign ID numbers */
extern int ntt_isampf_t[];
extern int ntt_nisampft;

extern int ntt_ibps_t[];
extern int ntt_nibpst;

extern int ntt_CH_MODE;             /* Channel mode */
extern int ntt_N_SUP;               /* Number of frame per superframe */

extern double ntt_SAMPF;
extern double ntt_BPS;

extern int ntt_N_FR, ntt_N_FR_EX;
extern int ntt_N_SHRT, ntt_N_MID;
extern int ntt_N_FR_S, ntt_N_FR_S_EX;
extern int ntt_N_FR_M, ntt_N_FR_M_EX;
extern int ntt_N_FR_WDW, ntt_N_FR_S_WDW, ntt_N_FR_M_WDW;

extern double ntt_BAND_EXP;

/*---------------------------------------------------------------------------*/
/* GAIN QUANTIZATION                                                         */
/*---------------------------------------------------------------------------*/
extern int    ntt_GAIN_BITS, ntt_SUB_GAIN_BITS, ntt_NUM_STEP;
extern double ntt_AMP_MAX, ntt_MU, ntt_STEP;
extern int    ntt_SUB_GAIN_BITS, ntt_SUB_NUM_STEP;
extern double ntt_SUB_AMP_MAX, ntt_SUB_STEP;

/*---------------------------------------------------------------------------*/
/* LSP QUANTIZATION                                                          */
/*---------------------------------------------------------------------------*/
extern int   ntt_N_PR;
extern char  *ntt_LSPCODEBOOK;
extern int   ntt_LSP_BIT0, ntt_LSP_BIT1, ntt_LSP_BIT2, ntt_LSP_SPLIT;
extern int   ntt_N_MODE, ntt_NC0, ntt_NC1;
extern int   ntt_lsp_csize_base[ntt_LSP_NSTAGE], ntt_lsp_cdim_base[ntt_LSP_NSTAGE];
/*
extern int ntt_isp[ntt_NSP_MAX+1];
*/
extern double *lsp_code_base;
extern double *lsp_fgcode_base;
/*---------------------------------------------------------------------------*/
/* FORWARD ENVELOPE QUANTIZATION                                             */
/*---------------------------------------------------------------------------*/
extern char *ntt_FW_CB_NAME, *ntt_FW_CB_NAME_S, *ntt_FW_CB_NAME_M;
extern int  ntt_FW_N_DIV, ntt_FW_N_DIV_S, ntt_FW_N_DIV_M;
extern int  ntt_FW_N_BIT, ntt_FW_N_BIT_S, ntt_FW_N_BIT_M;
extern int  ntt_FW_CB_SIZE, ntt_FW_CB_LEN, ntt_FW_CB_SIZE_S, ntt_FW_CB_LEN_S;
extern int  ntt_FW_CB_SIZE_M, ntt_FW_CB_LEN_M;
extern int  ntt_N_CRB, ntt_N_CRB_S, ntt_N_CRB_M;
extern int  *ntt_crb_tbl, *ntt_crb_tbl_s, *ntt_crb_tbl_m;

extern double *ntt_fwcodev, *ntt_fwcodevm, *ntt_fwcodevs;

/*---------------------------------------------------------------------------*/
/* PITCH EXCITATION                                                          */
/*---------------------------------------------------------------------------*/
extern int ntt_BASF_BIT, ntt_BASF_STEP;
extern int ntt_N_PULSE, ntt_T_PULSE, ntt_PLS_OFST;
extern int ntt_PIT_N_BIT, ntt_PIT_CB_SIZE, ntt_PIT_CB_LEN;
extern int ntt_PIT_TBIT;
extern char *ntt_PIT_CB_NAME;
extern int ntt_PGAIN_BIT, ntt_PGAIN_NSTEP;
extern double ntt_PGAIN_STEP, ntt_PGAIN_MU;
extern int ntt_N_DIV_P, ntt_PIT_SHRT, ntt_N_FR_P;
extern int ntt_TBIT_P;   /* total bits for pitch VQ */
extern int ntt_CB_LEN_P; /* dimension of pitch VQ */

extern double ntt_codevp0[ntt_PIT_CB_SIZE_MAX][ntt_CB_LEN_P_MAX];
extern short  ntt_BIT_REVp[ntt_T_FR_MAX];
extern short  ntt_SMP_ACCp[ntt_N_DIV_P_MAX];
extern int  ntt_N_CAN_P;

/*---------------------------------------------------------------------------*/
/* BITRATE CONTROL                                                           */
/*---------------------------------------------------------------------------*/
extern int ntt_NBITS_FR;
extern int  ntt_NMTOOL_BITS, ntt_NMTOOL_BITS_M, ntt_NMTOOL_BITS_S;
extern int  ntt_VQTOOL_BITS, ntt_VQTOOL_BITS_M, ntt_VQTOOL_BITS_S;

/*---------------------------------------------------------------------------*/
/* RESIDUAL SIGNAL QUANTIZATION                                              */
/*---------------------------------------------------------------------------*/

extern char *ntt_CB_NAME0, *ntt_CB_NAME1;
extern char *ntt_CB_NAME0m, *ntt_CB_NAME1m;
extern char *ntt_CB_NAME0s, *ntt_CB_NAME1s;
extern int  ntt_N_CAN, ntt_N_CAN_S, ntt_N_CAN_M;
extern int  ntt_CB_LEN_READ, ntt_CB_LEN_READ_M, ntt_CB_LEN_READ_S;

extern double	*ntt_codev0, *ntt_codev1;
extern double	*ntt_codev0m, *ntt_codev1m;
extern double	*ntt_codev0s, *ntt_codev1s;

/*---------------------------------------------------------------------------*/
/* BANDWIDTH CONTROL                                                         */
/*---------------------------------------------------------------------------*/

extern int    ntt_BLIM_BITS_H, ntt_BLIM_BITS_L, ntt_BWID_BITS, ntt_BLIM_STEP_H;
extern double ntt_CUT_M_H, ntt_CUT_M_L;
extern double ntt_BAND_UPPER, ntt_BAND_LOWER;

/*---------------------------------------------------------------------------*/
/* SIN TABLE FOR MDCT WINDOWING                                              */
/*---------------------------------------------------------------------------*/

extern double ntt_sinTwdl[ntt_N_FR_MAX], ntt_sinTwds[ntt_N_FR_S_MAX], ntt_sinTwdm[ntt_N_FR_M_MAX];
extern double ntt_cos_TT[ntt_N_FR_MAX*2];

#endif

/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/************************  PARAMETER TABLES **********************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

typedef struct {
    double sampf;          /* sampling frequency                       */
    int    n_fr;	   /* frame size                               */
    double band_exp;	   /* Lagwindow band expansion factor (Hz)     */
    int    n_shrt;	   /* Number of division for short frame       */
    int    n_mid;	   /* Number of division for medium frame      */
    int    gain_bits;      /* Gain quantization bits                   */
    double amp_max;        /* Maximum gain                             */
    int    sub_gain_bits;  /* Sub gain quantization bits               */
    double sub_amp_max;    /* Maximum sub-gain                         */
    double mu;             /* mu factor of mu-law gain coding          */
    int    n_pr;	   /* LPC order                                */
    char   *lspcodebook;   /* LSP codebook name                        */ 
    int    lsp_bit0;	   /* num of bits for prediction switch        */
    int    lsp_bit1;	   /* num of bits at first stage               */
    int    lsp_bit2;	   /* num of bits per split vq at second stage */
    int    lsp_split;	   /* num of split at second stage             */
    char   *fw_cb_name;	   /* Env. codebook name                       */
    char   *fw_cb_name_s;  /* Env. codebook name                       */
    char   *fw_cb_name_m;  /* Env. codebook name                       */
    int    fw_n_div;	   /* Number of division of envelope codebook  */
    int    fw_n_div_s;	   /* Num. div. of env. cb (short frame)       */
    int    fw_n_div_m;	   /* Num. div. of env. cb (medium frame)      */
    int    fw_n_bit;	   /* Envelope codebook bits                   */
    int    fw_n_bit_s;	   /* Envelope codebook bits (short)           */
    int    fw_n_bit_m;	   /* Envelope codebook bits (short)           */
    char   *pit_cb_name;   /* Pitch pulse shape codebook name          */
    int    basf_bit;       /* Base frequency qnt. bits for pitch excit.*/
    int    n_can_p;        /* pre-selection candidates   for pitch VQ  */
    int    pit_n_bit;      /* Number of bits for pulse shape coding    */
    int    pit_cb_len;     /* Number of samples for pulse shape coding */
    int    pgain_bit;      /* Pitch gain quantization bits             */
    int    pgain_mu;       /* Mu-coefficient of the pitch gain qnt.    */
    char   *cb_name0;	   /* shape codebook (long 0)                  */
    char   *cb_name1;	   /* shape codebook (long 1)                  */
    char   *cb_name0s;	   /* shape codebook (short 0)                 */
    char   *cb_name1s;	   /* shape codebook (short 1)                 */
    char   *cb_name0m;	   /* shape codebook (medium 1)                */
    char   *cb_name1m;	   /* shape codebook (medium 1)                */
    int    n_can;	   /* pre-selection candidates                 */
    int    n_can_s;	   /* pre-selection candidates (short frame)   */
    int    n_can_m;	   /* pre-selection candidates (short frame)   */
    int    blim_bits_h;    /* bits for higher bandwidth control        */
    int    blim_bits_l;    /* bits for lower bandwidth control         */
    double cut_m_h;        /* minimum bandwidth ratio (higher part)    */
    double cut_m_l;        /* maximum bandwidth ratio (lower part)     */
    double band_upper;     /* implicit bandwidth                       */
} ntt_MODE_TABLE;

#ifdef ntt_MAIN_ROUTINE

ntt_MODE_TABLE ntt_mode_48_40 ={ /* 48kHz-40kbit/s */
    48000.0, /* sampling frequency */
    2048,    /* frame size */
    960.0,   /* Lagwindow band expansion factor (Hz) */
    16,      /* Number of division for short frame */
    4,       /* Number of division for medium frame */
    10,      /* Gain quantization bits */
    10000.,
    6,       /* Sub-gain quantization bits */
    4500.,
    100.,
    20,      /* LPC order */
    "./tables/tf_vq_tbls/20b23s48.ssp", /* LSP codebook name */
    1,       /* num of bits for prediction switch */
    6,       /* num of bits at first stage */
    4,       /* num of bits per split vq at second stage */ 
    4,       /* num of split at second stage */
    "./tables/tf_vq_tbls/fcd4840",  /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4840s", /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4840m", /* Env. codebook name */
    32,      /* Number of division of envelope codebook */
    2,       /* Num. div. of env. cb (short frame) */
    16,      /* Num. div. of env. cb (medium frame) */
    5,       /* Envelope codebook bits */
    6,       /* Envelope codebook bits (short) */
    6,       /* Envelope codebook bits (medium) */
    "./tables/tf_vq_tbls/pcd4840", /* Pitch pulse shape codebook name */
    0,      /* Base frequency quantization bits for pitch excit. */
    0,      /* Number of pitch pulses */
    0,       /* Number of bits for pulse shape coding */
    0,       /* Number of pulses for pulse shape coding */
    0,       /* Pitch gain quantization bits */
    200,     /* Mu-coefficient of the pitch gain quantization */
    "./tables/tf_vq_tbls/cd4840_0",  /* shape codebook (long 0) */
    "./tables/tf_vq_tbls/cd4840_1",	 /* shape codebook (long 1) */
    "./tables/tf_vq_tbls/cd4840_2",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd4840_3",	/* shape codebook (short 1) */
    "./tables/tf_vq_tbls/cd4840_4",	/* shape codebook (medium 0) */
    "./tables/tf_vq_tbls/cd4840_5",	/* shape codebook (medium 1) */
    6,                  /* pre-selection candidates */
    6,                  /* pre-selection candidates (short frame)   */
    6,                  /* pre-selection candidates (medium frame)   */
    3,            /* bits for higher bandwidth control        */
    1,            /* bits for lower bandwidth control         */
    0.5,          /* minimum bandwidth ratio (higher part)    */
    0.005,        /* maximum bandwidth ratio (lower part)     */
    1.0};         /* implicit bandwidth                       */

ntt_MODE_TABLE ntt_mode_48_24 ={ /* 48kHz-24kbit/s */
    48000.0, /* sampling frequency */
    2048,    /* frame size */
    960.0,   /* Lagwindow band expansion factor (Hz) */
    16,      /* Number of division for short frame */
    4,      /* Number of division for short frame */
    10,      /* Gain quantization bits */
    10000.,
    5,       /* Sub-gain quantization bits */
    4700.,
    100.,
    20,      /* LPC order */
    "./tables/tf_vq_tbls/20b23s48.ssp", /* LSP codebook name */
    1,       /* num of bits for prediction switch */
    6,       /* num of bits at first stage */
    4,       /* num of bits per split vq at second stage */ 
    3,       /* num of split at second stage */
    "./tables/tf_vq_tbls/fcd4824",  /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4824s", /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4824m", /* Env. codebook name */
    16,      /* Number of division of envelope codebook */
    2,       /* Num. div. of env. cb (short frame) */
    8,       /* Num. div. of env. cb (medium frame) */
    6,       /* Envelope codebook bits */
    5,       /* Envelope codebook bits (short) */
    5,       /* Envelope codebook bits (short) */
    "./tables/tf_vq_tbls/pcd4824", /* Pitch pulse shape codebook name */
    0,      /* Base frequency quantization bits for pitch excit. */
    0,      /* NCAN_P Number of pitch pulses */
    0,       /* Number of bits for pulse shape coding */
    0,       /* Number of pulses for pulse shape coding */
    0,       /* Pitch gain quantization bits */
    200,     /* Mu-coefficient of the pitch gain quantization */
    "./tables/tf_vq_tbls/cd4824_0",  /* shape codebook (long 0) */
    "./tables/tf_vq_tbls/cd4824_1",	 /* shape codebook (long 1) */
    "./tables/tf_vq_tbls/cd4824_2",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd4824_3",	/* shape codebook (short 1) */
    "./tables/tf_vq_tbls/cd4824_4",	/* shape codebook (medium 0) */
    "./tables/tf_vq_tbls/cd4824_5",	/* shape codebook (medium 1) */
    6,                 /* pre-selection candidates */
    6,                 /* pre-selection candidates (short frame)   */
    6,                 /* pre-selection candidates (medium frame)   */
    2,            /* bits for higher bandwidth control        */
    1,            /* bits for lower bandwidth control         */
    0.7,          /* minimum bandwidth ratio (higher part)    */
    0.0025,        /* maximum bandwidth ratio (lower part)     */
    0.5};         /* implicit bandwidth                       */

ntt_MODE_TABLE ntt_mode_48_06 ={ /* 48kHz-6kbit/s */
    48000.0, /* sampling frequency */
    2048,    /* frame size */
    960.0,   /* Lagwindow band expansion factor (Hz) */
    16,      /* Number of division for short frame */
    4,      /* Number of division for short frame */
    9,      /* Gain quantization bits */
    16000./*10000.*/,
    4,       /* Sub-gain quantization bits */
    4700.,
    100.,
    20,      /* LPC order */
    "./tables/tf_vq_tbls/20b19s48_scl0.ssp",/*16b19s48.ssp*/ /* LSP codebook name */
    1,       /* num of bits for prediction switch */
    6,       /* num of bits at first stage */
    4,       /* num of bits per split vq at second stage */ 
    3,       /* num of split at second stage */
    "./tables/tf_vq_tbls/fcd4806",  /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4806s", /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd4806m", /* Env. codebook name */
    7,      /* Number of division of envelope codebook */
    1,       /* Num. div. of env. cb (short frame) */
    2,       /* Num. div. of env. cb (medium frame) */
    6,       /* Envelope codebook bits */
    0,       /* Envelope codebook bits (short) */
    0,       /* Envelope codebook bits (medium) */
    "./tables/tf_vq_tbls/pcd4806", /* Pitch pulse shape codebook name */
    0,      /* Base frequency quantization bits for pitch excit. */
    0,      /* NCAN_P Number of pitch pulses */
    0,       /* Number of bits for pulse shape coding */
    0,       /* Number of pulses for pulse shape coding */
    0,       /* Pitch gain quantization bits */
    200,     /* Mu-coefficient of the pitch gain quantization */
    "./tables/tf_vq_tbls/cd4806_0",  /* shape codebook (long 0) */
    "./tables/tf_vq_tbls/cd4806_1",	 /* shape codebook (long 1) */
    "./tables/tf_vq_tbls/cd4806_2",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd4806_3",	/* shape codebook (short 1) */
    "./tables/tf_vq_tbls/cd4806_4",	/* shape codebook (medium 0) */
    "./tables/tf_vq_tbls/cd4806_5",	/* shape codebook (medium 1) */
    6,                 /* pre-selection candidates */
    6,                 /* pre-selection candidates (short frame)   */
    6,                 /* pre-selection candidates (medium frame)   */
    0,            /* bits for higher bandwidth control        */
    0,            /* bits for lower bandwidth control         */
    0.7,          /* minimum bandwidth ratio (higher part)    */
    0.0025,        /* maximum bandwidth ratio (lower part)     */
    0.16667};     /* implicit bandwidth                       */

ntt_MODE_TABLE ntt_mode_16_16 ={ /* 16kHz-16kbit/s */
    16000.0, /* sampling frequency */
    512,     /* frame size */
    320.0,   /* Lagwindow band expansion factor (Hz) */
    8,       /* Number of division for short frame */
    2,       /* Number of division for medium frame */
    8,       /* gain quantization bit */
    10000.,  /* max amp */
    5,       /* sub gain */
    4500.,   /* max subamp */
    100.,    /* mu amp */
    16,      /* LPC order */
    "./tables/tf_vq_tbls/16b19s16.ssp", /* LSP codebook name */
    1,       /* num of bits for prediction switch */
    6,       /* num of bits at first stage */
    4,       /* num of bits per split vq at second stage */ 
    3,       /* num of split at second stage */
    "./tables/tf_vq_tbls/fcd1616",  /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd1616s", /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd1616m", /* Env. codebook name */
    3,       /* Number of division of envelope codebook */
    1,       /* Num. div. of env. cb (short frame) */
    2,       /* Num. div. of env. cb (medium frame) */
    6,       /* Envelope codebook bits */
    5,       /* Envelope codebook bits (short) */
    5,       /* Envelope codebook bits (medium) */
    "./tables/tf_vq_tbls/pcd1616", /* Pitch pulse shape codebook name */
    9,      /* Base frequency quantization bits for pitch excit. */
    18,      /* pre-selection candidates */ 
    28,     /* Number of bits for pulse shape coding */
    30,     /* Number of pulses for pulse shape coding */
    7,      /* Pitch gain quantization bits */
    200,    /* Mu-coefficient of the pitch gain quantization */
    "./tables/tf_vq_tbls/cd1616_0",  /* shape codebook (long 0) */
    "./tables/tf_vq_tbls/cd1616_1",	 /* shape codebook (long 1) */
    "./tables/tf_vq_tbls/cd1616_2",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd1616_3",	/* shape codebook (short 1) */
    "./tables/tf_vq_tbls/cd1616_4",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd1616_5",	/* shape codebook (short 1) */
    16,                 /* pre-selection candidates */
    16,                 /* pre-selection candidates */
    16,                 /* pre-selection candidates (short frame)   */
    2,            /* bits for higher bandwidth control        */
    1,            /* bits for lower bandwidth control         */
    0.7,          /* minimum bandwidth ratio (higher part)    */
    0.005,        /* maximum bandwidth ratio (lower part)     */
    1.0};         /* implicit bandwidth                       */

ntt_MODE_TABLE ntt_mode_08_06 ={ /* 8kHz-6kbit/s */
    8000.0, /* sampling frequency */
    512,     /* frame size */
    240.0,   /* Lagwindow band expansion factor (Hz) */
    8,       /* Number of division for short frame */
    2,       /* Number of division for medium frame */
    8,       /* gain quantization bit */
    13000.,  /* max amp */
    5,       /* sub gain */
    4500.,   /* max subamp */
    100.,    /* mu amp */
    12,      /* LPC order */
    "./tables/tf_vq_tbls/12b15s08.ssp", /* LSP codebook name */
    1,       /* num of bits for prediction switch */
    5,       /* num of bits at first stage */
    3,       /* num of bits per split vq at second stage */ 
    3,       /* num of split at second stage */
    "./tables/tf_vq_tbls/fcd0806",  /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd0806s", /* Env. codebook name */
    "./tables/tf_vq_tbls/fcd0806m", /* Env. codebook name */
    3,       /* Number of division of envelope codebook */
    1,       /* Num. div. of env. cb (short frame) */
    2,       /* Num. div. of env. cb (medium frame) */
    6,       /* Envelope codebook bits */
    5,       /* Envelope codebook bits (short) */
    5,       /* Envelope codebook bits (medium) */
    "./tables/tf_vq_tbls/pcd0806", /* Pitch pulse shape codebook name */
    8,      /* Base frequency quantization bits for pitch excit. */
    8,      /* pre-selection candidates */ 
    28,     /* Number of bits for pulse shape coding */
    20,     /* Number of pulses for pulse shape coding */
    6,      /* Pitch gain quantization bits */
    200,    /* Mu-coefficient of the pitch gain quantization */
    "./tables/tf_vq_tbls/cd0806_0",  /* shape codebook (long 0) */
    "./tables/tf_vq_tbls/cd0806_1",	 /* shape codebook (long 1) */
    "./tables/tf_vq_tbls/cd0806_2",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd0806_3",	/* shape codebook (short 1) */
    "./tables/tf_vq_tbls/cd0806_4",	/* shape codebook (short 0) */
    "./tables/tf_vq_tbls/cd0806_5",	/* shape codebook (short 1) */
    16,                 /* pre-selection candidates */
    16,                 /* pre-selection candidates */
    16,                 /* pre-selection candidates (short frame)   */
    0,            /* bits for higher bandwidth control        */
    0,            /* bits for lower bandwidth control         */
    0.7,          /* minimum bandwidth ratio (higher part)    */
    0.005,        /* maximum bandwidth ratio (lower part)     */
    1.0};         /* implicit bandwidth                       */
#else
extern ntt_MODE_TABLE ntt_mode_48_40;
extern ntt_MODE_TABLE ntt_mode_48_24;
extern ntt_MODE_TABLE ntt_mode_48_06;
extern ntt_MODE_TABLE ntt_mode_16_16;
extern ntt_MODE_TABLE ntt_mode_08_06;
#endif


/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/****************************  FUNCTIONS  ************************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

  /*--- VM socket modules ---*/
  /* encoder */
  void ntt_vq_coder
    (double      *sig_init[MAX_TIME_CHANNELS],
     double      *sig[MAX_TIME_CHANNELS], /* Input: time-domain signal array */
     double      *spectral_line_vector[MAX_TIME_CHANNELS],
     /* Input : frequency-domain signal array    */
     double      external_pw[], /* Input : external perceptual weight       */
     int         pw_select,	/* Input : perceptual weight mode selector  */
     int         block_type,	/* Input : window block type                */
     ntt_INDEX   *index,	/* Output: quantization indexes             */
     ntt_PARAM   *param_ntt,	/* Input : encoder parameters               */
     int         available_bits,/* Input : number of available bits         */
     double      lpc_spectrum[], /* Output: LPC spectrum                     */
     double      *reconstructed_spectrum[MAX_TIME_CHANNELS]);
                                /* Output: reconstructed spectrum */

  int ntt_SclBitPack(ntt_INDEX   *indexp,
		     BsBitStream *stream,
		     int         iscl);
  
  /* decoder */
  void ntt_vq_decoder
    (ntt_INDEX  *index,
     double     *spectral_line_vector[MAX_TIME_CHANNELS]);
  
  void ntt_scale_vq_decoder(ntt_INDEX  index_scl[],
			    double *spectral_line_vector[MAX_TIME_CHANNELS],
			    int    iscl);

  void ntt_tf_local_decode
    (/* Input */
     ntt_INDEX *index,
     double    lpc_spectrum[],
     double    bark_env[],
     double    pitch_sequence[],
     double    gain[],
     double    spectrum_gain,
     /* Output */
     double    *reconstructed_spectrum[MAX_TIME_CHANNELS]);

  void ntt_scale_vq_coder(double    *spectral_line_vector[MAX_TIME_CHANNELS],
			  double    lpc_spectrum[],
			  ntt_INDEX *index,
			  ntt_INDEX *index_scl,
			  ntt_PARAM *param_ntt,
			  int       available_bits,
			  double    *reconstructed_spectrum[MAX_TIME_CHANNELS],
			  int       iscl);

  int ntt_SclBitUnPack(BsBitStream *fixed_stream,
		       ntt_INDEX   index[],
		       int         iscl);
  void ntt_vec_lenp(int bits[],
		    int length[]);

  void ntt_init();

  void ntt_fwex(int    index[],
		int    ndiv,
		int    cv_len,
		double *codebook,
		int    cv_len_max,
		double env[]);

  void   ntt_movdd(int n, double xx[], double yy[]);

  double ntt_mulawinv(double y, double xmax, double mu);

  void ntt_lsp_decw(/* Parameters */
                  int    n_pr,
                  int    nsp,
                  double code[][ntt_N_PR_MAX],
                  double fgcode[][ntt_MA_NP][ntt_N_PR_MAX],
                  int    *csize,
                  int    *cdim,
                  double buf_prev[ntt_MA_NP][ntt_N_PR_MAX+1],
                  int    ma_np,
                  /* Input */
                  int    i_sup,
                  int    index[],
                  /* Output */
                  double freq[]);

  void ntt_lsptowt_int(int nfr,
		       int n_pr,
		       double lsp[],
		       double wt[]);

  void ntt_cp_mdtbl(ntt_MODE_TABLE ltbl);
  
  void ntt_cnst_chk(int  calcv,
		    int  defv,
		    char *defname);

  void ntt_get_code(char *fname,
		    int nstage,
		    int csize[],
		    int cdim[],
		    double code[][ntt_N_PR_MAX],
		    double fgcode[ntt_N_MODE_MAX][ntt_MA_NP][ntt_N_PR_MAX]);

  void ntt_get_cdbk(char *name,
		    double *codev_l,
		    int cb_size,
		    int cb_len,
		    int cb_len_mx);

  void ntt_set_interleave(enum ntt_INTERLEAVE_SET_MODE set_mode);

  void ntt_set_isp(int nsp, int n_pr, int *ntt_isp);

  void ntt_redec(int n_pr,
               int index[],
               int csize1[],
               int nsp,
               double code[][ntt_N_PR_MAX],
               double fgcode[][ntt_MA_NP][ntt_N_PR_MAX],
               double fg_sum[ntt_N_PR_MAX],
               double pred_vec[ntt_N_PR_MAX],
               double lspq[],
               double out_vec[]);

  void ntt_dist_lsp(int n, double x[], double y[], double w[], double *dist);

  void ntt_check_lsp(int n, double buf[], double min_gap);

  void ntt_check_lsp_sort(int n, double buf[]);

  void   ntt_zerod(int n,double xx[]);

  void ntt_dec_bark_env(/* Parameters */
			int    nfr,
			int    nsf,
			int    n_ch,
			double *codebook,
			int    ndiv,
			int    cv_len,
			int    cv_len_max,
			int    *bark_tbl,
			int    n_crb,
			double alf_step,
			double *penv_tmp,
			/* Input */
			int    index_fw[],
			int    index_fw_alf[],
			int    pf_switch,
			/* Output */
			double bark_env[]);

  void ntt_dec_gain(/* Parameters */
		    int    nsf,
		    /* Input */
		    int    index_pow[],
		    /* Output */
		    double gain[]);

  void ntt_dec_lpc_spectrum_inv
  (
   /* Parameters */
   int    nfr,
   int    nsf,
   int    n_ch,
   int    n_pr,
   int    nsp,
   double *lsp_code,
   double *lsp_fgcode,
   int    *csize,
   int    *cdim,
   double prev_buf[ntt_N_SUP_MAX][ntt_MA_NP][ntt_N_PR_MAX+1],
   int    ma_np,
   /* Input */
   int    index_lsp[ntt_N_SUP_MAX][ntt_LSP_NIDX_MAX],
   /* Output */
   double inv_lpc_spec[]
   );

  void ntt_denormalizer_spectrum(/* Parameters */
				 int    nfr,
				 int    nsf,
				 int    n_ch,
				 /* Input */
				 double flat_spectrum[],
				 double gain[],
				 /*****/
				 double pit_sec[],
				 double pgain[],
				 /*****/
				 double bark_env[],
				 double inv_lpc_spec[], /**** inv */
				 /* Output */
				 double spectrum[]);

  void ntt_post_process(/* Parameters */
			int    nfr,
			int    nsf,
			double band_lower,
			double band_upper,
			/* Input */
			double spectrum[],
			/* Output */
			double out_spectrum[]);

  void ntt_vex_pn(int    *index,    /* Input : VQ indices */
		  double *sp_cv0,    /* Input : shape codebook (conj. ch. 0) */
		  double *sp_cv1,    /* Input : shape codebook (conj. ch. 1) */
		  int    cv_len_max, /* Input : memory length of codevectors */
		  int    n_sf,    /* Input : number of subframes in a frame */
		  int    block_size, /* Input : total block size */
		  int    available_bits, /* Input : available bits */
		  double *sig);       /* Output: Reconstructed coefficients */

  void ntt_tf_requantize_spectrum(/* Input */
				  ntt_INDEX *indexp,
				  /* Output */
				  double flat_spectrum[]);

  void ntt_extend_pitch(/* Input */
			int     index_pit[],
			double  pit_pack[],
			/* Output */
			double  pit_seq[]);

  void ntt_TfInit(float sampling_rate,
		  float bit_rate,
		  float t_bit_rate_scl,
		  long num_channel,
		  int  *frameNumSample,
		  int  *delayNumSample,
		  int  *med_win_in_long,
		  int  *short_win_in_long);

  int ntt_BitUnPack(BsBitStream *stream,
		    int         available_bits,
		    int         block_type,
		    ntt_INDEX   *index,
		    int         InitFlag);

  void ntt_dec_pgain(/* Input */
		     int    index,
		     /* Output */
		     double *pgain);

  void ntt_dec_pit_seq(/* Input */
		       int    index_pit[],
		       int    index_pls[],
		       /* Output */
		       double pit_seq[]);

  void ntt_dec_pitch(/* Input */
		     int    index_pit[],
		     int    index_pls[],
		     int    index_pgain[],
		     int    w_type,
		     /* Output */
		     double pit_seq[],
		     double pgain[]);

  void ntt_tf_proc_spectrum_d(/* Input */
			      ntt_INDEX  *indexp,
			      double flat_spectrum[],
			      /* Output */
			      double spectrum[]);

  int ntt_BitPack(ntt_INDEX   *index,
		  BsBitStream *stream,
		  int         InitFlag);

#ifdef __cplusplus
}
#endif


/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/**********************  BARK-SCALE BAND TABLES  *****************************/
/*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_2048[] = {
3,
6,
9,
12,
15,
18,
22,
25,
28,
31,
35,
38,
42,
45,
49,
53,
57,
60,
64,
69,
73,
77,
82,
87,
92,
97,
102,
108,
114,
120,
126,
133,
140,
148,
156,
165,
174,
185,
195,
207,
219,
233,
248,
264,
282,
301,
322,
346,
372,
401,
434,
470,
512,
558,
612,
673,
745,
829,
930,
1054,
1208,
1406,
1672,
2048};
#else
extern int ntt_crb_tbl_48_2048[];
#endif

#define ntt_N_CRB_48_2048 64

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_2048_06[] = {
6,
16,
26,
36,
47,
59,
71,
85,
101,
119,
141,
166,
198,
238,
290,
359,
456,
595,
812,
1191,
2048};
#else
extern int ntt_crb_tbl_48_2048_06[];
#endif

#define ntt_N_CRB_48_2048_06 21

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_512[] = {
2,
3,
5,
7,
8,
10,
12,
14,
16,
18,
20,
22,
25,
27,
30,
34,
37,
42,
46,
52,
58,
66,
75,
86,
100,
117,
139,
168,
207,
263,
351,
512};
#else
extern int ntt_crb_tbl_48_512[];
#endif

#define ntt_N_CRB_48_512 32

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_512_24[] = {
2,
4,
6,
9,
11,
13,
16,
19,
22,
25,
29,
33,
38,
44,
52,
60,
72,
86,
105,
131,
167,
222,
316,
512};
#else
extern int ntt_crb_tbl_48_512_24[];
#endif

#define ntt_N_CRB_48_512_24 24

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_48_512_06[] = {
3,
6,
9,
13,
17,
21,
26,
33,
41,
51,
65,
85,
116,
166,
261,
512};
#else
extern int ntt_crb_tbl_48_512_06[];
#endif

#define ntt_N_CRB_48_512_06 16

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_48_128[] = {
1,
2,
3,
5,
6,
9,
11,
16,
22,
35,
60,
128};
#else
extern int ntt_crb_tbl_s_48_128[];
#endif

#define ntt_N_CRB_S_48_128 12
#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_16_512[] = {
6,
12,
18,
25,
31,
38,
46,
54,
63,
73,
83,
96,
110,
127,
147,
171,
201,
239,
288,
360,
512};
#else
extern int ntt_crb_tbl_16_512[];
#endif

#define ntt_N_CRB_16_512 21
#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_16_64[] = {
2,
3,
5,
7,
9,
12,
19,
29,
45,
64};
#else
extern int ntt_crb_tbl_s_16_64[];
#endif

#define ntt_N_CRB_S_16_64 10
#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_m_16_256[] = {
6,
12,
18,
25,
31,
38,
46,
54,
63,
73,
83,
96,
110,
125,
143,
163,
183,
204,
230,
256};
#else
extern int ntt_crb_tbl_m_16_256[];
#endif

#define ntt_N_CRB_M_16_256 20

#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_08_512[] = {
  7,
 15,
 22,
 30,
 38,
 46,
 54,
 62,
 70,
 79,
 88,
 98,
108,
119,
130,
142,
154,
168,
183,
199,
217,
236,
257,
281,
308,
338,
373,
413,
459,
512};
#else
extern int ntt_crb_tbl_08_512[];
#endif

#define ntt_N_CRB_08_512 30
#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_s_08_64[] = {
  3,
  6,
  9,
 12,
 16,
 21,
 27,
 35,
 47,
 64} ;
#else
extern int ntt_crb_tbl_s_08_64[];
#endif

#define ntt_N_CRB_S_08_64 10
#ifdef ntt_MAIN_ROUTINE
int ntt_crb_tbl_m_08_256[] = {
  6,
 11,
 17,
 23,
 29,
 35,
 42,
 49,
 57,
 65,
 74,
 84,
 95,
108,
123,
141,
161,
186,
217,
256};
#else
extern int ntt_crb_tbl_m_08_256[];
#endif

#define ntt_N_CRB_M_08_256 20

#endif
