/*******************************************************************************
*                                                                              *
* Interface between the MPEG-4 Audio VM and the ITU-T G.729 8 kbit/s decoder   *
*                                                                              *
********************************************************************************

This software module was originally developed by
Bernhard Grill (University of Erlangen) 
in the course of development of the MPEG-4 Audio (ISO/IEC 14496-3).
This software module is an implementation of a part of one or more MPEG-4 Audio
(ISO/IEC 14496-3) tools as specified by the MPEG-4 Audio (ISO/IEC 14496-3).
ISO/IEC gives users of the MPEG-4 Audio (ISO/IEC 14496-3) free license to this
software module or modifications thereof for use in hardware or software
products claiming conformance to the MPEG-4 Audio (ISO/IEC 14496-3).
Those intending to use this software module in hardware or software products are
advised that its use may infringe existing patents.
The original developer of this software module and his/her company, the
subsequent editors and their companies, and ISO/IEC have no liability for use of
this software module or modifications thereof in an implementation.
Copyright is not released for non MPEG-4 Audio (ISO/IEC 14496-3) conforming
products.
The original developers retain full right to use the code for his/her own
purpose, assign or donate the code to a third party and to inhibit third parties
from using the code for non MPEG-4 Audio (ISO/IEC 14496-3) conforming products.
This copyright notice must be included in all copies or derivative works.
Copyright (C) 1997.
*/
#ifndef _DOLBY_WIN_H_
#define _DOLBY_WIN_H_

double dolby_win_1024[1024] = {  /* IBLEN = 1024 */
  0.00029256153896361,
  0.00042998567353047,
  0.00054674074589540,
  0.00065482304299792,
  0.00075870195068747,
  0.00086059331713336,
  0.00096177541439010,
  0.0010630609410878,
  0.0011650036308132,
  0.0012680012194148,
  0.0013723517232956,
  0.0014782864109136,
  0.0015859901976719,
  0.0016956148252373,
  0.0018072876903517,
  0.0019211179405514,
  0.0020372007924215,
  0.0021556206591754,
  0.0022764534599614,
  0.0023997683540995,
  0.0025256290631156,
  0.0026540948920831,
  0.0027852215281403,
  0.0029190616715331,
  0.0030556655443223,
  0.0031950812943391,
  0.0033373553240392,
  0.0034825325586930,
  0.0036306566699199,
  0.0037817702604646,
  0.0039359150179719,
  0.0040931318437260,
  0.0042534609610026,
  0.0044169420066964,
  0.0045836141091341,
  0.0047535159544086,
  0.0049266858431214,
  0.0051031617390698,
  0.0052829813111335,
  0.0054661819693975,
  0.0056528008963682,
  0.0058428750739943,
  0.0060364413070882,
  0.0062335362436492,
  0.0064341963925079,
  0.0066384581386503,
  0.0068463577565218,
  0.0070579314215715,
  0.0072732152202559,
  0.0074922451586909,
  0.0077150571701162,
  0.0079416871213115,
  0.0081721708180857,
  0.0084065440099458,
  0.0086448423940363,
  0.0088871016184291,
  0.0091333572848345,
  0.0093836449507939,
  0.0096380001314086,
  0.0098964583006517,
  0.010159054892306,
  0.010425825300561,
  0.010696804880310,
  0.010972028947167,
  0.011251532777236,
  0.011535351606646,
  0.011823520630897,
  0.012116075003993,
  0.012413049837429,
  0.012714480198999,
  0.013020401111478,
  0.013330847551161,
  0.013645854446288,
  0.013965456675352,
  0.014289689065314,
  0.014618586389712,
  0.014952183366697,
  0.015290514656976,
  0.015633614861688,
  0.015981518520214,
  0.016334260107915,
  0.016691874033817,
  0.017054394638241,
  0.017421856190380,
  0.017794292885832,
  0.018171738844085,
  0.018554228105962,
  0.018941794631032,
  0.019334472294980,
  0.019732294886947,
  0.020135296106839,
  0.020543509562604,
  0.020956968767488,
  0.021375707137257,
  0.021799757987407,
  0.022229154530343,
  0.022663929872540,
  0.023104117011689,
  0.023549748833816,
  0.024000858110398,
  0.024457477495451,
  0.024919639522613,
  0.025387376602207,
  0.025860721018295,
  0.026339704925726,
  0.026824360347160,
  0.027314719170100,
  0.027810813143900,
  0.028312673876775,
  0.028820332832801,
  0.029333821328905,
  0.029853170531859,
  0.030378411455255,
  0.030909574956490,
  0.031446691733739,
  0.031989792322926,
  0.032538907094693,
  0.033094066251369,
  0.033655299823935,
  0.034222637668991,
  0.034796109465717,
  0.035375744712844,
  0.035961572725616,
  0.036553622632758,
  0.037151923373446,
  0.037756503694277,
  0.038367392146243,
  0.038984617081711,
  0.039608206651398,
  0.040238188801359,
  0.040874591269976,
  0.041517441584950,
  0.042166767060301,
  0.042822594793376,
  0.043484951661852,
  0.044153864320760,
  0.044829359199509,
  0.045511462498913,
  0.046200200188234,
  0.046895598002228,
  0.047597681438201,
  0.048306475753074,
  0.049022005960455,
  0.049744296827725,
  0.050473372873129,
  0.051209258362879,
  0.051951977308273,
  0.052701553462813,
  0.053458010319350,
  0.054221371107223,
  0.054991658789428,
  0.055768896059787,
  0.056553105340134,
  0.057344308777513,
  0.058142528241393,
  0.058947785320893,
  0.059760101322019,
  0.060579497264926,
  0.061405993881180,
  0.062239611611049,
  0.063080370600799,
  0.063928290700012,
  0.064783391458919,
  0.065645692125747,
  0.066515211644086,
  0.067391968650269,
  0.068275981470777,
  0.069167268119652,
  0.070065846295935,
  0.070971733381121,
  0.071884946436630,
  0.072805502201299,
  0.073733417088896,
  0.074668707185649,
  0.075611388247794,
  0.076561475699152,
  0.077518984628715,
  0.078483929788261,
  0.079456325589986,
  0.080436186104162,
  0.081423525056808,
  0.082418355827392,
  0.083420691446553,
  0.084430544593841,
  0.085447927595483,
  0.086472852422178,
  0.087505330686900,
  0.088545373642744,
  0.089592992180780,
  0.090648196827937,
  0.091710997744919,
  0.092781404724131,
  0.093859427187640,
  0.094945074185163,
  0.096038354392069,
  0.097139276107423,
  0.098247847252041,
  0.099364075366580,
  0.10048796760965,
  0.10161953075597,
  0.10275877119451,
  0.10390569492671,
  0.10506030756469,
  0.10622261432949,
  0.10739262004941,
  0.10857032915821,
  0.10975574569357,
  0.11094887329534,
  0.11214971520402,
  0.11335827425914,
  0.11457455289772,
  0.11579855315274,
  0.11703027665170,
  0.11826972461510,
  0.11951689785504,
  0.12077179677383,
  0.12203442136263,
  0.12330477120008,
  0.12458284545102,
  0.12586864286523,
  0.12716216177615,
  0.12846340009971,
  0.12977235533312,
  0.13108902455375,
  0.13241340441801,
  0.13374549116025,
  0.13508528059173,
  0.13643276809961,
  0.13778794864595,
  0.13915081676677,
  0.14052136657114,
  0.14189959174027,
  0.14328548552671,
  0.14467904075349,
  0.14608024981336,
  0.14748910466804,
  0.14890559684750,
  0.15032971744929,
  0.15176145713790,
  0.15320080614414,
  0.15464775426459,
  0.15610229086100,
  0.15756440485987,
  0.15903408475193,
  0.16051131859170,
  0.16199609399712,
  0.16348839814917,
  0.16498821779156,
  0.16649553923042,
  0.16801034833404,
  0.16953263053270,
  0.17106237081842,
  0.17259955374484,
  0.17414416342714,
  0.17569618354193,
  0.17725559732720,
  0.17882238758238,
  0.18039653666830,
  0.18197802650733,
  0.18356683858343,
  0.18516295394233,
  0.18676635319174,
  0.18837701650148,
  0.18999492360384,
  0.19162005379380,
  0.19325238592940,
  0.19489189843209,
  0.19653856928714,
  0.19819237604409,
  0.19985329581721,
  0.20152130528605,
  0.20319638069594,
  0.20487849785865,
  0.20656763215298,
  0.20826375852540,
  0.20996685149083,
  0.21167688513330,
  0.21339383310678,
  0.21511766863598,
  0.21684836451719,
  0.21858589311922,
  0.22033022638425,
  0.22208133582887,
  0.22383919254503,
  0.22560376720111,
  0.22737503004300,
  0.22915295089517,
  0.23093749916189,
  0.23272864382838,
  0.23452635346201,
  0.23633059621364,
  0.23814133981883,
  0.23995855159925,
  0.24178219846403,
  0.24361224691114,
  0.24544866302890,
  0.24729141249740,
  0.24914046059007,
  0.25099577217522,
  0.25285731171763,
  0.25472504328019,
  0.25659893052556,
  0.25847893671788,
  0.26036502472451,
  0.26225715701781,
  0.26415529567692,
  0.26605940238966,
  0.26796943845439,
  0.26988536478190,
  0.27180714189742,
  0.27373472994256,
  0.27566808867736,
  0.27760717748238,
  0.27955195536071,
  0.28150238094021,
  0.28345841247557,
  0.28542000785059,
  0.28738712458038,
  0.28935971981364,
  0.29133775033492,
  0.29332117256704,
  0.29530994257338,
  0.29730401606034,
  0.29930334837974,
  0.30130789453132,
  0.30331760916521,
  0.30533244658452,
  0.30735236074785,
  0.30937730527195,
  0.31140723343430,
  0.31344209817583,
  0.31548185210356,
  0.31752644749341,
  0.31957583629288,
  0.32162997012390,
  0.32368880028565,
  0.32575227775738,
  0.32782035320134,
  0.32989297696566,
  0.33197009908736,
  0.33405166929523,
  0.33613763701295,
  0.33822795136203,
  0.34032256116495,
  0.34242141494820,
  0.34452446094547,
  0.34663164710072,
  0.34874292107143,
  0.35085823023181,
  0.35297752167598,
  0.35510074222129,
  0.35722783841160,
  0.35935875652060,
  0.36149344255514,
  0.36363184225864,
  0.36577390111444,
  0.36791956434930,
  0.37006877693676,
  0.37222148360070,
  0.37437762881878,
  0.37653715682603,
  0.37870001161834,
  0.38086613695607,
  0.38303547636766,
  0.38520797315322,
  0.38738357038821,
  0.38956221092708,
  0.39174383740701,
  0.39392839225157,
  0.39611581767449,
  0.39830605568342,
  0.40049904808370,
  0.40269473648218,
  0.40489306229101,
  0.40709396673153,
  0.40929739083810,
  0.41150327546197,
  0.41371156127524,
  0.41592218877472,
  0.41813509828594,
  0.42035022996702,
  0.42256752381274,
  0.42478691965848,
  0.42700835718423,
  0.42923177591866,
  0.43145711524314,
  0.43368431439580,
  0.43591331247564,
  0.43814404844658,
  0.44037646114161,
  0.44261048926688,
  0.44484607140589,
  0.44708314602359,
  0.44932165147057,
  0.45156152598727,
  0.45380270770813,
  0.45604513466581,
  0.45828874479543,
  0.46053347593880,
  0.46277926584861,
  0.46502605219277,
  0.46727377255861,
  0.46952236445718,
  0.47177176532752,
  0.47402191254100,
  0.47627274340557,
  0.47852419517009,
  0.48077620502869,
  0.48302871012505,
  0.48528164755674,
  0.48753495437962,
  0.48978856761212,
  0.49204242423966,
  0.49429646121898,
  0.49655061548250,
  0.49880482394273,
  0.50105902349665,
  0.50331315103004,
  0.50556714342194,
  0.50782093754901,
  0.51007447028990,
  0.51232767852971,
  0.51458049916433,
  0.51683286910489,
  0.51908472528213,
  0.52133600465083,
  0.52358664419420,
  0.52583658092832,
  0.52808575190648,
  0.53033409422367,
  0.53258154502092,
  0.53482804148974,
  0.53707352087652,
  0.53931792048690,
  0.54156117769021,
  0.54380322992385,
  0.54604401469766,
  0.54828346959835,
  0.55052153229384,
  0.55275814053768,
  0.55499323217338,
  0.55722674513883,
  0.55945861747062,
  0.56168878730842,
  0.56391719289930,
  0.56614377260214,
  0.56836846489188,
  0.57059120836390,
  0.57281194173835,
  0.57503060386439,
  0.57724713372458,
  0.57946147043912,
  0.58167355327012,
  0.58388332162591,
  0.58609071506528,
  0.58829567330173,
  0.59049813620770,
  0.59269804381879,
  0.59489533633802,
  0.59708995413996,
  0.59928183777495,
  0.60147092797329,
  0.60365716564937,
  0.60584049190582,
  0.60802084803764,
  0.61019817553632,
  0.61237241609393,
  0.61454351160718,
  0.61671140418155,
  0.61887603613527,
  0.62103735000336,
  0.62319528854167,
  0.62534979473088,
  0.62750081178042,
  0.62964828313250,
  0.63179215246597,
  0.63393236370030,
  0.63606886099946,
  0.63820158877577,
  0.64033049169379,
  0.64245551467413,
  0.64457660289729,
  0.64669370180740,
  0.64880675711607,
  0.65091571480603,
  0.65302052113494,
  0.65512112263906,
  0.65721746613689,
  0.65930949873289,
  0.66139716782102,
  0.66348042108842,
  0.66555920651892,
  0.66763347239664,
  0.66970316730947,
  0.67176824015260,
  0.67382864013196,
  0.67588431676768,
  0.67793521989751,
  0.67998129968017,
  0.68202250659876,
  0.68405879146403,
  0.68609010541774,
  0.68811639993588,
  0.69013762683195,
  0.69215373826012,
  0.69416468671849,
  0.69617042505214,
  0.69817090645634,
  0.70016608447958,
  0.70215591302664,
  0.70414034636163,
  0.70611933911096,
  0.70809284626630,
  0.71006082318751,
  0.71202322560554,
  0.71398000962530,
  0.71593113172842,
  0.71787654877613,
  0.71981621801195,
  0.72175009706445,
  0.72367814394990,
  0.72560031707496,
  0.72751657523927,
  0.72942687763803,
  0.73133118386457,
  0.73322945391280,
  0.73512164817975,
  0.73700772746796,
  0.73888765298787,
  0.74076138636020,
  0.74262888961827,
  0.74449012521027,
  0.74634505600152,
  0.74819364527663,
  0.75003585674175,
  0.75187165452661,
  0.75370100318668,
  0.75552386770515,
  0.75734021349500,
  0.75915000640095,
  0.76095321270137,
  0.76274979911019,
  0.76453973277875,
  0.76632298129757,
  0.76809951269819,
  0.76986929545481,
  0.77163229848604,
  0.77338849115651,
  0.77513784327849,
  0.77688032511340,
  0.77861590737340,
  0.78034456122283,
  0.78206625827961,
  0.78378097061667,
  0.78548867076330,
  0.78718933170643,
  0.78888292689189,
  0.79056943022564,
  0.79224881607494,
  0.79392105926949,
  0.79558613510249,
  0.79724401933170,
  0.79889468818046,
  0.80053811833858,
  0.80217428696334,
  0.80380317168028,
  0.80542475058405,
  0.80703900223920,
  0.80864590568089,
  0.81024544041560,
  0.81183758642175,
  0.81342232415032,
  0.81499963452540,
  0.81656949894467,
  0.81813189927991,
  0.81968681787738,
  0.82123423755821,
  0.82277414161874,
  0.82430651383076,
  0.82583133844180,
  0.82734860017528,
  0.82885828423070,
  0.83036037628369,
  0.83185486248609,
  0.83334172946597,
  0.83482096432759,
  0.83629255465130,
  0.83775648849344,
  0.83921275438615,
  0.84066134133716,
  0.84210223882952,
  0.84353543682130,
  0.84496092574524,
  0.84637869650833,
  0.84778874049138,
  0.84919104954855,
  0.85058561600677,
  0.85197243266520,
  0.85335149279457,
  0.85472279013653,
  0.85608631890295,
  0.85744207377513,
  0.85879004990298,
  0.86013024290422,
  0.86146264886346,
  0.86278726433124,
  0.86410408632306,
  0.86541311231838,
  0.86671434025950,
  0.86800776855046,
  0.86929339605590,
  0.87057122209981,
  0.87184124646433,
  0.87310346938840,
  0.87435789156650,
  0.87560451414719,
  0.87684333873173,
  0.87807436737261,
  0.87929760257204,
  0.88051304728038,
  0.88172070489456,
  0.88292057925645,
  0.88411267465117,
  0.88529699580537,
  0.88647354788545,
  0.88764233649580,
  0.88880336767692,
  0.88995664790351,
  0.89110218408260,
  0.89223998355154,
  0.89337005407600,
  0.89449240384793,
  0.89560704148345,
  0.89671397602074,
  0.89781321691786,
  0.89890477405053,
  0.89998865770993,
  0.90106487860034,
  0.90213344783689,
  0.90319437694315,
  0.90424767784873,
  0.90529336288690,
  0.90633144479201,
  0.90736193669708,
  0.90838485213119,
  0.90940020501694,
  0.91040800966776,
  0.91140828078533,
  0.91240103345685,
  0.91338628315231,
  0.91436404572173,
  0.91533433739238,
  0.91629717476594,
  0.91725257481564,
  0.91820055488334,
  0.91914113267664,
  0.92007432626589,
  0.92100015408120,
  0.92191863490944,
  0.92282978789113,
  0.92373363251740,
  0.92463018862687,
  0.92551947640245,
  0.92640151636824,
  0.92727632938624,
  0.92814393665320,
  0.92900435969727,
  0.92985762037477,
  0.93070374086684,
  0.93154274367610,
  0.93237465162328,
  0.93319948784382,
  0.93401727578443,
  0.93482803919967,
  0.93563180214841,
  0.93642858899043,
  0.93721842438279,
  0.93800133327637,
  0.93877734091223,
  0.93954647281807,
  0.94030875480458,
  0.94106421296182,
  0.94181287365556,
  0.94255476352362,
  0.94328990947213,
  0.94401833867184,
  0.94474007855439,
  0.94545515680855,
  0.94616360137644,
  0.94686544044975,
  0.94756070246592,
  0.94824941610434,
  0.94893161028248,
  0.94960731415209,
  0.95027655709525,
  0.95093936872056,
  0.95159577885924,
  0.95224581756115,
  0.95288951509097,
  0.95352690192417,
  0.95415800874314,
  0.95478286643320,
  0.95540150607863,
  0.95601395895871,
  0.95662025654373,
  0.95722043049100,
  0.95781451264084,
  0.95840253501260,
  0.95898452980058,
  0.95956052937008,
  0.96013056625336,
  0.96069467314557,
  0.96125288290073,
  0.96180522852773,
  0.96235174318622,
  0.96289246018262,
  0.96342741296604,
  0.96395663512424,
  0.96448016037959,
  0.96499802258499,
  0.96551025571985,
  0.96601689388602,
  0.96651797130376,
  0.96701352230768,
  0.96750358134269,
  0.96798818295998,
  0.96846736181297,
  0.96894115265327,
  0.96940959032667,
  0.96987270976912,
  0.97033054600270,
  0.97078313413161,
  0.97123050933818,
  0.97167270687887,
  0.97210976208030,
  0.97254171033525,
  0.97296858709871,
  0.97339042788392,
  0.97380726825843,
  0.97421914384017,
  0.97462609029350,
  0.97502814332534,
  0.97542533868127,
  0.97581771214160,
  0.97620529951759,
  0.97658813664749,
  0.97696625939282,
  0.97733970363445,
  0.97770850526884,
  0.97807270020427,
  0.97843232435704,
  0.97878741364771,
  0.97913800399743,
  0.97948413132414,
  0.97982583153895,
  0.98016314054243,
  0.98049609422096,
  0.98082472844313,
  0.98114907905608,
  0.98146918188197,
  0.98178507271438,
  0.98209678731477,
  0.98240436140902,
  0.98270783068385,
  0.98300723078342,
  0.98330259730589,
  0.98359396579995,
  0.98388137176152,
  0.98416485063031,
  0.98444443778651,
  0.98472016854752,
  0.98499207816463,
  0.98526020181980,
  0.98552457462240,
  0.98578523160609,
  0.98604220772560,
  0.98629553785362,
  0.98654525677772,
  0.98679139919726,
  0.98703399972035,
  0.98727309286089,
  0.98750871303556,
  0.98774089456089,
  0.98796967165036,
  0.98819507841154,
  0.98841714884323,
  0.98863591683269,
  0.98885141615285,
  0.98906368045957,
  0.98927274328896,
  0.98947863805473,
  0.98968139804554,
  0.98988105642241,
  0.99007764621618,
  0.99027120032501,
  0.99046175151186,
  0.99064933240208,
  0.99083397548099,
  0.99101571309153,
  0.99119457743191,
  0.99137060055337,
  0.99154381435784,
  0.99171425059582,
  0.99188194086414,
  0.99204691660388,
  0.99220920909823,
  0.99236884947045,
  0.99252586868186,
  0.99268029752989,
  0.99283216664606,
  0.99298150649419,
  0.99312834736847,
  0.99327271939167,
  0.99341465251338,
  0.99355417650825,
  0.99369132097430,
  0.99382611533130,
  0.99395858881910,
  0.99408877049612,
  0.99421668923778,
  0.99434237373503,
  0.99446585249289,
  0.99458715382906,
  0.99470630587254,
  0.99482333656229,
  0.99493827364600,
  0.99505114467878,
  0.99516197702200,
  0.99527079784214,
  0.99537763410962,
  0.99548251259777,
  0.99558545988178,
  0.99568650233767,
  0.99578566614138,
  0.99588297726783,
  0.99597846149005,
  0.99607214437834,
  0.99616405129947,
  0.99625420741595,
  0.99634263768527,
  0.99642936685928,
  0.99651441948352,
  0.99659781989663,
  0.99667959222978,
  0.99675976040620,
  0.99683834814063,
  0.99691537893895,
  0.99699087609774,
  0.99706486270391,
  0.99713736163442,
  0.99720839555593,
  0.99727798692461,
  0.99734615798589,
  0.99741293077431,
  0.99747832711337,
  0.99754236861541,
  0.99760507668158,
  0.99766647250181,
  0.99772657705478,
  0.99778541110799,
  0.99784299521785,
  0.99789934972976,
  0.99795449477828,
  0.99800845028730,
  0.99806123597027,
  0.99811287133042,
  0.99816337566108,
  0.99821276804596,
  0.99826106735952,
  0.99830829226732,
  0.99835446122649,
  0.99839959248609,
  0.99844370408765,
  0.99848681386566,
  0.99852893944805,
  0.99857009825685,
  0.99861030750869,
  0.99864958421549,
  0.99868794518504,
  0.99872540702178,
  0.99876198612738,
  0.99879769870160,
  0.99883256074295,
  0.99886658804953,
  0.99889979621983,
  0.99893220065356,
  0.99896381655254,
  0.99899465892154,
  0.99902474256924,
  0.99905408210916,
  0.99908269196056,
  0.99911058634952,
  0.99913777930986,
  0.99916428468421,
  0.99919011612505,
  0.99921528709576,
  0.99923981087174,
  0.99926370054150,
  0.99928696900779,
  0.99930962898876,
  0.99933169301910,
  0.99935317345126,
  0.99937408245662,
  0.99939443202674,
  0.99941423397457,
  0.99943349993572,
  0.99945224136972,
  0.99947046956130,
  0.99948819562171,
  0.99950543049000,
  0.99952218493439,
  0.99953846955355,
  0.99955429477803,
  0.99956967087154,
  0.99958460793242,
  0.99959911589494,
  0.99961320453077,
  0.99962688345035,
  0.99964016210433,
  0.99965304978499,
  0.99966555562769,
  0.99967768861231,
  0.99968945756473,
  0.99970087115825,
  0.99971193791510,
  0.99972266620792,
  0.99973306426121,
  0.99974314015288,
  0.99975290181568,
  0.99976235703876,
  0.99977151346914,
  0.99978037861326,
  0.99978895983845,
  0.99979726437448,
  0.99980529931507,
  0.99981307161943,
  0.99982058811377,
  0.99982785549283,
  0.99983488032144,
  0.99984166903600,
  0.99984822794606,
  0.99985456323584,
  0.99986068096572,
  0.99986658707386,
  0.99987228737764,
  0.99987778757524,
  0.99988309324717,
  0.99988820985777,
  0.99989314275675,
  0.99989789718072,
  0.99990247825468,
  0.99990689099357,
  0.99991114030376,
  0.99991523098456,
  0.99991916772971,
  0.99992295512891,
  0.99992659766930,
  0.99993009973692,
  0.99993346561824,
  0.99993669950161,
  0.99993980547870,
  0.99994278754604,
  0.99994564960642,
  0.99994839547033,
  0.99995102885747,
  0.99995355339809,
  0.99995597263451,
  0.99995829002249,
  0.99996050893264,
  0.99996263265183,
  0.99996466438460,
  0.99996660725452,
  0.99996846430558,
  0.99997023850356,
  0.99997193273736,
  0.99997354982037,
  0.99997509249183,
  0.99997656341810,
  0.99997796519400,
  0.99997930034415,
  0.99998057132421,
  0.99998178052220,
  0.99998293025975,
  0.99998402279338,
  0.99998506031574,
  0.99998604495686,
  0.99998697878536,
  0.99998786380966,
  0.99998870197921,
  0.99998949518567,
  0.99999024526408,
  0.99999095399401,
  0.99999162310077,
  0.99999225425649,
  0.99999284908128,
  0.99999340914435,
  0.99999393596510,
  0.99999443101421,
  0.99999489571473,
  0.99999533144314,
  0.99999573953040,
  0.99999612126300,
  0.99999647788395,
  0.99999681059383,
  0.99999712055178,
  0.99999740887647,
  0.99999767664709,
  0.99999792490431,
  0.99999815465123,
  0.99999836685427,
  0.99999856244415,
  0.99999874231676,
  0.99999890733405,
  0.99999905832493,
  0.99999919608613,
  0.99999932138304,
  0.99999943495056,
  0.99999953749392,
  0.99999962968950,
  0.99999971218563,
  0.99999978560337,
  0.99999985053727,
  0.99999990755616,
  0.99999995720387
};

double dolby_win_960[960] = {  /* IBLEN = 960 */
0.0003021562530949,
0.0004452267024786,
0.0005674947527496,
0.0006812465553466,
0.0007910496776387,
0.0008991655033895,
0.0010068978259384,
0.0011150758515751,
0.0012242653193642,
0.0013348735658205,
0.0014472068670273,
0.0015615039850448,
0.0016779568885263,
0.0017967241232412,
0.0019179397560955,
0.0020417195415393,
0.0021681652836642,
0.0022973679910599,
0.0024294102029937,
0.0025643677339078,
0.0027023110014772,
0.0028433060512612,
0.0029874153568025,
0.0031346984511728,
0.0032852124303662,
0.0034390123581190,
0.0035961515940931,
0.0037566820618961,
0.0039206544694386,
0.0040881184912194,
0.0042591229199617,
0.0044337157933972,
0.0046119445007641,
0.0047938558726415,
0.0049794962570131,
0.0051689115838900,
0.0053621474203763,
0.0055592490177131,
0.0057602613515573,
0.0059652291565289,
0.0061741969558843,
0.0063872090870253,
0.0066043097234387,
0.0068255428935640,
0.0070509524970088,
0.0072805823184660,
0.0075144760396340,
0.0077526772493942,
0.0079952294524673,
0.0082421760767325,
0.0084935604793733,
0.0087494259519870,
0.0090098157247792,
0.0092747729699467,
0.0095443408043399,
0.0098185622914832,
0.0100974804430226,
0.0103811382196612,
0.0106695785316351,
0.0109628442387771,
0.0112609781502091,
0.0115640230236993,
0.0118720215647169,
0.0121850164252137,
0.0125030502021561,
0.0128261654358321,
0.0131544046079532,
0.0134878101395681,
0.0138264243888068,
0.0141702896484671,
0.0145194481434592,
0.0148739420281182,
0.0152338133833959,
0.0155991042139432,
0.0159698564450882,
0.0163461119197227,
0.0167279123950996,
0.0171152995395520,
0.0175083149291368,
0.0179070000442104,
0.0183113962659409,
0.0187215448727609,
0.0191374870367659,
0.0195592638200623,
0.0199869161710679,
0.0204204849207691,
0.0208600107789370,
0.0213055343303066,
0.0217570960307201,
0.0222147362032386,
0.0226784950342228,
0.0231484125693867,
0.0236245287098244,
0.0241068832080138,
0.0245955156637973,
0.0250904655203431,
0.0255917720600868,
0.0260994744006559,
0.0266136114907790,
0.0271342221061795,
0.0276613448454576,
0.0281950181259587,
0.0287352801796329,
0.0292821690488833,
0.0298357225824074,
0.0303959784310299,
0.0309629740435296,
0.0315367466624615,
0.0321173333199732,
0.0327047708336193,
0.0332990958021720,
0.0339003446014307,
0.0345085533800302,
0.0351237580552491,
0.0357459943088193,
0.0363752975827358,
0.0370117030750704,
0.0376552457357870,
0.0383059602625614,
0.0389638810966056,
0.0396290424184964,
0.0403014781440112,
0.0409812219199691,
0.0416683071200799,
0.0423627668408009,
0.0430646338972016,
0.0437739408188385,
0.0444907198456388,
0.0452150029237951,
0.0459468217016708,
0.0466862075257170,
0.0474331914364021,
0.0481878041641539,
0.0489500761253148,
0.0497200374181119,
0.0504977178186404,
0.0512831467768636,
0.0520763534126273,
0.0528773665116913,
0.0536862145217772,
0.0545029255486345,
0.0553275273521232,
0.0561600473423164,
0.0570005125756209,
0.0578489497509179,
0.0587053852057233,
0.0595698449123695,
0.0604423544742077,
0.0613229391218317,
0.0622116237093247,
0.0631084327105284,
0.0640133902153352,
0.0649265199260043,
0.0658478451535027,
0.0667773888138695,
0.0677151734246072,
0.0686612211010977,
0.0696155535530446,
0.0705781920809429,
0.0715491575725758,
0.0725284704995383,
0.0735161509137906,
0.0745122184442388,
0.0755166922933461,
0.0765295912337720,
0.0775509336050437,
0.0785807373102561,
0.0796190198128044,
0.0806657981331473,
0.0817210888456026,
0.0827849080751753,
0.0838572714944183,
0.0849381943203265,
0.0860276913112652,
0.0871257767639319,
0.0882324645103534,
0.0893477679149177,
0.0904716998714418,
0.0916042728002747,
0.0927454986454381,
0.0938953888718020,
0.0950539544622996,
0.0962212059151784,
0.0973971532412897,
0.0985818059614169,
0.0997751731036425,
0.1009772632007537,
0.1021880842876888,
0.1034076438990227,
0.1046359490664932,
0.1058730063165681,
0.1071188216680533,
0.1083734006297428,
0.1096367481981100,
0.1109088688550422,
0.1121897665656167,
0.1134794447759207,
0.1147779064109143,
0.1160851538723372,
0.1174011890366591,
0.1187260132530751,
0.1200596273415457,
0.1214020315908810,
0.1227532257568719,
0.1241132090604651,
0.1254819801859856,
0.1268595372794049,
0.1282458779466558,
0.1296409992519942,
0.1310448977164081,
0.1324575693160745,
0.1338790094808633,
0.1353092130928902,
0.1367481744851168,
0.1381958874400010,
0.1396523451881945,
0.1411175404072910,
0.1425914652206223,
0.1440741111961058,
0.1455654693451402,
0.1470655301215526,
0.1485742834205956,
0.1500917185779945,
0.1516178243690463,
0.1531525890077689,
0.1546960001461024,
0.1562480448731608,
0.1578087097145364,
0.1593779806316558,
0.1609558430211876,
0.1625422817145027,
0.1641372809771871,
0.1657408245086070,
0.1673528954415270,
0.1689734763417811,
0.1706025492079969,
0.1722400954713725,
0.1738860959955082,
0.1755405310762898,
0.1772033804418275,
0.1788746232524467,
0.1805542381007349,
0.1822422030116404,
0.1839384954426268,
0.1856430922838810,
0.1873559698585756,
0.1890771039231862,
0.1908064696678625,
0.1925440417168546,
0.1942897941289937,
0.1960437003982277,
0.1978057334542116,
0.1995758656629525,
0.2013540688275098,
0.2031403141887507,
0.2049345724261595,
0.2067368136587033,
0.2085470074457521,
0.2103651227880538,
0.2121911281287646,
0.2140249913545346,
0.2158666797966480,
0.2177161602322188,
0.2195733988854414,
0.2214383614288963,
0.2233110129849106,
0.2251913181269740,
0.2270792408812093,
0.2289747447278976,
0.2308777926030592,
0.2327883469000885,
0.2347063694714437,
0.2366318216303919,
0.2385646641528076,
0.2405048572790267,
0.2424523607157545,
0.2444071336380283,
0.2463691346912334,
0.2483383219931741,
0.2503146531361985,
0.2522980851893767,
0.2542885747007335,
0.2562860776995335,
0.2582905496986215,
0.2603019456968142,
0.2623202201813464,
0.2643453271303700,
0.2663772200155053,
0.2684158518044454,
0.2704611749636135,
0.2725131414608710,
0.2745717027682799,
0.2766368098649151,
0.2787084132397296,
0.2807864628944707,
0.2828709083466482,
0.2849616986325523,
0.2870587823103237,
0.2891621074630737,
0.2912716217020546,
0.2933872721698803,
0.2955090055437973,
0.2976367680390041,
0.2997705054120213,
0.3019101629641097,
0.3040556855447379,
0.3062070175550981,
0.3083641029516701,
0.3105268852498334,
0.3126953075275265,
0.3148693124289546,
0.3170488421683428,
0.3192338385337370,
0.3214242428908514,
0.3236199961869606,
0.3258210389548392,
0.3280273113167459,
0.3302387529884521,
0.3324553032833160,
0.3346769011164010,
0.3369034850086373,
0.3391349930910280,
0.3413713631088974,
0.3436125324261830,
0.3458584380297697,
0.3481090165338656,
0.3503642041844199,
0.3526239368635820,
0.3548881500942010,
0.3571567790443668,
0.3594297585319891,
0.3617070230294185,
0.3639885066681048,
0.3662741432432950,
0.3685638662187693,
0.3708576087316147,
0.3731553035970366,
0.3754568833132069,
0.3777622800661488,
0.3800714257346570,
0.3823842518952546,
0.3847006898271841,
0.3870206705174334,
0.3893441246657958,
0.3916709826899639,
0.3940011747306560,
0.3963346306567764,
0.3986712800706062,
0.4010110523130271,
0.4033538764687756,
0.4056996813717284,
0.4080483956102172,
0.4103999475323736,
0.4127542652515031,
0.4151112766514873,
0.4174709093922143,
0.4198330909150365,
0.4221977484482556,
0.4245648090126334,
0.4269341994269293,
0.4293058463134616,
0.4316796761036958,
0.4340556150438547,
0.4364335892005536,
0.4388135244664580,
0.4411953465659639,
0.4435789810609000,
0.4459643533562509,
0.4483513887059016,
0.4507400122184019,
0.4531301488627497,
0.4555217234741947,
0.4579146607600593,
0.4603088853055777,
0.4627043215797521,
0.4651008939412254,
0.4674985266441709,
0.4698971438441951,
0.4722966696042580,
0.4746970279006055,
0.4770981426287164,
0.4794999376092619,
0.4819023365940778,
0.4843052632721476,
0.4867086412755978,
0.4891123941857028,
0.4915164455388997,
0.4939207188328126,
0.4963251375322855,
0.4987296250754225,
0.5011341048796359,
0.5035385003477012,
0.5059427348738168,
0.5083467318496706,
0.5107504146705106,
0.5131537067412193,
0.5155565314823923,
0.5179588123364193,
0.5203604727735667,
0.5227614362980630,
0.5251616264541841,
0.5275609668323384,
0.5299593810751532,
0.5323567928835578,
0.5347531260228663,
0.5371483043288580,
0.5395422517138538,
0.5419348921727899,
0.5443261497892862,
0.5467159487417104,
0.5491042133092364,
0.5514908678778958,
0.5538758369466227,
0.5562590451332913,
0.5586404171807443,
0.5610198779628133,
0.5633973524903286,
0.5657727659171199,
0.5681460435460047,
0.5705171108347663,
0.5728858934021188,
0.5752523170336598,
0.5776163076878088,
0.5799777915017323,
0.5823366947972535,
0.5846929440867458,
0.5870464660790119,
0.5893971876851449,
0.5917450360243719,
0.5940899384298793,
0.5964318224546208,
0.5987706158771039,
0.6011062467071583,
0.6034386431916822,
0.6057677338203681,
0.6080934473314057,
0.6104157127171639,
0.6127344592298474,
0.6150496163871310,
0.6173611139777690,
0.6196688820671789,
0.6219728510029997,
0.6242729514206247,
0.6265691142487051,
0.6288612707146283,
0.6311493523499663,
0.6334332909958958,
0.6357130188085891,
0.6379884682645743,
0.6402595721660647,
0.6425262636462578,
0.6447884761746012,
0.6470461435620266,
0.6492991999661505,
0.6515475798964411,
0.6537912182193508,
0.6560300501634142,
0.6582640113243098,
0.6604930376698862,
0.6627170655451516,
0.6649360316772256,
0.6671498731802533,
0.6693585275602818,
0.6715619327200959,
0.6737600269640164,
0.6759527490026566,
0.6781400379576392,
0.6803218333662715,
0.6824980751861787,
0.6846687037998949,
0.6868336600194123,
0.6889928850906855,
0.6911463206980928,
0.6932939089688525,
0.6954355924773949,
0.6975713142496884,
0.6997010177675195,
0.7018246469727265,
0.7039421462713862,
0.7060534605379528,
0.7081585351193496,
0.7102573158390105,
0.7123497490008750,
0.7144357813933307,
0.7165153602931092,
0.7185884334691287,
0.7206549491862871,
0.7227148562092042,
0.7247681038059106,
0.7268146417514855,
0.7288544203316418,
0.7308873903462577,
0.7329135031128549,
0.7349327104700221,
0.7369449647807855,
0.7389502189359237,
0.7409484263572271,
0.7429395410007016,
0.7449235173597176,
0.7469003104681008,
0.7488698759031670,
0.7508321697887005,
0.7527871487978728,
0.7547347701561059,
0.7566749916438754,
0.7586077715994560,
0.7605330689216074,
0.7624508430722016,
0.7643610540787891,
0.7662636625371070,
0.7681586296135255,
0.7700459170474343,
0.7719254871535672,
0.7737973028242671,
0.7756613275316875,
0.7775175253299340,
0.7793658608571425,
0.7812062993374951,
0.7830388065831744,
0.7848633489962533,
0.7866798935705233,
0.7884884078932579,
0.7902888601469138,
0.7920812191107668,
0.7938654541624850,
0.7956415352796368,
0.7974094330411343,
0.7991691186286133,
0.8009205638277465,
0.8026637410294932,
0.8043986232312831,
0.8061251840381346,
0.8078433976637077,
0.8095532389312917,
0.8112546832747255,
0.8129477067392539,
0.8146322859823164,
0.8163083982742698,
0.8179760214990457,
0.8196351341547393,
0.8212857153541345,
0.8229277448251595,
0.8245612029112778,
0.8261860705718113,
0.8278023293821971,
0.8294099615341773,
0.8310089498359212,
0.8325992777120815,
0.8341809292037831,
0.8357538889685445,
0.8373181422801330,
0.8388736750283521,
0.8404204737187619,
0.8419585254723335,
0.8434878180250348,
0.8450083397273509,
0.8465200795437368,
0.8480230270520029,
0.8495171724426350,
0.8510025065180464,
0.8524790206917633,
0.8539467069875448,
0.8554055580384357,
0.8568555670857525,
0.8582967279780043,
0.8597290351697464,
0.8611524837203691,
0.8625670692928198,
0.8639727881522599,
0.8653696371646555,
0.8667576137953045,
0.8681367161072958,
0.8695069427599065,
0.8708682930069319,
0.8722207666949527,
0.8735643642615368,
0.8748990867333771,
0.8762249357243662,
0.8775419134336067,
0.8788500226433579,
0.8801492667169208,
0.8814396495964587,
0.8827211758007560,
0.8839938504229149,
0.8852576791279895,
0.8865126681505587,
0.8877588242922386,
0.8889961549191320,
0.8902246679592184,
0.8914443718996848,
0.8926552757841945,
0.8938573892100969,
0.8950507223255798,
0.8962352858267605,
0.8974110909547198,
0.8985781494924783,
0.8997364737619142,
0.9008860766206249,
0.9020269714587307,
0.9031591721956235,
0.9042826932766591,
0.9053975496697941,
0.9065037568621681,
0.9076013308566311,
0.9086902881682180,
0.9097706458205682,
0.9108424213422940,
0.9119056327632955,
0.9129602986110235,
0.9140064379066919,
0.9150440701614393,
0.9160732153724396,
0.9170938940189634,
0.9181061270583908,
0.9191099359221748,
0.9201053425117579,
0.9210923691944400,
0.9220710387992010,
0.9230413746124764,
0.9240034003738882,
0.9249571402719298,
0.9259026189396085,
0.9268398614500427,
0.9277688933120170,
0.9286897404654957,
0.9296024292770939,
0.9305069865355076,
0.9314034394469048,
0.9322918156302762,
0.9331721431127471,
0.9340444503248519,
0.9349087660957711,
0.9357651196485313,
0.9366135405951697,
0.9374540589318637,
0.9382867050340261,
0.9391115096513655,
0.9399285039029165,
0.9407377192720349,
0.9415391876013639,
0.9423329410877687,
0.9431190122772415,
0.9438974340597782,
0.9446682396642262,
0.9454314626531054,
0.9461871369174033,
0.9469352966713429,
0.9476759764471278,
0.9484092110896616,
0.9491350357512457,
0.9498534858862532,
0.9505645972457831,
0.9512684058722927,
0.9519649480942105,
0.9526542605205314,
0.9533363800353921,
0.9540113437926313,
0.9546791892103320,
0.9553399539653500,
0.9559936759878265,
0.9566403934556893,
0.9572801447891388,
0.9579129686451244,
0.9585389039118085,
0.9591579897030224,
0.9597702653527108,
0.9603757704093711,
0.9609745446304828,
0.9615666279769324,
0.9621520606074324,
0.9627308828729358,
0.9633031353110477,
0.9638688586404335,
0.9644280937552258,
0.9649808817194311,
0.9655272637613366,
0.9660672812679171,
0.9666009757792454,
0.9671283889829055,
0.9676495627084089,
0.9681645389216160,
0.9686733597191652,
0.9691760673229058,
0.9696727040743406,
0.9701633124290767,
0.9706479349512860,
0.9711266143081750,
0.9715993932644684,
0.9720663146769026,
0.9725274214887337,
0.9729827567242596,
0.9734323634833574,
0.9738762849360358,
0.9743145643170059,
0.9747472449202687,
0.9751743700937215,
0.9755959832337850,
0.9760121277800496,
0.9764228472099433,
0.9768281850334235,
0.9772281847876897,
0.9776228900319223,
0.9780123443420448,
0.9783965913055132,
0.9787756745161313,
0.9791496375688939,
0.9795185240548578,
0.9798823775560431,
0.9802412416403639,
0.9805951598565897,
0.9809441757293399,
0.9812883327541090,
0.9816276743923267,
0.9819622440664515,
0.9822920851550995,
0.9826172409882086,
0.9829377548422400,
0.9832536699354163,
0.9835650294229984,
0.9838718763926001,
0.9841742538595437,
0.9844722047622547,
0.9847657719576983,
0.9850549982168574,
0.9853399262202529,
0.9856205985535073,
0.9858970577029519,
0.9861693460512790,
0.9864375058732389,
0.9867015793313820,
0.9869616084718489,
0.9872176352202061,
0.9874697013773301,
0.9877178486153397,
0.9879621184735767,
0.9882025523546365,
0.9884391915204485,
0.9886720770884069,
0.9889012500275530,
0.9891267511548089,
0.9893486211312621,
0.9895669004585049,
0.9897816294750255,
0.9899928483526520,
0.9902005970930525,
0.9904049155242876,
0.9906058432974180,
0.9908034198831690,
0.9909976845686489,
0.9911886764541239,
0.9913764344498495,
0.9915609972729590,
0.9917424034444086,
0.9919206912859797,
0.9920958989173397,
0.9922680642531603,
0.9924372250002933,
0.9926034186550070,
0.9927666825002789,
0.9929270536031491,
0.9930845688121325,
0.9932392647546895,
0.9933911778347579,
0.9935403442303433,
0.9936867998911693,
0.9938305805363887,
0.9939717216523539,
0.9941102584904481,
0.9942462260649764,
0.9943796591511174,
0.9945105922829353,
0.9946390597514524,
0.9947650956027824,
0.9948887336363228,
0.9950100074030103,
0.9951289502036336,
0.9952455950872091,
0.9953599748494155,
0.9954721220310890,
0.9955820689167787,
0.9956898475333619,
0.9957954896487196,
0.9958990267704713,
0.9960004901447701,
0.9960999107551559,
0.9961973193214694,
0.9962927462988245,
0.9963862218766388,
0.9964777759777242,
0.9965674382574342,
0.9966552381028704,
0.9967412046321465,
0.9968253666937095,
0.9969077528657186,
0.9969883914554805,
0.9970673104989413,
0.9971445377602348,
0.9972201007312871,
0.9972940266314749,
0.9973663424073412,
0.9974370747323638,
0.9975062500067785,
0.9975738943574574,
0.9976400336378379,
0.9977046934279079,
0.9977678990342401,
0.9978296754900812,
0.9978900475554902,
0.9979490397175296,
0.9980066761905056,
0.9980629809162593,
0.9981179775645063,
0.9981716895332257,
0.9982241399490979,
0.9982753516679893,
0.9983253472754841,
0.9983741490874634,
0.9984217791507299,
0.9984682592436778,
0.9985136108770075,
0.9985578552944850,
0.9986010134737439,
0.9986431061271304,
0.9986841537025921,
0.9987241763846056,
0.9987631940951476,
0.9988012264947044,
0.9988382929833222,
0.9988744127016956,
0.9989096045322947,
0.9989438871005292,
0.9989772787759494,
0.9990097976734847,
0.9990414616547146,
0.9990722883291779,
0.9991022950557125,
0.9991314989438310,
0.9991599168551279,
0.9991875654047181,
0.9992144609627068,
0.9992406196556911,
0.9992660573682882,
0.9992907897446957,
0.9993148321902777,
0.9993381998731797,
0.9993609077259696,
0.9993829704473038,
0.9994044025036201,
0.9994252181308537,
0.9994454313361775,
0.9994650558997651,
0.9994841053765757,
0.9995025930981609,
0.9995205321744921,
0.9995379354958073,
0.9995548157344778,
0.9995711853468930,
0.9995870565753632,
0.9996024414500382,
0.9996173517908444,
0.9996317992094352,
0.9996457951111574,
0.9996593506970310,
0.9996724769657434,
0.9996851847156547,
0.9996974845468164,
0.9997093868630000,
0.9997209018737374,
0.9997320395963699,
0.9997428098581069,
0.9997532222980933,
0.9997632863694836,
0.9997730113415246,
0.9997824063016426,
0.9997914801575380,
0.9998002416392840,
0.9998086993014300,
0.9998168615251084,
0.9998247365201450,
0.9998323323271717,
0.9998396568197407,
0.9998467177064404,
0.9998535225330116,
0.9998600786844637,
0.9998663933871905,
0.9998724737110845,
0.9998783265716498,
0.9998839587321121,
0.9998893768055266,
0.9998945872568815,
0.9998995964051983,
0.9999044104256269,
0.9999090353515359,
0.9999134770765971,
0.9999177413568642,
0.9999218338128448,
0.9999257599315647,
0.9999295250686255,
0.9999331344502529,
0.9999365931753376,
0.9999399062174669,
0.9999430784269460,
0.9999461145328103,
0.9999490191448277,
0.9999517967554878,
0.9999544517419835,
0.9999569883681778,
0.9999594107865607,
0.9999617230401926,
0.9999639290646355,
0.9999660326898712,
0.9999680376422052,
0.9999699475461585,
0.9999717659263435,
0.9999734962093266,
0.9999751417254756,
0.9999767057107922,
0.9999781913087290,
0.9999796015719915,
0.9999809394643231,
0.9999822078622751,
0.9999834095569596,
0.9999845472557860,
0.9999856235841805,
0.9999866410872889,
0.9999876022316609,
0.9999885094069193,
0.9999893649274085,
0.9999901710338274,
0.9999909298948430,
0.9999916436086862,
0.9999923142047299,
0.9999929436450469,
0.9999935338259505,
0.9999940865795161,
0.9999946036750835,
0.9999950868207405,
0.9999955376647868,
0.9999959577971798,
0.9999963487509599,
0.9999967120036571,
0.9999970489786785,
0.9999973610466748,
0.9999976495268890,
0.9999979156884846,
0.9999981607518545,
0.9999983858899099,
0.9999985922293493,
0.9999987808519092,
0.9999989527955938,
0.9999991090558848,
0.9999992505869332,
0.9999993783027293,
0.9999994930782556,
0.9999995957506171,
0.9999996871201549,
0.9999997679515386,
0.9999998389748399,
0.9999999008865869,
0.9999999543507984
};

double dolby_win_128[128] = {
4.3795702929468881e-005,
0.00011867384265436617,
0.0002307165763996192, 
0.00038947282760568383,
0.00060581272288302553,
0.00089199695169487453,
0.0012617254423430522,
0.0017301724373162003,
0.0023140071937421476,
0.0030313989666022221,
0.0039020049735530842,
0.0049469401815512024,
0.0061887279335368318,
0.0076512306364647726,
0.0093595599562652423,
0.011339966208377799,
0.013619706891715299,
0.016226894586323766,
0.019190324717288168,
0.022539283975960878,
0.026303340480472455,
0.030512117046644357,
0.03519504922365594,
0.040381130021856941,
0.046098643518702249,
0.052374889768730587,
0.059235903660769147,
0.066706170556282418,
0.074808341703430481,
0.083562952548726227,
0.092988147159339674,
0.1030994120216919,
0.11390932249409955,
0.12542730516149531,
0.13765941926783826,
0.15060816028651081,
0.16427228853114245,
0.17864668550988483,
0.19372224048676889,
0.20948576943658073,
0.22591996826744942,
0.24300340184133981,
0.26071052995068139,
0.27901177101369551,
0.29787360383626599,
0.3172587073594233,
0.33712613787396362,
0.35743154274286698,
0.37812740923363009,
0.39916334663203618,
0.42048639939189658,
0.4420413886774246,
0.4637712792815169,
0.4856175685594023,
0.50752069370766872,
0.52942045344797806,
0.55125643994680196,
0.57296847662071559,
0.59449705734411495,
0.61578378249506627,
0.63677178724712891,
0.65740615754163356,
0.67763432925662526,
0.69740646622548552,
0.71667581294953808,
0.73539901809352737,
0.75353642514900732,
0.77105232699609816,
0.78791518148597028,
0.80409778560147072,
0.81957740622770781,
0.83433586607383625,
0.84835958382689225,
0.86163956818294229,
0.87417136598406997,
0.88595496528524853,
0.89699465477567619,
0.90729884157670959,
0.91687983002436779,
0.92575356460899649,
0.93393934077779084,
0.94145948779657318,
0.94833902830402828,
0.95460531956280026,
0.96028768170574896,
0.96541701848104766,
0.97002543610646474,
0.97414586584250062,
0.97781169577969584,
0.98105641710392333,
0.98391328975491177,
0.98641503193166202,
0.98859353733226141,
0.99047962335771556,
0.9921028127769449,
0.99349115056397752,
0.99467105680259038,
0.9956672157341897,
0.99650250022834352,
0.99719793020823266,
0.99777266288955657,
0.99824401211201486,
0.99862749357391212,
0.99893689243401962,
0.99918434952623147,
0.99938046234161726,
0.99953439696357238,
0.99965400728430465,
0.99974595807027455,
0.99981584876278362,
0.99986833527824281,
0.99990724749057802,
0.99993570051598468,
0.99995619835942084,
0.99997072890647543,
0.9999808496399144,
0.99998776381655818,
0.99999238714961569,
0.99999540529959718,
0.99999732268176988,
0.99999850325054862,
0.99999920402413744,
0.9999996021706401,
0.99999981649545566,
0.99999992415545547,
0.99999997338493041,
0.99999999295825959,
0.99999999904096815
};

double dolby_win_120[120] = {
0.0000452320086910,
0.0001274564692111,
0.0002529398385345,
0.0004335140496648,
0.0006827100966952,
0.0010158708222246,
0.0014502162869659,
0.0020048865156264,
0.0027009618393178,
0.0035614590925043,
0.0046113018122711,
0.0058772627936484,
0.0073878776584103,
0.0091733284512589,
0.0112652966728373,
0.0136967855861945,
0.0165019120857793,
0.0197156688892217,
0.0233736582950619,
0.0275117992367496,
0.0321660098468534,
0.0373718682174417,
0.0431642544948834,
0.0495769778717676,
0.0566423924273392,
0.0643910061132260,
0.0728510874761729,
0.0820482749475221,
0.0920051937045235,
0.1027410852163450,
0.1142714546239370,
0.1266077410648368,
0.1397570159398145,
0.1537217139274270,
0.1684994012857075,
0.1840825856392944,
0.2004585710384133,
0.2176093615976121,
0.2355116164824983,
0.2541366584185075,
0.2734505372545160,
0.2934141494343369,
0.3139834135200387,
0.3351095011824163,
0.3567391223361566,
0.3788148623608774,
0.4012755686250732,
0.4240567828288110,
0.4470912150133537,
0.4703092544619664,
0.4936395121456694,
0.5170093888596962,
0.5403456627591340,
0.5635750896430154,
0.5866250090612892,
0.6094239491338723,
0.6319022228794100,
0.6539925088563087,
0.6756304090216887,
0.6967549769155277,
0.7173092095766250,
0.7372404969921184,
0.7565010233699827,
0.7750481150999984,
0.7928445309277697,
0.8098586906021583,
0.8260648390616000,
0.8414431440907889,
0.8559797262966709,
0.8696666212110165,
0.8825016743142358,
0.8944883707784486,
0.9056356027326216,
0.9159573778427816,
0.9254724739583072,
0.9342040454819434,
0.9421791879559176,
0.9494284680976784,
0.9559854271440150,
0.9618860658493898,
0.9671683198119525,
0.9718715339497299,
0.9760359449042233,
0.9797021798981759,
0.9829107801140203,
0.9857017559923277,
0.9881141809867999,
0.9901858292742826,
0.9919528617340944,
0.9934495632180476,
0.9947081327749199,
0.9957585271195989,
0.9966283562984427,
0.9973428292485683,
0.9979247458259197,
0.9983945309245774,
0.9987703055583410,
0.9990679892449266,
0.9993014277313617,
0.9994825400228521,
0.9996214788122335,
0.9997267987294857,
0.9998056273097539,
0.9998638341781910,
0.9999061946325793,
0.9999365445321382,
0.9999579241373735,
0.9999727092594598,
0.9999827287418790,
0.9999893678912771,
0.9999936579844555,
0.9999963523959187,
0.9999979902130101,
0.9999989484358076,
0.9999994840031031,
0.9999997669534347,
0.9999999060327799,
0.9999999680107184,
0.9999999918774242,
0.9999999989770326
};


#endif
