/**********************************************************************
MPEG-4 Audio VM Module
parameter based codec - individual lines: common module



This software module was originally developed by

Heiko Purnhagen (University of Hannover / Deutsche Telekom Berkom)
Bernd Edler (University of Hannover / Deutsche Telekom Berkom)

and edited by

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1996.



Header file: indilinecom.h

$Id: indilinecom.h,v 1.4 1997/11/20 21:22:36 purnhage Exp $

Required libraries:
(none)

Required modules:
common.o

Authors:
HP    Heiko Purnhagen, Uni Hannover <purnhage@tnt.uni-hannover.de>
BE    Bernd Edler, Uni Hannover <edler@tnt.uni-hannover.de>

Changes:
01-sep-96   HP    first version based on indiline.c
10-sep-96   BE
11-sep-96   HP
06-jun-97   HP    added M_PI
**********************************************************************/


#ifndef _indilinecom_h_
#define _indilinecom_h_


/* units & formats: */
/*  Freq: frequency in Hz */
/*  Ampl: peak amplitude of sine wave */
/*  Phase: phase in rad at frame center */
/*  Index: NumBit LSBs, to be transmitted MSB first */
/*  Pred: line predecessor index: 0=no pred., 1=line[0], 2=line[1], ... */


/* ---------- declarations ---------- */

#define ENVPARANUM 3

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif


/* ---------- functions ---------- */

#ifdef __cplusplus
extern "C" {
#endif


/* IndiLineExit() */
/* Print "indiline" error message to stderr and exit program. */
void IndiLineExit(
  char *message,		/* in: error message */
  ...);				/* in: args as for printf */


#ifdef __cplusplus
}
#endif

#endif	/* #ifndef _indilinecom_h_ */

/* end of indilinecom.h */
