/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/* mvdefault -- External variable defaults for mixview.
 */

#include "main.h"
#include "windows.h"
#ifdef NeXT
#define SFSR 44100
#else
#ifdef sparc
#define SFSR 8000
#else
#define SFSR 30000
#endif
#endif

extern sf_struct *v;
extern cbuf_struct *c;
extern FLAG line, insert, box, region, amps, is_buff, is_open;

set_defaults()
{

	/* default values for the display info structure */

	v->bufsize = 0;
	v->sfbuff = NULL;
	v->is_float = False;
	v->size = SF_SHORT;
	v->srate = SFSR;
	v->sfdur = 0.0;
	v->nchans = 1;
	v->peakamp = 1.0;

	/* default values for the soundfile header */

	v->sfh.sfinfo.sf_magic = 107364;
	v->sfh.sfinfo.sf_srate = v->srate;
	v->sfh.sfinfo.sf_chans = v->nchans;
	v->sfh.sfinfo.sf_packmode = v->size;
	v->sfh.sfinfo.sf_codes = 0;
	v->stime = 0.0;
	v->etime = 0.0;
	v->itime = 0.0;
	v->grainsize = 30.0;	/* in samples */

	/* initialize this to NULL */
	
	c->sfbuff = (char *) 0;
	
       	insert = 0;      
	region = 0;     
	is_buff = BUF_NONE; 
	is_open = 0;
	line = amps = box = 0;
#ifdef SPARC_DACS
	(void) get_audio_defaults();
#endif
}
