#ifndef XPLAY
#define XPLAY

/* min and max macros */
#ifndef max
#define max(a,b)  (((a) > (b)) ? (a) : (b))
#endif
#ifndef min
#define min(a,b)  (((a) < (b)) ? (a) : (b))
#endif

/* Include file for the X-interface */

/* Include files required for all toolkit programs */

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Include files required for this program */

#include <X11/Xaw3d/Command.h>
#include <X11/Xaw3d/Form.h>
#include <X11/Xaw3d/Toggle.h>
#include <X11/Xaw3d/Box.h>
#include <X11/Xaw3d/AsciiText.h>
#include <X11/Xaw3d/Dialog.h>
#include <X11/Xaw3d/SimpleMenu.h>
#include <X11/Xaw3d/MenuButton.h>
#include <X11/Xaw3d/SmeBSB.h>
#include <X11/Xaw3d/SmeLine.h>
#include <X11/Xaw3d/Scrollbar.h>
#include <X11/Xaw3d/Cardinals.h>

#include "./bitmaps/title.bit"
#include "./bitmaps/stop.bit"
#include "./bitmaps/play.bit"
#include "./bitmaps/record.bit"
#include "./bitmaps/rwnd.bit"
#include "./bitmaps/ffwd.bit"
#include "./bitmaps/zoom_out.bit"
#include "./bitmaps/zoom_in.bit"

#include "./bitmaps/brsh_curs.bit"
#include "./bitmaps/arr_curs.bit"
#include "./bitmaps/crs_curs.bit"
#include "./bitmaps/x_curs.bit"

#include "play.h"

#define MAXPATHLEN 100
#define MW XtVaCreateManagedWidget
#define SPEED_LEN 6
#define LIMIT_LEN 6
#define NAME_LEN 31
#define GRAPH_HEIGHT 90
#define GRAPH_WIDTH 490

typedef struct _DialogInfo {
   int arg;
   void (*func)(arg);
   int flag;            /* discard_question == YES: flag dependend action */
} DialogInfo;



int wave_envelope[500][2];
int wave_envelope_filter[500][2];
/************************************************************************/
/*         data for effects types   */

typedef struct _Marker {
   int x1;
   int x2;
   int mod;
   int period;
   int freq;
   int amplitude;
   int cutoff;
   int feedback;
   int delay;
   int centre;
   int width;
} Marker;

extern Marker ef_mrk;

/*********************************************************************/
/*** main window widget structure        */

typedef struct {
   Widget main_form;
   Widget quit_btn;
   Widget play_btn, record_btn, stop_btn,rwnd_btn,ffwd_btn;
   Widget zoom_out_btn, zoom_in_btn;
   Widget graph_1,graph_2;
   Widget scrollbar;
   Widget stereo_btn, mono_btn;
   Widget radio_box2, radio_box3, radio_box4;
   Widget eight_bit_btn, twelve_bit_btn, sixteen_bit_btn;
   Widget bit_label;
   Widget song_title1, song_title2, title_label;
   Widget speed, graph1, graph2;
   Widget speed_label, limit_label, limit;
   Widget menu_box, file_menu_btn, file_menu;
   Widget load_btn, save_btn, quit_menu_btn, nothing;
   Widget effects_menu_btn, effects_menu;
   Widget echo_btn;
   Widget reverse_btn;
   Widget synthesis_btn;
   Widget lowpass_btn;
   Widget interface_menu_btn, interface_menu;
   Widget setup_btn;
   Widget run_btn;
   Widget run_btn1;
   Widget run_btn2;
   Widget run_btn3;
   Widget run_btn4;
   Widget run_btn5;
   Widget run_btn6;
   Widget edit_menu_btn, edit_menu;
   Widget cut_btn;
   Widget copy_btn;
   Widget paste_btn;
} widget_structure;

extern widget_structure ww;

/*********************************************************************/
/******* structure for effects data input dialog widgets  *******/

typedef struct {
   Widget file_dialog;
   Widget command_dialog;
   Widget quit_btn;
   Widget echo_btn;
   Widget comp_btn;
   Widget lowpass_btn;
   Widget highpass_btn;
   Widget delay_label;
   Widget delay;
   Widget feedback_label;
   Widget feedback;
   Widget pan;
   Widget pan_label;
   Widget freq;
   Widget freq_label;
   Widget scrollbar1;
   Widget scrollbar2;
   Widget scrollbar3;
   Widget scrollbar4;
} scroll_struct;

extern scroll_struct scrl;

/*************************************************************************/
/*********** structure for file selection dialog widgets    ***********/
 
typedef struct {
   Widget file_dialog;
   Widget quit_btn;
   Widget ok_btn;
   Widget list;
   Widget file_sel;
} widget_struct_dlgs;

extern widget_struct_dlgs fd;


typedef struct {
   GC graph_GC, line_GC, delete_line_GC;
} graph_ctx;

/* Prototypes for all functions used */
void quit_question(Widget w, XtPointer client_data, XtPointer call_data);
void quit_application();
void stop_playing(Widget w, XtPointer client_cata, XtPointer call_data);
void play_sample(Widget w, XtPointer client_data, XtPointer call_data);
void get_changeable_options();
void record_question(Widget w, XtPointer client_data, XtPointer call_data);
void ffwd();
void rwnd();
void record_sample();
void zoom_out(Widget w, XtPointer client_data, XtPointer call_data);
void zoom_in(Widget w, XtPointer client_data, XtPointer call_data);
void open_dialog(Widget w, XtPointer client_data, XtPointer call_data);

void interface_dialog(Widget w, XtPointer client_data, XtPointer call_data);
void iface1(Widget w, XtPointer client_data, XtPointer call_data);

void Scrolled(Widget , XtPointer , XtPointer );
void Jumped(Widget , XtPointer , XtPointer );

void calculate_echo(Widget w, XtPointer client_data, XtPointer call_data);
void calculate_reverse(Widget w, XtPointer client_data, XtPointer call_data);
void calculate_synthesis(Widget w, XtPointer client_data, XtPointer call_data);
void Lowpass(Widget w, XtPointer client_data, XtPointer call_data);
void Highpass(Widget w, XtPointer client_data, XtPointer call_data);

void cut(Widget w, XtPointer client_data, XtPointer call_data);
void copy(Widget w, XtPointer client_data, XtPointer call_data);
void paste(Widget w, XtPointer client_data, XtPointer call_data);

void save_file();
void load_file();
int interface_exec();
void update_display();
void set_limit_borders_action(Widget w, XEvent *event, String *params, 
                              Cardinal *num_params);
void calculate_limit_borders();
void draw_limit_borders(int x1, int x2);
void popup_file_dialog(Widget w, String str, String def_fn, void (*func)() );
void popup_centered(Widget w);
void popdown_file_dialog_action(Widget w, XEvent *event, String *params, 
                                Cardinal *num_params);
void popdown_file_dialog(Widget w, XtPointer client_data, XtPointer call_data);
void close_error(Widget w, XtPointer client_data, XtPointer call_data);
void discard_question(int flag);
void discard_answer(Widget w, XtPointer client_data, XtPointer call_data);
void create_GC(graph_ctx *g_ctx, graph_ctx *g_ctx1);
void create_widget_hierarchy(Widget top_level, 
                             char *speed_buf, char *limit_buf,char *iface_name[20], 
                             char *song_name_buf1, char *song_name_buf2,
			     graph_ctx *g_ctx, graph_ctx *g_ctx1);
int define_color(Widget w, char *color);
void expose_graph_action(Widget w, XEvent *event, String *params, 
                                Cardinal *num_params);

#endif
