/***************************************************************
all code is the copyright of Will Fish 1996 here on called the author
e-mail fishwj@ee.port.ac.uk
although this code is classed as free software it must be registered
and is covered by the following licence agreement

all copying or incorporation of this code in other pieces of software
 or use of this code for any purpose must be registered and autorised by the 
author. i.e. you may not use this software until you have registered it

use of this code without registration is considered to be infringement
of copyright and is agreement of the following terms

1) you will pay the author the sum of twenty pounds sterling or
make an equivalent donation to the free software foundation

2) you will contribute to the further developement of this software


******************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <linux/soundcard.h>
#include <malloc.h>
#include <math.h>
#include <stdlib.h>

#define ClampSample(nxx)           max(min(nxx,255),0)

#define MAX_CUTOFF 100

#include "xplay.h"

typedef struct _Band_t {
        float   center;
        float   width;
        double  A, B, C;
        double  out1, out2;
        short   noise;
        /* 50 bytes of data, 52 bytes long for allocation purposes. */
} band_t;

char * LowpassWave(char *edit_buf, char * temp_buf, int cutoff,Marker mark)
{
wave_header head;
int  headsize;
    char          smp[2 * MAX_CUTOFF + 1],
                    tsmp;
    unsigned long   samples,
                    n;
    int             i;
    char            gtr[16];


memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
samples = (mark.x2 - mark.x1);
    /* cutoff=(MAX_CUTOFF*2+1)-cutoff; */
    for (i = 0; i < cutoff; ++i)
        smp[i] = 128;
    for (n = 0; n < samples; ++n) {
        for (i = cutoff - 1; i > 0; --i)
            smp[i] = smp[i - 1];
        smp[0] = (char) (temp_buf[headsize+mark.x1+n]);
           for (tsmp = 0, i = 0; i < cutoff; ++i) {
            tsmp += smp[i];
        }
        tsmp = (char) (tsmp / cutoff);
        edit_buf[headsize+mark.x1+n] = (char) max(min(tsmp, 255), 0);
    }
return(edit_buf);
}



char * ReverseWave(char *edit_buf,char *temp_buf, Marker mark)
{
    unsigned long   samples,
                    n;
int  headsize;
wave_header head;

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
samples = (mark.x2 - mark.x1);
    for (n = 0; n < samples; ++n)
edit_buf[headsize+n+mark.x1] = temp_buf[(headsize+mark.x2) - n  ];
return(edit_buf);
}


char * EchoWave(char *edit_buf,char *temp_buf, int delay, int feedback, Marker mark)
{
   wave_header head;
int  headsize;
    char          smp,
                    tsmp;
    unsigned long   samples,
                    n,
                    echo;
memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);
samples = (mark.x2 - mark.x1);
    for (n = 0; n < samples; ++n)
        edit_buf[mark.x1+headsize+n] = 0;
    for (n = 0; n < samples; ++n) {
        tsmp = ((char) edit_buf[mark.x1+headsize+n]);
        smp = ((char) temp_buf[mark.x1+headsize+n]);
        edit_buf[mark.x1+headsize+n] = ClampSample(smp + tsmp);
for (echo = (mark.x1+headsize+n) + delay; mark.x1+headsize+n + echo < samples; echo += delay) {
           smp = (smp * feedback) / (feedback + 1);
            if (!smp)
                break;
            tsmp = (edit_buf[echo]) - 128;
            edit_buf[echo] =(char) ClampSample(128 + (tsmp + (smp - 128))) / 2;
        }
    }
return(edit_buf);
}


char * HighpassWave(char *edit_buf, char *temp_buf, int cutoff,Marker mark)
{
int  headsize;
wave_header head;
    char          smp[2 * MAX_CUTOFF + 1],
                    tsmp;
    unsigned long   samples,
                    n;
    int             i;

    /* cutoff=cutoff*2; */

memcpy(&head, edit_buf, sizeof(head));
headsize = sizeof(head);

    samples = head.data_length-(headsize+20);
    /* cutoff=(MAX_CUTOFF*2+1)-cutoff;  */
    for (i = 0; i < cutoff; ++i)
        smp[i] = 128;

    for (n = headsize+20; n < samples; ++n) {
        for (i = cutoff - 1; i > 0; --i)
            smp[i] = smp[i - 1];
        smp[0] = (char) (temp_buf[n]);
        for (tsmp = 0, i = 0; i < cutoff; ++i) {
            tsmp += smp[i];
        }
        tsmp = (char) (tsmp / cutoff);
        edit_buf[n] = (char) max(min(tsmp, 255), 0);
        if (edit_buf[n] < temp_buf[n]) {
            edit_buf[n] = (char) 1; 
        }
    }
return(edit_buf);
}

band_start( char *edit_buf, char *temp_buf, int center , int width,Marker mark)
{
    band_t  band;
    char wavedinfo[200],kh[12];
   wave_header head;
   DWORD samp_psec;
   char *temp_buf1;

 memcpy(&head, edit_buf, sizeof(head));
samp_psec = head.byte_p_sec;


      band.center=center;
      band.width=width;
        if (band.center > samp_psec/2)

        band.C = exp(-2*M_PI*band.width/samp_psec);
        band.B = -4*band.C/(1+band.C)*
                cos(2*M_PI*band.center/samp_psec);
        if (band.noise)
                band.A = sqrt(((1+band.C)*(1+band.C)-band.B *
                        band.B)*(1-band.C)/(1+band.C));
        else
                band.A = sqrt(1-band.B*band.B/(4*band.C))*(1-band.C);
        band.out1 = band.out2 = 0.0;

        band_flow(edit_buf,temp_buf, band );
}

/*
 * Processed signed long samples from ibuf to obuf.
 * Return number of samples processed.
 */

band_flow(char *edit_buf, char *temp_buf,band_t band){
        
        register counter, tablen;
        int lenw, done;
        register long mult;
        register short *sinetab;
        double d;
        long l,n,m;
  wave_header head;

 memcpy(&head, edit_buf, sizeof(head));

n = m =0L;
        lenw = head.data_length;

        /* yeah yeah yeah registers & integer arithmetic yeah yeah yeah */
        for(done = 0; done < lenw; done++) {

                l = (long) (temp_buf[n]);
                n=n+1L;
                d = (band.A * l - band.B * band.out1) - band.C * band.out2;
                band.out2 = band.out1;
                band.out1 = d;
                edit_buf[m] =(char)floor(d);
                m=m+1L;
        }
}



