#include <stdio.h>
#include <stdlib.h>
#include "sfheader.h"
#include "crack.h"
#include "pv.h"

#define Max_Table_Size 131073

typedef struct {
  int           elms;
  float         *data;
} Tabl;

complex zero = {0., 0.};
complex one = {1., 0.};
float IPI;
float TWOPI;
float synt = 0.;

main(argc, argv)
    int argc; char *argv[];
{
    int 	i,
		R = 44100,
		N = 1024,
		N2,
		Nw = 0,
		Nw2, 
		D = 0, 
		I = 0,
		in,
		on,
		eof = 0,
		start = 0,
		mid = 0,
		end = 0,
		real, imag,
		amp, phase;
    float	magn,
		ctime = 0.,
		tinc,
		fpos_a,
		fpos_b,
		a1,a2,
		b1,b2,
		starttime_a,
		starttime_b,
		endtime_a,
		endtime_b,
      		*Hwin,
		*Wanal,
		*Wsyn,
		*input1,
                *input2,
		*buffer1,
                *buffer2,
		*channel1,
                *channel2,
		*output;
    double	mult,
		rmult = 1.;
    char	ch,
		file1[1024],
                file2[1024],
		table1[1024],
                table2[1024],
		*dbuf;
    FILE	*fp1,
                *fp2,
		*fp3,
		*fp4;
    Tabl	ftabl1,
                ftabl2;

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|F|m|t|T|a|b|A|B|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'f':	strcpy(file1, arg_option);
			break;
	    case 'F':	strcpy(file2, arg_option);
			break;
	    case 'm':   rmult = atof(arg_option);
	                break;
	    case 't':	strcpy(table1, arg_option);
			break;
	    case 'T':	strcpy(table2, arg_option);
			break;
	    case 'a':	starttime_a = atof(arg_option);
			break;
	    case 'b':	starttime_b = atof(arg_option);
			break;
	    case 'A':	endtime_a = atof(arg_option);
			break;
	    case 'B':	endtime_b = atof(arg_option);
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (D == 0)
      D = N / 8;

    if (I == 0)
      I = D;

    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;
    tinc = (float) D / (float) R;

    if ( strcmp(file1, file2) == 0 ) {
      fprintf(stderr,"lame and boring file selection\n");
      usage(1);
    }

    buffer1 = (float *) space( N, sizeof(float) );
    buffer2 = (float *) space( N, sizeof(float) );
    channel1 = (float *) space( N+2, sizeof(float) );
    channel2 = (float *) space( N+2, sizeof(float) );
    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    input1 = (float *) space( Nw, sizeof(float) );
    input2 = (float *) space( Nw, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

/* open input files */
    if ( (fp1 = fopen( file1, "r" )) == NULL ) {
	fprintf(stderr,"Where is %s?\n",file1);
	exit(-1);
    }
    if ( (fp2 = fopen( file2, "r" )) == NULL ) {
      fprintf(stderr,"Where is %s?\n",file2);
      exit(-1);
    }

    ftabl1.elms = Max_Table_Size;
    ftabl1.data = (float *) space( Max_Table_Size, sizeof(float) );
    
    if ( (fp3 = fopen( table1, "r" )) == NULL ) {
      fprintf(stderr,"What is %s?\n", table1);
      exit(-1);
    }
    i = 0;
    while ( (fread(ftabl1.data+i, sizeof(float), 1, fp3)) != 0 && 
	   i < Max_Table_Size )
      ++i;
    ftabl1.elms = i;

    ftabl2.elms = Max_Table_Size;
    ftabl2.data = (float *) space( Max_Table_Size, sizeof(float) );
    
    if ( (fp4 = fopen( table2, "r" )) == NULL ) {
      fprintf(stderr,"What is %s?\n", table2);
      exit(-1);
    }
    i = 0;
    while ( (fread(ftabl2.data+i, sizeof(float), 1, fp4)) != 0 && 
	   i < Max_Table_Size )
      ++i;
    ftabl2.elms = i;

    (void) stripheader(fp1);
    (void) stripheader(fp2);

    while ( !eof ) {

      in += D;
      on += I;
      
      eof = turnin( input1, Nw, D, fp1 );
      if (eof)
	(void) turnin( input2, Nw, D, fp2 );
      else
	eof = turnin( input2, Nw, D, fp2 );
      
      fold( input1, Wanal, Nw, buffer1, N, in );
      fold( input2, Wanal, Nw, buffer2, N, in );
      rfft( buffer1, N2, FORWARD );
      rfft( buffer2, N2, FORWARD );
      
/*	tainter( buffer1, buffer2, channel1, channel2, N2, rmult ); */

      if (ctime >= starttime_a) {
	if (ctime >= endtime_a)
	  fpos_a = (float) ftabl1.elms - 1;
	else
	  fpos_a = (ctime - starttime_a) / (endtime_a - starttime_a) * ftabl1.elms;
      }
      else
	fpos_a = 0.;

      if (ctime >= starttime_b) {
	if (ctime >= endtime_b)
	  fpos_b = (float) ftabl2.elms - 1;
	else
	  fpos_b = (ctime - starttime_b) / (endtime_b - starttime_b) * ftabl2.elms;
      }
      else
	fpos_b = 0.;

      for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	a1 = ( i == N2 ? *(buffer1+1) : *(buffer1+real) ) ;
	b1 = ( i == 0 || i == N2 ? 0. : *(buffer1+imag) ) ;
	a2 = ( i == N2 ? *(buffer2+1) : *(buffer2+real) ) ;
	b2 = ( i == 0 || i == N2 ? 0. : *(buffer2+imag) ) ;
	*(channel1+amp) = hypot( a1, b1 );
	*(channel1+phase) = -atan2( b1, a1 );
	*(channel2+amp) = hypot( a2, b2 );
	*(channel2+phase) = -atan2( b2, a2 );
      }


      for ( i=0; i <= N2; i++ ) {
	phase = (amp = i<<1) + 1;
	*(channel1+amp) *= *(ftabl1.data+(int)fpos_a);
	*(channel2+amp) *= *(ftabl2.data+(int)fpos_b);
	if ( *(channel2+amp) > *(channel1+amp) ) {
	  *(channel1+amp) = *(channel2+amp);
	  *(channel1+phase) = *(channel2+phase);
	}
      }
      
      for ( i = 0 ; i <= N2 ; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1 ;
	*(buffer1+real) = *(channel1+amp) * cos( *(channel1+phase) );
	if ( i != N2 ) 
	  *(buffer1+imag) = -*(channel1+amp) * sin( *(channel1+phase) );
      }
      ctime += tinc;

      rfft( buffer1, N2, INVERSE );
      overlapadd( buffer1, N, Wsyn, output, Nw, on );
      shiftout( output, Nw, I, on );
    }
    exit(0);
}

void stripheader(fp)
FILE *fp;
{
  register int i;

  for ( i=0; i < SIZEOF_HEADER; i++ )
    fgetc(fp);
}

usage(woof)
{
    fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
	"turpitude:  FFT based spectral interpolation\n",
	"turpitude   [flags] > floatsams\n",
	"	N:	fft length [2^n]\n",
	"	R:	sampling rate\n",
	"	M:	window size in samples\n",
	"	D:	decimation factor in samples\n",
	"	I:	interpolation factor in samples\n",
	"	f:	source soundfile\n",
	"	F:	filter soundfile\n",
	"	m:	filtering multiplier\n",
	"	t:	first interpolation function (a)\n",
	"	T:	second interpolation function (b)\n",
	"	a:	begin time of first signal function (a)\n",
	"	b:	begin time of second signal function (b)\n",
	"	A:	end time of first signal function (a)\n",
	"	B:	end time of second signal function (b)\n",
	"	h:	this bouncy place\n");
    exit(woof);
}

