#include <stdio.h>
#include "../PVLIB/pv.h"
complex zero = { 0., 0. } ;
complex one = { 1., 0. } ;
float IPI ;
float TWOPI ;
float synt ;
extern char *arg_option;
/*
USES A TRIGGER TO EXCLUDE
LOW AMPLITUDE FREQUENCIES
*/

#define ivec( name, size )\
if ( ( name = (int *) calloc( size, sizeof(int) ) ) == NULL) {\
    fprintf( stderr, "Insufficient memory\n" );\
    exit( -1 );\
}


main( argc, argv )
    int argc ; char *argv[] ;
{
/* double atof();   */
char ch;
 int R=44100, N=1024, N2, Nw=4096, Nw2, D=512, I=512, i, in, on, eof = 0, obank = 0 ;
 float P=0.0, *Hwin, *Wanal, *Wsyn, *input, *winput, *buffer, *channel, *output ;
 float value;
 int hoop;
 FILE *fp1, *fp2, *fopen();
char decayfunc[128] = "decay"; 
float sthresh;
int sflag=0;
int j;
int first = 1;
float amp_max;
float *decay;
float *hold;
float threshgen = .005;
float drygain=0.0, wetgain=1. ;
float dry, wet;
int Qflag = 0;
float trigger_thresh, ttgen = .01 ;
int *trigger;
/*
WILL NEED N/2 SIZE FUNCTION TO CONTROL
DECAYMULT
*/
if( isatty(1) ) 
   usage(-1);
    while( (ch= crack( argc, argv, "R|N|M|D|I|F|l|d|s|t|T|g|G|q|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'd':   strcpy(decayfunc, arg_option);
			break;
	    case 't':   threshgen = atof(arg_option);
			break;
	    case 'T':   ttgen = atof(arg_option);
			break;
	    case 'g':   drygain = atof(arg_option);
			break;
	    case 'G':   wetgain = atof(arg_option);
			break;
	    case 'q':   Qflag = 1;
			break;
	    case 's':	sflag = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    IPI = 4.*atan(1.) ;
    TWOPI = 8.*atan(1.) ;
    obank = P != 0. ;
    N2 = N>>1 ;
    Nw2 = Nw>>1 ;
    fvec( Wanal, Nw ) ;		/* analysis window */
    fvec( Wsyn, Nw ) ;		/* synthesis window */
    fvec( input, Nw ) ;		/* input buffer */
    fvec( Hwin, Nw ) ;		/* plain Hamming window */
    fvec( winput, Nw ) ;	/* windowed input buffer */
    fvec( buffer, N ) ;		/* FFT buffer */
    fvec( channel, N+2 ) ;	/* analysis channels */
    fvec( output, Nw ) ;	/* output buffer */
    fvec( hold, N2+1 );
    fvec( decay, N2+1 );
    ivec( trigger, N2+1 );

    if ( (fp1 = fopen( decayfunc, "r" )) == NULL ) {
	fprintf(stderr,"decay function %s not found\n",decayfunc);
	exit(-1);
    }
     

    if (fread(decay, sizeof(float), N2, fp1) == 0) {
	fprintf(stderr,"decay function must be size N/2\n");
 	exit(-1);
    }

    if (sflag)
      D = 0;
/* if( P )
   fprintf(stderr,"USING OSCILLATOR BANK RESYNTHESIS\n"); */
    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank ) ;
    in = -Nw ;
    if ( D )
	on = (in*I)/D ;
    else
	on = in ;
    while ( !eof ) 
    {

	in += D ;
	on += I ;
	if ( D == 0 ) {
	    for ( hoop=0; hoop < N+2; hoop++ ) {
		if ( fread(channel+hoop, sizeof(float), 1, stdin) == 0 )
		    eof = 1;
	    }
	}else {
	   eof = shiftin( input, Nw, D ) ;
	   fold( input, Wanal, Nw, buffer, N, in ) ;
	   rfft( buffer, N2, FORWARD ) ;
	   if(Qflag)
	      convert( buffer, channel, N2, D, R ) ;
	   else 
	      leanconvert( buffer, channel, N2, D, R ) ;
	}
	if( first ){
	   for(i = 0, j = 0; i< N2 ; i++, j += 2 )
	      hold[i] = channel[j] * decay[i] ;
	   first = 0;
	} 
	else {
            amp_max = 0.0;
	    for(i=0;i<N;i+=2)
	      if(channel[i] > amp_max ) 
 	        amp_max = channel[i];
	    synt = amp_max * threshgen;
	    trigger_thresh = amp_max * ttgen;
	    for( i = 0; i < N2; i+=2){
	       if(channel[i] >= trigger_thresh && (!trigger[i]))
	          trigger[i] = 1;
	       }
	   for(i = 0, j = 0; i< N2 ; i++, j += 2 ){
	      if( trigger[i] && decay[i] > .000001){
	         if( wetgain != 1.0 || drygain != 1.0 ){
		 
		    wet = (wetgain==1.) ? hold[i] : hold[i]*wetgain ;
		    if( drygain != 0.0 )
		       dry = (drygain==1) ? channel[j] : channel[j]*drygain ;
		 }
		 else 
	            channel[j] += hold[i];
	         hold[i]  *= decay[i] ;
	         if( hold[i] < synt ){
	            hold[i] = channel[j] ;
		 }
	         channel[j] = (drygain==0.0) ? wet : dry+wet;
	   }
	   else channel[j] = 0.0 ;
	   }
	}
	if ( obank ) {
	    noscbank(channel, N2, R, Nw, I, P, output);
	    shiftout( output, Nw, I, on+Nw-I ) ;
	} else {
	    if(Qflag)
	    unconvert( channel, buffer, N2, I, R ) ;
	    else 	    
	       leanunconvert( channel, buffer, N2, I, R ) ;
	    rfft( buffer, N2, INVERSE ) ;
	    overlapadd( buffer, N, Wsyn, output, Nw, on ) ;
	    shiftout( output, Nw, I, on ) ;
	
	   }
	
    }
    fprintf(stderr,"SHINGLES: RESYNTHESIS COMPLETED\n");
    exit( 0 ) ;
   
}

usage(meow)
{
    fprintf(stderr, "%s",
	"shingles:  frequency sensitive reverberation\n"
	"shingles   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	D:	decimation factor in samples [512]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	d:	decay function [decay]\n"
	"	t:	reverb gate threshold generator [.005]\n"
	"	T:	synthesis threshold generator [.01]\n"
	"	g:	gain for dry signal [0.0]\n"
	"	G:	gain for reverb [1.]\n"
	"	q:	maintain phase coherence\n"
	"	s:	synthesize analysis input\n"
	);
    exit(meow);
}
