#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float IPI;
float TWOPI;
float synt = 0.;
extern char *arg_option;

main(argc, argv)
    int argc; char *argv[];
{
  int R=44100, N=1024, N2, Nw = 4096, Nw2, D = 512, I = 512, in, on, 
  eof = 0, obank = 0;
  float len, tincr, tpos, *Hwin, *Wanal, *Wsyn, *input, *winput,
  *buffer, *channel, *output; 
  float init_position = 0;
  char	ch, *dbuf;
  char vfuncname[128] = "vfunc",
   pfuncname[128] = "pfunc";
  float duration, outdur;
  int pvcount = 0;
  int N_Frames = 0;
  int N_OutFrames;
  int i,j,k;
  int pflag=0, Pflag=1;
  int P;
  int vflen, pflen;
  float **wherehouse;
  float *sucker;
  float *vfunc, *pfunc, *posfunc;
  FILE *fopen(), *fp1, *fp2;
  int bad_read_flag;
  int new_frame_len;
    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|F|f|i|o|s|a|h|p|P|v|", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 'p':   init_position = atof(arg_option);
	    		pflag = 1;
			Pflag = 0;
	    		break;
	    case 'P':	strcpy(pfuncname, arg_option);
	    		Pflag = 1;
	    		break;
	    case 'v':	strcpy(vfuncname, arg_option);
	    		break;
	    case 'i':   duration = atof(arg_option);
			break;
	    case 'o':   outdur = atof(arg_option);
	    		break;
	    case 'h':	usage(1);
	}
    }
    
    IPI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    obank = P != 0.;
    N2 = N>>1;
    Nw2 = Nw>>1;
    
    if( pflag && (init_position < 0.0 || init_position> 1.0) ){
      fprintf(stderr,"initial position range is [0-1]\n"); 
      exit(-1);
    }
    if( pflag && Pflag ){
      fprintf(stderr,"Please choose either 'p' with position or 'P' with function name\n");
      exit(-1);
    }
    if( outdur <= 0.0  || duration <= 0.0) {
      fprintf(stderr,"must specify durations > 0\n");
      exit(-1);
    }

    if( N_Frames == 0 )
      N_Frames = (int) ((((float)R+(float)Nw)/(float)D)*duration);
       if( (fp1 = fopen(vfuncname, "r")) == NULL ) 
          readerr( vfuncname );
       vflen = readin( fp1, &vfunc );
       if( vflen != N2 ) {
          fprintf(stderr,"velocity function must be of size %d, was actually %d\n",N2,vflen);
          exit(-1);
       }
       if( Pflag ){
         if( (fp2 = fopen(pfuncname, "r")) == NULL ) readerr( pfuncname );
         pflen = readin( fp2, &pfunc );
         if( pflen != N2 ) {
         fprintf(stderr,"position function must be of size %d\n",N/2);
         exit(-1);
         }
       }
       else {
         pfunc = (float *) space( N2, sizeof(float) );
         for(i = 0; i < N2; i++ ){
	    pfunc[i] = init_position;
         }
       }
    N_OutFrames =(int)((float)N_Frames * (outdur/duration)); 
    if (Nw == 0)
	Nw = N;
    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    winput = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );	   
    channel = (float *) space( N+2, sizeof(float) ); 
    sucker = (float *) space( N+2, sizeof(float) );    /*LOCATION FOR SYNTHETIC SPECTRUM   */
    output = (float *) space( Nw, sizeof(float) );
    posfunc = 	(float *) space( N2, sizeof(float) );
  if( ( wherehouse = (float **) calloc(N_Frames, sizeof(float *) ) ) == NULL) 
     memerr();
  for ( i=0; i < N_Frames; i++ ) {
    if( (*(wherehouse+i) = (float *) calloc(N+2, sizeof(float)) ) == NULL) 
        memerr();
  }


    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, obank );

    in = -Nw;
    on = in;

bad_read_flag = 0;

/* READ ANALYSIS FROM STDIN    */
	  for( i = 0 ; i < N_Frames; i++ ){
            for( j = 0; j < N+2; j++ )
	      if ( fread(&wherehouse[i][j],sizeof(float),1,stdin) == NULL ){
	      bad_read_flag = 1;
	      break;
             }
	     if( bad_read_flag){
	       new_frame_len = i;
	       N_OutFrames =(int)((float)new_frame_len * (outdur/duration));
	       break;
	       }
	     }
	     if( bad_read_flag) N_Frames = new_frame_len;
    fprintf(stderr,"\nRESENT: ANALYSIS SCAN COMPLETED\n");
/* SYNTHESIS ONLY
// MAP posfunc TO VALUES BETWEEN 0-(Nframes-1)    */
   setfrpos( posfunc, pfunc, N2, N_Frames );
/* SYNTHESIS LOOP    */
    for(i=0; i<N_OutFrames; i++) {
	on += I;
/* ADVANCE POSITION OF EACH amp/freq PAIR INDEPENDENTLY   */
        advance(posfunc, vfunc, N2, N_Frames);
/* A NEW FFT IS SYNTHESISED FROM THE ANALYSIS DATA,
// BASED ON THE FRAME POSITIONS OF EACH amp/freq PAIR   */
        k = 0;
        for(j = 0; j < N; j+=2 ){     
           sucker[j] = wherehouse[(int)posfunc[k]][j];
           sucker[j+1] = wherehouse[(int)posfunc[k]][j+1];
           ++k;
        }
	unconvert( sucker, buffer, N2, I, R );
        rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }

/* TERMINATE    */
    fprintf(stderr,"RESENT: SYNTHESIS COMPLETED\n");
    exit(0);
}
usage(meow)
{
    fprintf(stderr, "%s",
	"resent:  pvoc data skateboarding\n"
	"resent   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate [44100]\n"
	"	M:	window size in samples [4096]\n"
	"	I:	interpolation factor in samples [512]\n"
	"	p:	initial position of every amp/freq pair\n"
	"	P:	start position function [pfunc]\n"
	"	v:	frame speed function [vfunc]\n"
	"	i:	duration of input\n"
	"	o:	duration of output\n"
	"	a:	analysis data output\n"
	"	s:	synthesize analysis input\n"
	);
    exit(meow);
}
memerr()
{
fprintf(stderr,"Richard Nixon Alert: No Memory Left\n");
exit(-1);
}
advance( pos, adv, len, Nframes )
int len, Nframes;
float adv[], pos[];
{
  int i;

  for(i=0; i < len; i++ ) {
    pos[i] = pos[i] + adv[i];
    while ( pos[i] < 0. )
      pos[i] = (float)(Nframes-1) + pos[i];
    while ( pos[i] >= (float) (Nframes-1) )
      pos[i] = pos[i] - (float) (Nframes-1);
  }
}
setfrpos( parr, arr, len, Nframes ) int len, Nframes; float parr[], arr[];
{
int i;
   for(i = 0; i < len; i++ ){
      parr[i] =  (arr[i] * (float) (Nframes-1) );
   }
}
/* DEBUG ONLY   */
showfrpos( arr, len ) float arr[]; int len;
{
int i;
   for(i = 0; i < len; i++ )
      fprintf(stderr,"%f\n",arr[i]);
}
