#include <stdlib.h>
#include <stdio.h>
#include "../PVLIB/pv.h"

complex zero = { 0., 0. };
complex one = { 1., 0. };
float PI;
float TWOPI;
float synt = 0.;
int invert = 0;
extern *arg_option ;
main(argc, argv)
    int argc; char *argv[];
{
    int 	R=44100,
		N=1024,
		N2,
		Nw = 4096,
		Nw2, 
		D = 512, 
		I = 512,
		in,
		on,
		eof = 0;
    float 	*Hwin,
		*Wanal,
		*Wsyn,
		*input,
		*buffer,
		*channel,
		*output,
		thresh = .001,
		mvthresh,
		fmult = .1;
    char	ch;
    void drowned();
    float getthresh();
    int sflag  = 0;
    if (isatty(0))
	usage(1);

    while( (ch= crack( argc, argv, "R|N|M|D|I|f|t|m|i|s|h", 0  )) != NULL ) {
	switch(ch) {
	    case 'R':	R = atoi(arg_option);
			break;
	    case 'N':	N = atoi(arg_option);
			break;
	    case 'M':	Nw = atoi(arg_option);
			break;
	    case 'D':	D = atoi(arg_option);
			break;
	    case 'I':	I = atoi(arg_option);
			break;
	    case 't':	thresh = atof(arg_option);
			break;
	    case 's':	sflag = 1;
			D = 0;
			break;
	    case 'm':	fmult = atof(arg_option);
			break;
	    case 'i':	invert = 1;
			break;
	    case 'h':	usage(1);
	}
    }

    if (Nw == 0)
	Nw = N;

    if (I == 0)
	I = D;

    PI = 4.*atan(1.);
    TWOPI = 8.*atan(1.);
    N2 = N>>1;
    Nw2 = Nw>>1;

    Wanal = (float *) space( Nw, sizeof(float) );
    Wsyn = (float *) space( Nw, sizeof(float) );
    input = (float *) space( Nw, sizeof(float) );
    Hwin = (float *) space( Nw, sizeof(float) );
    buffer = (float *) space( N, sizeof(float) );
    channel = (float *) space( N+2, sizeof(float) );
    output = (float *) space( Nw, sizeof(float) );

    makewindows( Hwin, Wanal, Wsyn, Nw, N, I, 0 );

    in = -Nw;
    if ( D )
	on = (in*I)/D;
    else
	on = in;

    while ( !eof ) {

	in += D;
	on += I;

	if ( sflag ) {
            if ( fread( channel, sizeof(float), N+2, stdin ) == 0 )
		eof = 1;
	}
	else {
	    eof = shiftin( input, Nw, D );
	    fold( input, Wanal, Nw, buffer, N, in );
	    rfft( buffer, N2, FORWARD );
	    mvthresh = getthresh(buffer, N2, thresh);
	    drowned( buffer, channel, mvthresh, fmult, N2 );
	}
	if ( I == 0 ) {
	    fwrite( channel, sizeof(float), N+2, stdout );
	    fflush( stdout );
	    continue;
	}

	rfft( buffer, N2, INVERSE );
	overlapadd( buffer, N, Wsyn, output, Nw, on );
	shiftout( output, Nw, I, on );
    }
    fprintf(stderr,"DROWN: RESYNTHESIS COMPLETED\n");
    exit(0);
}
extern int invert;
	
void drowned( S, C, thresh, fmult, N2 )
float *S, *C, thresh, fmult; int N2;
{
 int real, imag, amp, phase;
 float a, b;
 int i;

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	a = ( i == N2 ? S[1] : S[real] );
	b = ( i == 0 || i == N2 ? 0. : S[imag] );
	C[amp] = hypot( a, b );
	if (invert) {
	  if ( (C[amp]) > thresh )
	    C[amp] *= fmult;
	}
	else {
	  if ( (C[amp]) < thresh )
	    C[amp] *= fmult;
	}
	C[phase] = -atan2( b, a );
    }

    for ( i = 0; i <= N2; i++ ) {
	imag = phase = ( real = amp = i<<1 ) + 1;
	S[real] = *(C+amp) * cos( *(C+phase) );
	if ( i != N2 )
	    S[imag] = -*(C+amp) * sin( *(C+phase) );
    }
}

usage(woof)
{
    fprintf(stderr, "%s",
	"crown:  FFT based adaptive noise reduction\n"
	"crown   [flags] < floatsams > floatsams\n"
	"	N:	fft length [1024]\n"
	"	R:	sampling rate[44100]\n"
	"	M:	window size in samples[4096]\n"
	"	D:	decimation factor in samples[512]\n"
	"	I:	interpolation factor in samples[512]\n"
	"	t:	threshold generator [.001]\n"
	"	m:	reduction multiplier[.1]\n"
	"	i:	inverse filter threshold behavior\n"
);
    exit(woof);
}


