#include <stdio.h>
#include <math.h>
#include <usercore.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sun/fbio.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sunwindow/window_hs.h>
#include <carl/carl.h>
#include <signal.h>

#include "defs.h"
/*
 * exported variables
 */
FILE *fp = NULL ;
int flen ;

float srate = 16000. ;
int begin = 0 ;
int niter = 1 ;
int skip = 128 ;
int wsize = 128 ;

int xfm ;
int npoles ;
int npresp = 128 ;
int dxmin ;
int dxmax = 127 ;
int nharm = 5 ;

int drawing_exists ;
int gridon ;
int grid_exists ;
int labelon ;
int label_exists ;
int refnoson ;
int refnos_exists ;
int refno = 1 ;
int invisrefs ;

float ndcx = 1.0 ;
float ndcy = .75 ;
float ndcz = 1.0 ;

float xmin = -1. ;
float xmax = 1. ;
float ymin = -1. ;
float ymax = 1. ;
float zmin = -1. ;
float zmax = 1. ;

float valtop ;
float valbot ;

float *fptr ;
int *iptr ;

int dof ;
/*
 * non-exported variables
 */
char fname[BUFSIZ] ;

int button ;
int segment ;
int pick ;
float value ;
int steps = 1 ;
int movemode ;
float mx, my ;
float ox, oy ;

int picktime = 300000 ;
int button2time = 0 ;

int currview ;
int tempview ;

float cx, cy, cz ;

struct viewpoint {
float sx ;
float sy ;
float sz ;
float ax ;
float ay ;
float az ;
float tx ;
float ty ;
float tz ;
float zoom ;
int fill ;
} ;

struct viewpoint standard ;
struct viewpoint curr ;
struct viewpoint last ;
struct viewpoint norm ;
struct viewpoint view1 ;
struct viewpoint view2 ;
struct viewpoint l2r ;
struct viewpoint dnup ;
struct viewpoint tpdn ;
struct viewpoint pers ;

struct refdraw {
    int exists ;
    int vis[DRAWINGSIZE+1] ;
    int rmask ;
    struct viewpoint refview ;
} refdrawing[ND+1] ;
/*
 * menu definitions
 */
struct dvalue cmds[] = {
{ NVAL | SPIO | UPDATE, "forward" },
{ NVAL | SPIO | UPDATE, "current" },
{ NVAL | SPIO | UPDATE, "backward" },
{ NVAL, "" },
{ NVAL, "grid" },
{ NVAL, "label" },
{ NVAL, "refresh" },
{ NVAL, "rasterdump" },
{ NVAL, "quit" },
{ NVAL, "" },
{ NVAL, "i/o" },
{ NVAL, "signal processing" },
{ NVAL, "standard views" },
{ NVAL, "adjust view" },
{ NVAL, "references" },
{ EVAL }
} ;

struct dvalue io[] = {
{ SVAL, "file", NULL, NULL, fname, 0, 0 },
{ FVAL, "sampling rate", &srate, NULL, NULL, 1., 50000. },
{ IVAL | SPIO, "begin time", NULL, &begin, NULL, 0, 50000 },
{ IVAL, "iterations", NULL, &niter, NULL, 1, 100 },
{ IVAL, "skip size", NULL, &skip, NULL, 0, 512 },
/*
{ NVAL, "" },
{ IVAL, "picktime", NULL, &picktime, NULL, 0, 1000000 },
{ IVAL, "button2time", NULL, &button2time, NULL, 0, 1000000 },
*/
{ EVAL }
} ;

struct dvalue proc[] = {
{ NVAL, "none" },
{ IVAL, "window size", NULL, &wsize, NULL, 0, 512 },
{ IVAL, "xmin", NULL, &dxmin, NULL, 0, 512 },
{ IVAL, "xmax", NULL, &dxmax, NULL, 0, 512 },
{ NVAL, "Hamming window" },
{ IVAL, "poles", NULL, &npoles, NULL, 0, 100 },
{ NVAL, "pole-plot" },
{ IVAL, "pole response", NULL, &npresp, NULL, 0, 512 },
{ NVAL, "filter response" },
{ NVAL, "power spectrum" },
{ NVAL, "dB spectrum" },
{ NVAL, "0 dB spectrum" },
{ NVAL, "amplitude spectrum" },
{ NVAL, "phase spectrum" },
{ NVAL, "r.m.s. amplitude" },
{ NVAL, "peak amplitude" },
{ IVAL, "hp spectrum", NULL, &nharm, NULL, 1, 100 },
{ EVAL }
} ;

struct dvalue stdview[] = {
{ NVAL | UPDATE, "down-up" },
{ NVAL | UPDATE, "top-down" },
{ NVAL | UPDATE, "left-right" },
{ NVAL | UPDATE, "perspective" },
{ NVAL | UPDATE, "front" },
{ IVAL, "offset", NULL, &dof, NULL, 0, 3 },
{ EVAL }
} ;

struct dvalue view[] = {
{ FVAL | UPDATE, "zoom", &curr.zoom, NULL, NULL, 0., 5. },
{ NVAL | UPDATE, "move" },
{ FVAL | UPDATE, "scale x", &curr.sx, NULL, NULL, 0., 5. },
{ FVAL | UPDATE, "scale y", &curr.sy, NULL, NULL, 0., 5. },
{ FVAL | UPDATE, "scale z", &curr.sz, NULL, NULL, 0., 5. },
{ FVAL | UPDATE, "rotate x", &curr.ax, NULL, NULL, -3.14, 3.14 },
{ FVAL | UPDATE, "rotate y", &curr.ay, NULL, NULL, -3.14, 3.14 },
{ FVAL | UPDATE, "rotate z", &curr.az, NULL, NULL, -3.14, 3.14 },
{ FVAL | UPDATE, "translate x", &curr.tx, NULL, NULL, -1., 1. },
{ FVAL | UPDATE, "translate y", &curr.ty, NULL, NULL, -1., 1. },
{ FVAL | UPDATE, "translate z", &curr.tz, NULL, NULL, -1., 1. },
/* someday, when large polygons work
{ IVAL | UPDATE, "fill", NULL, &curr.fill, NULL, 0, 255 },
*/
{ IVAL, "steps", NULL, &steps, NULL, 1, 50 },
{ NVAL | UPDATE, "view 1" },
{ NVAL | UPDATE, "view 2" },
{ NVAL, "record view 1" },
{ NVAL, "record view 2" },
{ EVAL }
} ;

struct dvalue refs[] = {
{ IVAL, "set #", NULL, &refno, NULL, 1, ND },
{ NVAL, "show #s" },
{ NVAL, "save" },
{ NVAL, "restore" },
{ NVAL, "invisible" },
{ NVAL, "delete" },
{ NVAL, "delete all" },
{ NVAL, "text" },
{ EVAL }
} ;

float wcm[4][4] = {
{ 1., 0., 0., 0. },
{ 0., 1., 0., 0. },
{ 0., 0., 1., 0. },
{ 0., 0., 0., 1. },
} ;

float  Zoom,  Ax,  Ay,  Az,  Tx,  Ty,  Tz,  Sx,  Sy,  Sz ;
struct dvalue *val, *lval, *valptr ;
struct dvalue *beginptr, *txptr, *typtr, *findvalname() ;
struct dvalue *iterptr, *dxminptr, *dxmaxptr ;
int i, temp, len ;
char msg[BUFSIZ], resp[BUFSIZ] ;
float p ;

main( argc, argv ) int argc ; char *argv[] ;  {
    if ( argc == 2 )
	ndcy = atof( argv[1] ) ;
    setup() ;
    while ( 1 ) {
	await_pick( picktime, 1, &segment, &pick ) ;
	if ( movemode )
	    await_any_button_get_locator_2( button2time, 1, &button, &mx, &my ) ;
	else
	    await_any_button_get_valuator( button2time, 1, &button, &value ) ;
	if ( segment )
	    if ( commands() )
		break ;
	if ( button == 2 )
	    update() ;
    }
    setdown_core() ;
}
setup() {
    setup_core() ;
    set_viewport_3( 0., ndcx, 0., ndcy, 0., ndcz ) ;
    wcm[2][2] = .5 ;
    set_world_coordinate_matrix_3( wcm ) ;
    set_window( xmin, xmax, ymin, ymax ) ;
    set_charsize( (xmax-xmin)/90., (ymax-ymin)/90. ) ;
    valbot = fy(.95) ; valtop = fy(.99) ;
    standard.sx = standard.sy = standard.sz = standard.zoom = 1. ;
    standard.tx = .15 ;
    l2r = dnup = tpdn = pers = norm = curr = last = view1 = view2 =
	standard ;
    pers.ax = 2.*atan(1.)/3. ;
    pers.ay = -2.*atan(1.)/3. ;
    pers.az = -.281 ;
    pers.sy = .75 ;
    create_retained_segment( WORKING ) ;
    set_segment_visibility( WORKING, FALSE ) ;
    move_abs_2( fx(.25), fy(.02) ) ;
    text( "WORKING..." ) ;
    close_retained_segment() ;
    setup_menu( CMD, cmds, fx(.01), fy(.4), .055 ) ;
    setup_menu( VIEW, view, fx(.01), fy(.85), .055 ) ;
    setup_menu( STDVIEW, stdview, fx(.01), fy(.85), .055 ) ;
    setup_menu( IO, io, fx(.01), fy(.85), .055 ) ;
    setup_menu( PROC, proc, fx(.01), fy(.86), .053 ) ;
    setup_menu( REF, refs, fx(.01), fy(.85), .055 ) ;
    currview |= DOWN_UP | CMDVIS ;
    mv( cmds, TRUE ) ;
    lval = &view[0] ;
    beginptr = findvalname( io, "begin time" ) ;
    txptr = findvalname( view, "translate x" ) ;
    typtr = findvalname( view, "translate y" ) ;
    iterptr = findvalname( io, "iterations" ) ;
    dxminptr = findvalname( proc, "xmin" ) ;
    dxmaxptr = findvalname( proc, "xmax" ) ;
    map_world_to_ndc_2( cx, cy, &ox, &oy ) ;
}
commands() {
 struct stat statbuf ;
    if ( segment - CMD > 0 && segment - CMD < MDIFF )
	val = &cmds[segment - CMD - 1] ;
    else if ( segment - VIEW > 0 && segment - VIEW < MDIFF )
	val = &view[segment - VIEW - 1] ;
    else if ( segment - STDVIEW > 0 && segment - STDVIEW < MDIFF )
	val = &stdview[segment - STDVIEW - 1] ;
    else if ( segment - IO > 0 && segment - IO < MDIFF )
	val = &io[segment - IO - 1] ;
    else if ( segment - PROC > 0 && segment - PROC < MDIFF )
	val = &proc[segment - PROC - 1] ;
    else if ( segment - REF > 0 && segment - REF < MDIFF )
	val = &refs[segment - REF - 1] ;

    if ( strcmp( val->name, lval->name ) ) {
	set_segment_visibility( lval->markseg, FALSE ) ;
	set_segment_visibility( val->markseg, TRUE ) ;
	if ( !( val->kind & lval->kind & SPIO ) )
	    select_for_update( val ) ;
    } else if ( val->kind & ( FVAL | IVAL ) ) {
	if ( val->kind & FVAL ) {
	  sprintf( msg, "type %s value (%.5g):", val->name, *val->fptr ) ;
	    if ( keyin( msg, resp ) )
		value = expr( resp ) ;
	    else
		value = *val->fptr ;
	} else {
	  sprintf( msg, "type %s value (%d):", val->name, *val->iptr ) ;
	    if ( keyin( msg, resp ) )
		value = expr( resp ) ;
	    else
		value = *val->iptr ;
	}
	button = 2 ;
    }
    if ( !strcmp( val->name, "move" ) )
	movemode = 1 ;
    else
	movemode = 0 ;

    if ( !strcmp( val->name, "i/o" ) ) {
	currview &= ~MENUMASK ;
	currview |= IOVIS ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "standard views" ) ) {
	currview &= ~MENUMASK ;
	currview |= STDVIEWVIS ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "adjust view" ) ) {
	currview &= ~MENUMASK ;
	currview |= VIEWVIS ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "signal processing" ) ) {
	currview &= ~MENUMASK ;
	currview |= PROCVIS ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "references" ) ) {
	currview &= ~MENUMASK ;
	currview |= REFVIS ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "refresh" ) ) {
	new_frame() ;
    } else if ( !strcmp( val->name, "rasterdump" ) ) {
	resp[0] = '\0' ;
	if ( currview & IOVIS )
	    strcpy( resp, "i/o" ) ;
	else if ( currview & PROCVIS )
	    strcpy( resp, "signal processing" ) ;
	else if ( currview & STDVIEWVIS )
	    strcpy( resp, "standard views" ) ;
	else if ( currview & STDVIEWVIS )
	    strcpy( resp, "adjust view" ) ;
	else if ( currview & REFVIS )
	    strcpy( resp, "references" ) ;
	sprintf( msg,
	    "Is the %s menu to appear in the plot (y/n)?", resp ) ;
	keyin( msg, resp ) ;
	tempview = currview ;
	currview &= ~CMDVIS ;
	if ( resp[0] != 'y' )
	    currview &= ~MENUMASK ;
	setmenuvis() ;
	new_frame() ;
	make_dump() ;
	currview = tempview ;
	setmenuvis() ;
	stickies() ;
    } else if ( !strcmp( val->name, "quit" ) ) {
	return( 1 ) ;
    } else if ( !strcmp( val->name, "grid" ) ) {
	gridon = ( gridon + 1 )%4 ;
	    if ( gridon == 0 ) {
		currview &= ~( GRID1VIS | GRID2VIS | GRID3VIS ) ;
		if ( grid_exists ) {
		    set_drag( TRUE ) ;
		    set_segment_visibility( GRID1, FALSE ) ;
		    set_segment_visibility( GRID2, FALSE ) ;
		    set_segment_visibility( GRID3, FALSE ) ;
		    set_drag( FALSE ) ;
		    set_segment_visibility( GRIDLABEL, FALSE ) ;
		}
	    } else if ( gridon == 1 ) {
		currview |= GRID1VIS ;
		if ( grid_exists ) {
		    set_drag( TRUE ) ;
		    set_segment_visibility( GRID1, TRUE ) ;
		    set_drag( FALSE ) ;
		    set_segment_visibility( GRIDLABEL, TRUE ) ;
		}
	    } else if ( gridon == 2 ) {
		currview |= GRID2VIS ;
		if ( grid_exists ) {
		    set_drag( TRUE ) ;
		    set_segment_visibility( GRID1, TRUE ) ;
		    set_segment_visibility( GRID2, TRUE ) ;
		    set_drag( FALSE ) ;
		}
	    } else if ( gridon == 3 ) {
		currview |= GRID3VIS ;
		if ( grid_exists ) {
		    set_drag( TRUE ) ;
		    set_segment_visibility( GRID1, TRUE ) ;
		    set_segment_visibility( GRID2, TRUE ) ;
		    set_segment_visibility( GRID3, TRUE ) ;
		    set_drag( FALSE ) ;
		}
	    }
    } else if ( !strcmp( val->name, "label" ) ) {
	labelon ^= 1 ;
	if ( label_exists ) {
	    if ( labelon == 0 ) {
		set_segment_visibility( LABEL, FALSE ) ;
		currview &= ~LABELVIS ;
	    } else {
		set_segment_visibility( LABEL, TRUE ) ;
		currview |= LABELVIS ;
	    }
	}
    } else if ( !strcmp( val->name, "record view 1" ) ) {
	view1 = curr ;
    } else if ( !strcmp( val->name, "record view 2" ) ) {
	view2 = curr ;
    } else if ( !strcmp( val->name, "front") ) {
	curr = norm ;
	currview &= ~STDVIEWMASK ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "rotate y" ) ) {
	currview &= ~STDVIEWMASK ;
    } else if ( !strcmp( val->name, "rotate x" ) ) {
	currview &= ~STDVIEWMASK ;
    } else if ( !strcmp( val->name, "view 1" ) ) {
	curr = view1 ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "view 2" ) ) {
	curr = view2 ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "left-right" ) ) {
	l2r.ay = niter > 1 ? -atan( niter - 1. ) : 0. ;
	curr = l2r ;
	currview &= ~STDVIEWMASK ;
	currview |= LEFT_RIGHT ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "down-up" ) ) {
	dnup.ax = niter > 1 ? atan( ndcy*( niter - 1. ) ) : 0. ;
	curr = dnup ;
	currview &= ~STDVIEWMASK ;
	currview |= DOWN_UP ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "top-down" ) ) {
	tpdn.ax = niter > 1 ? -atan( ndcy*( niter - 1. ) ) : 0. ;
	curr = tpdn ;
	currview &= ~STDVIEWMASK ;
	currview |= TOP_DOWN ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "perspective" ) ) {
	curr = pers ;
	currview &= ~STDVIEWMASK ;
	currview |= PERSP ;
	update_view() ;
	button = 2 ;
    } else if ( !strcmp( val->name, "file" ) ) {
	if ( fp != NULL )
	    fclose( fp ) ;
	sprintf( msg, "type filename (%s):", fname ) ;
	if ( keyin( msg, resp ) )
	    strcpy( fname, resp ) ;
	while ( fname[0] )
	    if ( ( fp = fopen( fname, "r" ) ) == NULL ) {
		sprintf( msg, "cannot open %s--retype filename:", fname ) ;
		keyin( msg, fname ) ;
	    } else
		break ;
	update_val( val ) ;
	flen = 0 ;
	if ( fp != NULL ) {
	    stat( fname, &statbuf ) ;
	    flen = beginptr->vmax = statbuf.st_size/4. ;
	    update_val( beginptr ) ;
	    select_for_update( beginptr ) ;
	}
    } else if ( !strcmp( val->name, "text" ) ) {
	sprintf( msg, "type text:" ) ;
	keyin( msg, resp ) ;
	if ( grid_exists ) {
	    delete_retained_segment( GRID1 ) ;
	    delete_retained_segment( GRID2 ) ;
	    delete_retained_segment( GRID3 ) ;
	    delete_retained_segment( GRIDLABEL ) ;
	}
	if ( label_exists )
	    delete_retained_segment( LABEL ) ;
	if ( drawing_exists )
	    delete_retained_segment( DRAWING ) ;
	set_image_transformation_type( XFORM3 ) ;
	create_retained_segment( GRID1 ) ; close_retained_segment() ;
	create_retained_segment( GRID2 ) ; close_retained_segment() ;
	create_retained_segment( GRID3 ) ; close_retained_segment() ;
	create_retained_segment( GRIDLABEL ) ; close_retained_segment() ;
	create_retained_segment( LABEL ) ; close_retained_segment() ;
	create_retained_segment( DRAWING ) ;
	move_abs_3( 0., 0., 0. ) ;
	text( resp ) ;
	close_retained_segment() ;
	set_image_transformation_type( NONE ) ;
	drawing_exists = grid_exists = label_exists = 1 ;
    } else if ( !strcmp( val->name, "forward" ) ) {
	begin += skip ;
	update_val( beginptr ) ;
	select_for_update( beginptr ) ;
	stickies() ;
	set_segment_visibility( WORKING, TRUE ) ;
	make_drawing( curr.fill ) ;
	set_segment_visibility( WORKING, FALSE ) ;
	button = 2 ;
    } else if ( !strcmp( val->name, "backward" ) ) {
	begin -= skip ;
	if ( begin < 0 )
	    begin = 0 ;
	update_val( beginptr ) ;
	select_for_update( beginptr ) ;
	stickies() ;
	set_segment_visibility( WORKING, TRUE ) ;
	make_drawing( curr.fill ) ;
	set_segment_visibility( WORKING, FALSE ) ;
	button = 2 ;
    } else if ( !strcmp( val->name, "current" ) ) {
	update_val( beginptr ) ;
	select_for_update( beginptr ) ;
	stickies() ;
	set_segment_visibility( WORKING, TRUE ) ;
	make_drawing( curr.fill ) ;
	set_segment_visibility( WORKING, FALSE ) ;
	button = 2 ;
    } else if ( !strcmp( val->name, "none" ) ) {
	xfm = 0 ;
	dxmax = wsize - 1 ;
	dxmin = 0 ;
	update_val( dxminptr ) ;
	update_val( dxmaxptr ) ;
    } else if ( !strcmp( val->name, "power spectrum" ) ) {
	xfm = POWSPEC | ( xfm & ( HAMMING | FILT ) ) ;
	if ( dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "dB spectrum" ) ) {
	xfm ^= DBSPEC ;
	xfm &= DBSPEC | HAMMING | FILT | PRESP ;
	if ( !( xfm & PRESP ) && dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "0 dB spectrum" ) ) {
	xfm ^= ZDBSPEC ;
	xfm &= ZDBSPEC | HAMMING | FILT | PRESP ;
	if ( !( xfm & PRESP ) && dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "amplitude spectrum" ) ) {
	xfm = AMPSPEC | ( xfm & ( HAMMING | FILT | PRESP ) ) ;
	if ( dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "phase spectrum" ) ) {
	xfm = PHASPEC | ( xfm & ( HAMMING | FILT ) ) ;
	if ( dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "r.m.s. amplitude" ) ) {
	xfm = RMS | ( xfm & HAMMING ) ;
	if ( dxmax > wsize - 1 || dxmax < dxmin ) {
	    dxmax = wsize - 1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "peak amplitude" ) ) {
	xfm = PEAK | ( xfm & HAMMING ) ;
	if ( dxmax > wsize - 1 || dxmax < dxmin ) {
	    dxmax = wsize - 1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "hp spectrum" ) ) {
	xfm = HPSPEC | ( xfm & ( HAMMING | FILT ) ) ;
	if ( dxmax > wsize>>1 || dxmax < dxmin ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "pole-plot" ) ) {
	xfm ^= POLES ;
	xfm &= HAMMING | POLES ;
    } else if ( !strcmp( val->name, "pole response" ) ) {
	xfm ^= PRESP ;
	xfm &= HAMMING | PRESP | AMPSPEC | DBSPEC | ZDBSPEC ;
	if ( !( xfm & ( DBSPEC | ZDBSPEC ) ) )
	    xfm |= AMPSPEC ;
	if ( xfm & PRESP ) {
	    dxmax = npresp ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	} else if ( xfm & SPEC ) {
	    dxmax = wsize>>1 ;
	    dxmin = 0 ;
	    update_val( dxminptr ) ;
	    update_val( dxmaxptr ) ;
	}
    } else if ( !strcmp( val->name, "Hamming window" ) ) {
	xfm ^= HAMMING ;
    } else if ( !strcmp( val->name, "filter response" ) ) {
	    xfm ^= FILT ;
    } else if ( !strcmp( val->name, "save" ) ) {
	temp = refno ;
	for ( refno = 1 ; refno <= ND ; refno++ )
	    if ( !refdrawing[refno].exists )
		break ;
	if ( refno > ND ) {
	    errmess( "Out of reference drawing space" ) ;
	    refno = temp ;
	} else {
	    for ( i = 1 ; i <= DRAWINGSIZE ; i++ ) {
		rename_retained_segment( CURRDRAW+i, CURRREF+i ) ;
		inquire_segment_visibility( CURRREF+i,
		    &refdrawing[refno].vis[i] ) ;
	    }
	    refdrawing[refno].exists = refno ;
	    refdrawing[refno].refview = curr ;
	    refdrawing[refno].rmask = currview ;
	    drawing_exists = grid_exists = label_exists = 0 ;
	    makerefnos() ;
	    update_val( findvalname( refs, "set #" ) ) ;
	    if ( currview & LEFT_RIGHT ) {
		curr = l2r ;
	    } else if ( currview & DOWN_UP ) {
		curr = dnup ;
	    } else if ( currview & TOP_DOWN ) {
		curr = tpdn ;
	    } else if ( currview & PERSP ) {
		curr = pers ;
	    } else {
		curr = norm ;
	    }
	    update_view() ;
	}
    } else if ( !strcmp( val->name, "show #s" ) ) {
	refnoson ^= 1 ;
	makerefnos() ;
    } else if ( !strcmp( val->name, "restore" ) ) {
	if ( drawing_exists )
	    for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
		delete_retained_segment( CURRDRAW+i ) ;
	for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
	    rename_retained_segment( CURRREF+i, CURRDRAW+i ) ;
	drawing_exists = grid_exists = label_exists = 1 ;
	refdrawing[refno].exists = 0 ;
	curr = refdrawing[refno].refview ;
	currview = refdrawing[refno].rmask ;
	update_view() ;
	makerefnos() ;
    } else if ( !strcmp( val->name, "invisible" ) ) {
	invisrefs ^= 1 ;
	temp = refno ;
	if ( invisrefs ) {
	     for ( refno = 1 ; refno <= ND ; refno++ )
		if ( refdrawing[refno].exists )
		    for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
			set_segment_visibility( CURRREF+i, FALSE ) ;
	} else {
	    for ( refno = 1 ; refno <= ND ; refno++ )
		if ( refdrawing[refno].exists )
		    for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
			set_segment_visibility( CURRREF+i,
			    refdrawing[refno].vis[i] ) ;
	}
	refno = temp ;
    } else if ( !strcmp( val->name, "delete" ) ) {
	if ( refdrawing[refno].exists )
	    for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
		delete_retained_segment( CURRREF+i ) ;
	refdrawing[refno].exists = 0 ;
	curr = norm ;
	currview &= ~STDVIEWMASK ;
	update_view() ;
	makerefnos() ;
    } else if ( !strcmp( val->name, "delete all" ) ) {
	for ( refno = 1 ; refno <= ND ; refno++ ) {
	    if ( refdrawing[refno].exists ) {
		for ( i = 1 ; i <= DRAWINGSIZE ; i++ )
		    delete_retained_segment( CURRREF+i ) ;
		refdrawing[refno].exists = 0 ;
	    }
	}
	curr = norm ;
	currview &= ~STDVIEWMASK ;
	update_view() ;
	invisrefs = 0 ;
	makerefnos() ;
    }
    lval = val ;
    stickies() ;
    return( 0 ) ;
}
update() {
    if ( movemode ) {
	curr.tx = mx - ox ;
	curr.ty = my - oy ;
	update_val( txptr ) ;
	update_val( typtr ) ;
    } else {
	if ( val->kind & FVAL ) {
	    *fptr = value ;
	    update_val( val ) ;
	} else if ( val->kind & IVAL ) {
	    if ( iptr == &wsize ) {
		*iptr = value ;
		dxmin = 0 ;
		if ( xfm & ( POWSPEC | AMPSPEC | DBSPEC | HPSPEC ) ) {
		    for ( i = 2 ; ; i <<= 1 )
			if ( i >= wsize )
			    break ;
		    dxmax = i>>1 ;
		} else
		    dxmax = wsize - 1 ;
		update_val( dxminptr ) ; update_val( dxmaxptr ) ;
		update_val( val ) ;
	    } else if ( iptr == &npresp ) {
		dxmax = *iptr = value ;
		update_val( val ) ;
		update_val( dxmaxptr ) ;
		stickies() ;
	    } else if ( iptr == &npoles ) {
		*iptr = value ;
		update_val( val ) ;
		stickies() ;
	    } else {
		*iptr = value ;
		update_val( val ) ;
	    }
	}
	if ( !strcmp( "iterations", val->name ) ) {
	    if ( currview & LEFT_RIGHT )
		curr.ay = l2r.ay = niter > 1 ? -atan( niter - 1. ) : 0. ;
	    else if ( currview & DOWN_UP )
		curr.ax = dnup.ax = niter > 1 ?
		    atan( ndcy*(niter - 1. ) ) : 0. ;
	    else if ( currview & TOP_DOWN )
		curr.ax = dnup.ax = niter > 1 ?
		    -atan( ndcy*(niter - 1. ) ) : 0. ;
	}
    }
    if ( drawing_exists && ( lval->kind & UPDATE ) ) {
	for ( i = 1 ; i <= steps ; i++ ) {
	    p = (float) i/steps ;
	    Zoom = interp(p,last.zoom,curr.zoom) ;
	    Sx = interp(p,last.sx,curr.sx) ;
	    Sy = interp(p,last.sy,curr.sy) ;
	    Sz = interp(p,last.sz,curr.sz) ;
	    Ax = interp(p,last.ax,curr.ax) ;
	    Ay = interp(p,last.ay,curr.ay) ;
	    Az = interp(p,last.az,curr.az) ;
	    Tx = interp(p,last.tx,curr.tx) ;
	    Ty = interp(p,last.ty,curr.ty) ;
	    Tz = interp(p,last.tz,curr.tz) ;
	    if ( currview & GRID1VIS ) {
		set_drag( TRUE ) ;
		set_segment_visibility( GRID3, FALSE ) ;
		set_segment_visibility( GRID2, FALSE ) ;
		set_segment_visibility( GRID1, FALSE ) ;
		set_drag( FALSE ) ;
		set_segment_visibility( GRIDLABEL, FALSE ) ;
	    }
	    if ( currview & LABELVIS )
		set_segment_visibility( LABEL, FALSE ) ;
	    xfm3( DRAWING, cx, cy, cz,
		Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
	    if ( grid_exists ) {
		xfm3( GRID1, cx, cy, cz,
		   Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
		xfm3( GRID2, cx, cy, cz,
		   Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
		xfm3( GRID3, cx, cy, cz,
		   Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
		xfm3( GRIDLABEL, cx, cy, cz,
		   Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
	    }
	    if ( label_exists )
		xfm3( LABEL, cx, cy, cz,
		   Zoom*Sx, Zoom*Sy, Zoom*Sz, Ax, Ay, Az, Tx, Ty, Tz ) ;
	    set_segment_visibility( DRAWING, TRUE ) ;
	    if ( currview & GRID1VIS ) {
		set_drag( TRUE ) ;
		set_segment_visibility( GRID1, TRUE ) ;
		set_drag( FALSE ) ;
		set_segment_visibility( GRIDLABEL, TRUE ) ;
	    }
	    if ( currview & GRID2VIS ) {
		set_drag( TRUE ) ;
		set_segment_visibility( GRID2, TRUE ) ;
		set_drag( FALSE ) ;
	    }
	    if ( currview & GRID3VIS ) {
		set_drag( TRUE ) ;
		set_segment_visibility( GRID3, TRUE ) ;
		set_drag( FALSE ) ;
	    }
	    if ( currview & LABELVIS )
		set_segment_visibility( LABEL, TRUE ) ;
	}
	last = curr ;
    }
}
stickies() {
    if ( currview & CMDVIS ) {
	modvis( cmds, "i/o", currview & IOVIS ) ;
	modvis( cmds, "signal processing", currview & PROCVIS ) ;
	modvis( cmds, "standard views", currview & STDVIEWVIS ) ;
	modvis( cmds, "adjust view", currview & VIEWVIS ) ;
	modvis( cmds, "references", currview & REFVIS ) ;
	modvis( cmds, "grid", gridon ) ;
	modvis( cmds, "label", labelon ) ;
    }
    if ( currview & PROCVIS ) {
	modvis( proc, "r.m.s. amplitude", xfm & RMS ) ;
	modvis( proc, "peak amplitude", xfm & PEAK ) ;
	modvis( proc, "power spectrum", xfm & POWSPEC ) ;
	modvis( proc, "dB spectrum", xfm & DBSPEC ) ;
	modvis( proc, "0 dB spectrum", xfm & ZDBSPEC ) ;
	modvis( proc, "amplitude spectrum", xfm & AMPSPEC ) ;
	modvis( proc, "phase spectrum", xfm & PHASPEC ) ;
	modvis( proc, "hp spectrum", xfm & HPSPEC ) ;
	modvis( proc, "poles", npoles ) ;
	modvis( proc, "pole-plot", xfm & POLES ) ;
	modvis( proc, "pole response", xfm & PRESP ) ;
	modvis( proc, "Hamming window", xfm & HAMMING ) ;
	modvis( proc, "filter response", xfm & FILT ) ;
    } else if ( currview & STDVIEWVIS ) {
	modvis( stdview, "left-right", currview & LEFT_RIGHT ) ;
	modvis( stdview, "down-up", currview & DOWN_UP ) ;
	modvis( stdview, "top-down", currview & TOP_DOWN ) ;
	modvis( stdview, "perspective", currview & PERSP ) ;
	modvis( stdview, "front", !(currview & STDVIEWMASK) ) ;
    } else if ( currview & REFVIS ) {
	modvis( refs, "invisible", invisrefs ) ;
    }
}
makerefnos() {
 int i, fi ;
 float x, y, dx, dy, junk, px[4], py[4], pz[4] ;
 char txt[BUFSIZ] ;
    if ( refnos_exists ) {
	delete_retained_segment( REFNOS ) ;
	refnos_exists = 0 ;
    }
    if ( refnoson ) {
	inquire_fill_index( &fi ) ;
	set_fill_index( 0 ) ;
	create_retained_segment( REFNOS ) ;
	for ( i = 0 ; i <= ND ; i++ )
	    if ( refdrawing[i].exists ) {
		map_ndc_to_world_2(
		    refdrawing[i].refview.tx + ox,
			refdrawing[i].refview.ty + oy,
			    &x, &y) ;
		sprintf( txt, "%d", i ) ;
		inquire_text_extent_2( txt, &dx, &junk ) ;
		dx += .02 ;
		inquire_charsize( &junk, &dy ) ;
		px[0] = dx ; px[2] = -dx ; px[1] = px[3] = 0. ;
		py[1] = 2.*dy ; py[3] = -2.*dy ; py[0] = py[2] = 0. ;
		pz[0] = pz[1] = pz[2] = pz[3] = 0. ;
		move_abs_2( x, y ) ;
		move_rel_2( -.01, -dy ) ;
		polygon_rel_3( px, py, pz, 4 ) ;
		move_abs_2( x, y ) ;
		move_rel_2( -.01, -dy ) ;
		polyline_rel_3( px, py, pz, 4 ) ;
		move_abs_2( x, y ) ;
		text( txt ) ;
	    }
	close_retained_segment() ;
	refnos_exists = 1 ;
	set_fill_index( fi ) ;
    }
}
modvis( val, s, cond ) struct dvalue *val ; char *s ; int cond ; {
 struct dvalue *v, *findvalname() ;
    v = findvalname( val, s ) ;
    if ( cond )
	set_segment_visibility( v->markseg, TRUE ) ;
    else
	set_segment_visibility( v->markseg, FALSE ) ;
}
update_view() {
 int i ;
    for ( i = 0 ; view[i].kind ; i++ )
	if ( !(view[i].kind & NVAL) )
	    update_val( &view[i] ) ;
}
setmenuvis() {
    if ( !(currview & CMDVIS) )
	mv( cmds, FALSE ) ;
    if ( !(currview & IOVIS) )
	mv( io, FALSE ) ;
    if ( !(currview & PROCVIS) )
	mv( proc, FALSE ) ;
    if ( !(currview & STDVIEWVIS) )
	mv( stdview, FALSE ) ;
    if ( !(currview & VIEWVIS) )
	mv( view, FALSE ) ;
    if ( !(currview & REFVIS) )
	mv( refs, FALSE ) ;

    if ( currview & CMDVIS )
	mv( cmds, TRUE ) ;
    if ( currview & IOVIS )
	mv( io, TRUE ) ;
    if ( currview & PROCVIS )
	mv( proc, TRUE ) ;
    if ( currview & STDVIEWVIS )
	mv( stdview, TRUE ) ;
    if ( currview & VIEWVIS )
	mv( view, TRUE ) ;
    if ( currview & REFVIS )
	mv( refs, TRUE ) ;
}
mv( v, tv ) struct dvalue *v ; int tv ; {
    while ( v->kind ) {
	set_segment_visibility( v->nameseg, tv ) ;
	set_segment_visibility( v->markseg, FALSE ) ;
	if ( !( v->kind & NVAL ) )
	    set_segment_visibility( v->valseg, tv ) ;
	v++ ;
    }
}
