/*
 * viewpoint definitions
 */
#define fx(p)(p*(xmax-xmin)+xmin)
#define fy(p)(p*(ymax-ymin)+ymin)
#define fyr(p)(p*(ymin-ymax)+ymax)
#define interp(p,a,b)((p)*((b)-(a))+(a))
#define map(p,a,b,c,d)(((p)-(a))*((d)-(c))/((b)-(a))+(c))

#define BORDER 1
#define VAL 2
#define UPVAL 3
#define SKETCH 4
#define WORKING 5
#define REFNOS 6

#define DSTART 3000
#define ROFF 100
#define ND 50

#define DRAWING (DSTART+1)
#define GRID1 (DSTART+2)
#define GRID2 (DSTART+3)
#define GRID3 (DSTART+4)
#define GRIDLABEL (DSTART+5)
#define LABEL (DSTART+6)
#define DRAWINGSIZE 6

#define REFDRAWING (CURRREF+1)
#define REFGRID1 (CURRREF+2)
#define REFGRID2 (CURRREF+3)
#define REFGRID3 (CURRREF+4)
#define REFGRIDLABEL (CURRREF+5)
#define REFLABEL (CURRREF+6)

#define CURRDRAW DSTART
#define CURRREF (DSTART+ROFF*refno)

#define EVAL   00000
#define FVAL   00001
#define IVAL   00002
#define SVAL   00004
#define NVAL   00010
#define SPIO   00020
#define UPDATE 00140

#define POWSPEC 000001
#define AMPSPEC 000002
#define DBSPEC  000004
#define ZDBSPEC 000010
#define PHASPEC 000020
#define HPSPEC  000040
#define HAMMING 000100
#define RMS     000200
#define PEAK    000400
#define FILT    001000
#define POLES   002000
#define PRESP   004000

#define SPEC ( POWSPEC | AMPSPEC | DBSPEC | ZDBSPEC | PHASPEC | HPSPEC )
#define FFT SPEC

#define MDIFF 100
#define CMD 100
#define VIEW (CMD+MDIFF)
#define STDVIEW (VIEW+MDIFF)
#define IO (STDVIEW+MDIFF)
#define PROC (IO+MDIFF)
#define REF (PROC+MDIFF)

#define VOF 1000
#define MOF 2000

#define CMDVIS     000001
#define IOVIS      000002
#define PROCVIS    000004
#define STDVIEWVIS 000010
#define VIEWVIS    000020
#define REFVIS     000040
#define GRID1VIS   000100
#define GRID2VIS   000200
#define GRID3VIS   000400
#define LABELVIS   001000
#define LEFT_RIGHT 002000
#define DOWN_UP    004000
#define TOP_DOWN   010000
#define PERSP      020000

#define MENUMASK (IOVIS | PROCVIS | STDVIEWVIS | VIEWVIS | REFVIS )

#define STDVIEWMASK ( LEFT_RIGHT | DOWN_UP | TOP_DOWN | PERSP )

struct dvalue {
 int  kind ;
 char *name ;
 float *fptr ;
 int *iptr ;
 char *sptr ;
 float vmin ;
 float vmax ;
 int nameseg ;
 int markseg ;
 int valseg ;
 float valx ;
 float valy ;
 int idval ;
 float fdval ;
} ;

