.\"
.\" print this with
.\"	eqn Install.ms | ditroff -ms
.\"
.EQ
delim $$
.EN
.RT
.TL
Installing the DSC 200 4BSD Driver
.LP
This paper attempts to explain the intricacies of installing
the dsc driver with 4bsd (e.g. 4.1 and/or 4.2).
.SH
How the Driver Works (Simple Explanation)
.LP
First an overview of how the driver works.
The user process opens the dsc device and then
issues several ioctl's to set up the transfer.
The ioctl's tell the driver which disk to use,
where the blocks are on the disk, the sample rate,
which converters to use, which filters to use, etc.
Then the user process issues a read or write (read
for a/d [i.e. record], write for d/a [i.e. play]).
The driver uses the buffer given as the 2nd argument
to read or write for the buffer to do the i/o
into and out of. The dsc does buffer chaining
with 2 buffers so the driver splits the user's buffer
in half. For a d/a conversion the driver reads in the
data from the disk and when the disk i/o is done starts
the conversion. Thereafter, while the converters are
converting buffer $N$ the disk is filling buffer
$(N + 1) / mod 2$ and vice versa.
.SH
How Buffer Chaining Works
.LP
Buffer chaining is a method where a dma device can
do continuous i/o. In a non-buffer chained device
the device interrupts after each i/o and then the driver
reloads the device registers and starts the i/o again.
With buffer chaining there are two sets of registers
that specify i/o operations. We can call these two
sets the ``top set'' and the ``bottom set''. The hardware
only works out of the bottom set and the driver
only loads the top set. As soon as an i/o operation
specified by the bottom set of registers is done the
top set is copied into the bottom set and the device
continues running. Also at that time an interrupt is issued
and the driver reloads the top set. Thus there are no
gaps in the output due to setting up the registers.
.SH
Site-Specific Code in the Driver
.LP
In the file \f(CWvaxuba/ds.c\fP there are only two site-specific
things; the \f(TYbs\fP structure and the base address of the
converters on the DSC 200 internal bus.
.LP
The \f(TYbs\fP structure describes the bulk storage devices.
It contains the device number (major + minor) of the
block special device and the character special device (e.g. a
partition of a disk), any special flags for the device, and
the routine to use to initiate i/o on the device.
.LP
Following the \f(TYbs\fP structure are some \f(TY# define\fP's
that define the base address of the d/a and a/d converters
on the DSC 200 internal bus. These probably won't need to
be changed but if you don't get any output when you play a
file and everything else seems to be ok then you might verify
these.
.LP
The file \f(CWvaxuba/dsc.h\fP contains a number of site-specific
\f(TY# define\fP's. For each site they are surrounded by
\f(TY# ifdef SITENAME\fP ... \f(TY# endif SITENAME\fP. You
should copy one and then change them to reflect reality at
your installation. Each of these is commented as to their
meaning so it won't be repeated here.
.SH
Installing the Driver
.LP
It is assumed the reader has read the relevant sections in the
document from Berkeley about installing 4bsd and how to install
local device drivers.
There are several files of the system sources that will need
to be changed:
.DS
.ft CW
conf/SITENAME
conf/files.vax
vax/conf.c
.ft P
.DE
.LP
The file \f(CWconf/SITENAME\fP will need to have the following
line added to it:
.DS
.ft TY
device	ds0	at uba? csr 0165400	vector dsintr
.ft P
.DE
This sets things up for the autoconfiguration software so
that the system can configure the device in. Be sure that
the value given for the csr is correct. The vector will be
discovered by the system.
.LP
The file \f(CWconf/files.vax\fP will need the following line
added to it:
.DS
.ft TY
vaxuba/ds.c		optional ds device-driver
.ft P
.DE
This informs the \fIconfig\fP program about the particulars
of the dsc driver.
.LP
The file \f(CWvax/conf.c\fP will need to have several changes
made to it. First add the following lines somewhere above the
initialization of \f(TYcdevsw\fP, e.g. above the line that says
.DS
.ft TY
struct cdevsw	cdevsw[] =
.ft P
.DE
but below the initialization of \f(TYbdevsw\fP.
.DS
.ft TY
#include "ds.h"
#if NDS > 0
int	dsopen(), dsclose(), dsread(), dswrite(), dsioctl(), dsreset();
#else NDS
#define	dsopen nodev
#define dsclose nodev
#define dsread nodev
#define dswrite nodev
#define dsioctl nodev
#define dsreset nodev
#endif NDS
.ft P
.DE
Next add the following lines to the initialization of \f(TYcdevsw\fP.
The commented number is the major number of this device, here at CARL
it is 26. You can make it anything you want as long as it doesn't
conflict with any other device's major device number.
.DS
.ft TY
.ta 8 +8 +8 +8 +8 +8 +8 +8 +8 +8
dsopen,	dsclose,	dsread,	dswrite,	/*26*/
dsioctl,	nulldev,	dsreset,	0,
seltrue,
.ft P
.DE
.LP
At this point you should be able to go into the \f(CWconf\fP
directory and run the \fIconfig\fP program and do a sysgen.
