h02721
s 00004/00004/00249
d D 1.3 84/09/08 23:47:19 rusty 3 2
c if getsfstabnam() fails then continues instead of exiting
e
s 00057/00032/00196
d D 1.2 84/09/08 22:23:28 rusty 2 1
c prints percentages
c if no args are given then quots all filesystems
e
s 00228/00000/00000
d D 1.1 84/09/08 20:18:23 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
I 2
# include "sfstab.h"
E 2

main(argc, argv)
	char	**argv;
{
D 2
	register char *pv;
	int	i, j;
E 2
I 2
	extern struct sfstab	*getsfstabnam();
	extern struct sfstab	*getsfstabent();
	register char		*pv;
	struct sfstab		*st;
	int			i, j;
E 2

	for (i = 1; i < argc; i++) {
		pv = argv[i];
		if (pv[0] != '-')
			break;
		for (j = 1; pv[j] != NULL; j++) {
			switch (pv[j]) {
				default:
					usage();
					break;
			}
		}
	}

D 2
	if (i == argc)
		usage();
E 2
I 2
	if (i == argc) {
		int	first = 1;
		while ((st = getsfstabent()) != NULL) {
			if (strcmp(st->st_mode, "xx") != 0) {
				if (first == 0)
					printf("\n");
				first = 0;
				quotsf(st);
			}
		}
	}
E 2
	else {
D 3
		while (i < argc) {
E 3
I 3
		for (; i < argc; i++) {
E 3
D 2
			quotsf(argv[i]);
E 2
I 2
			if ((st = getsfstabnam(argv[i])) == NULL) {
D 3
				fprintf(stderr, "can't get sfstab\n");
				return;
E 3
I 3
				fprintf(stderr, "can't get sfstab for %s\n", argv[i]);
				continue;
E 3
			}

			quotsf(st);
E 2
D 3
			if (++i < argc)
E 3
I 3
			if (i < argc)
E 3
				printf("\n");
		}
	}
I 2

	exit(0);
E 2
}

D 2
quotsf(sfsys)
	char	*sfsys;
E 2
I 2
quotsf(st)
	struct sfstab		*st;
E 2
{
D 2
	extern	char *index();
	register char	*cp;
	char	*scfmt = "%s%d%d%d%d%s";
	FILE	*fid;
	char	buf[BUFSIZ];
	char	dname[BUFSIZ];	/* sfsys name */
	char	fname[BUFSIZ];	/* sound file name */
	char	user[80];	/* user name */
	char	sj[40];		/* string junk; ignored scanf field */
	char	flag[40];	/* used, unused, allocated, freed */
	int	ij;		/* int junk; ignored scanf field */
	int	sz;		/* sound file size */
	int	stat;		/* sound file status */
	int	line;		/* current line in dskcyls */
E 2
I 2
	extern char		*index();
	register char		*cp;
	FILE			*fid;
	char			buf[BUFSIZ];
	char			dname[BUFSIZ];	/* sfsys name */
	char			fname[BUFSIZ];	/* sound file name */
	char			user[80];	/* user name */
	char			sj[40];		/* string junk */
	char			flag[40];	/* used, unused, etc. */
	int			ij;		/* int junk */
	int			sz;		/* sound file size */
	int			stat;		/* sound file status */
	int			line;		/* current line in dskcyls */
	char			*scfmt = "%s%d%d%d%d%s";
E 2

D 2
	printf("%s:\n", sfsys);
E 2
I 2
	printf("%s:\n", st->st_dir);
E 2

D 2
	sprintf(dname, "%s/dskcyls", sfsys);
E 2
I 2
	sprintf(dname, "%s/dskcyls", st->st_dir);
E 2
	if ((fid = fopen(dname, "r")) == NULL) {
		fprintf(stderr, "fopen: ");
		perror(dname);
		return;
	}

	line = 0;
	while (fgets(buf, sizeof(buf), fid) != NULL) {
		line++;
		if (sscanf(buf, scfmt, flag, &ij, &sz, &ij, &stat, fname) != 6) {
			fprintf(stderr, "%s: line %d mangled\n", fname, line);
			continue;
		}

		if (flag[0] == 'n')
			continue;

		/* /sndc/rusty/foo */

		for (ij = 0; ij < 3; ij++) {
			if ((cp = index(fname, '/')) == NULL) {
				if (strcmp(fname, "none") != 0)
					fprintf(stderr, "%s: line %d: funny sound file name\n", fname, line);
				goto contin;
			}

			*cp = '\t';
		}

		if (sscanf(fname, "%s%s", sj, user) != 2) {
			fprintf(stderr, "%s: line %d: can't decipher sound file name\n");
			continue;
		}

		add_tot(user, sz);

		contin:;
	}

D 2
	print_tots(sfsys);
E 2
I 2
	print_tots(st->st_dir, st);
E 2
}

struct hashlist {
	struct hashlist *	hl_next;	/* next hash entry	*/
	char *			hl_sym;		/* symbolic name	*/
	int			hl_tot;		/* value to store	*/
};

# define HSIZE		512

struct hashlist *hashlist[HSIZE];

D 2
print_tots(dname)
	char	*dname;
E 2
I 2
print_tots(dname, st)
	char		*dname;
	struct sfstab	*st;
E 2
{
D 2
	extern	FILE *popen();
	register struct hashlist *hl;
	register struct hashlist *hlnext;
	register int i;
	FILE	*fid;
E 2
I 2
	extern FILE			*popen();
	register struct hashlist	*hl;
	register struct hashlist	*hlnext;
	register int			i;
	FILE				*fid;
E 2

	if ((fid = popen("/usr/bin/sort +1rn", "w")) == NULL) {
		fprintf(stderr, "print_tots: can't find sort program\n");
		return;
	}

I 2
	printf("User		Cyls	Percentage\n");
E 2
	for (i = 0; i < HSIZE; i++) {
		for (hl = hashlist[i]; hl != NULL; hl = hlnext) {
D 2
			fprintf(fid, "%-10s %d\n", hl->hl_sym, hl->hl_tot);
E 2
I 2
			fprintf(fid, "%-10s\t%d\t%3d%%\n",
				hl->hl_sym,
				hl->hl_tot,
				((int) (100 * ((double) hl->hl_tot / (double) st->st_cylsize))));
E 2
			hlnext = hl->hl_next;
			free((char *) hl);
		}
		hashlist[i] = NULL;
	}

	pclose(fid);
}

add_tot(user, size)
	char	*user;
{
	extern	struct hashlist *lookup();
	extern	struct hashlist *install();
	register struct hashlist *hl;

	if ((hl = lookup(user)) == NULL) {
		if ((hl = install(user)) == NULL) {
			fprintf(stderr, "addtot: can't install %s\n", user);
			return;
		}
	}

	hl->hl_tot += size;
}

hash(sym)
	register char *sym;
{
	register int hashval;

	for (hashval = 0; *sym != NULL; hashval <<= 2, hashval += *sym++)
		continue;

	hashval += *(sym-1) << 5;
	hashval %= HSIZE;

	if (hashval < 0)
		hashval += HSIZE;

	return(hashval);
}

struct hashlist *
lookup(sym)
	char	*sym;
{
	register struct hashlist *hl;

	for (hl = hashlist[hash(sym)]; hl != NULL; hl = hl->hl_next) {
		if ((hl->hl_sym != NULL) && (strcmp(sym, hl->hl_sym) == 0))
			return(hl);
	}

	return(NULL);
}

struct hashlist *
install(sym)
	char	*sym;
{
	extern	char *calloc();
	extern	char *strsave();
	register struct hashlist *hl;
	int	hashval;

	if ((hl = (struct hashlist *) calloc(1, sizeof(struct hashlist))) == NULL) {
		fprintf(stderr, "install: can't calloc");
		return(NULL);
	}

	if ((hl->hl_sym = strsave(sym)) == NULL) {
		fprintf(stderr, "install: can't strsave");
		return(NULL);
	}

	hl->hl_tot = 0;

	hashval = hash(hl->hl_sym);
	hl->hl_next = hashlist[hashval];
	hashlist[hashval] = hl;

	return(hl);
}

char *
strsave(str)
	register char *str;
{
	extern char *malloc();
	register char *sp;

	if ((sp = malloc(strlen(str) + 1)) == NULL)
		return(NULL);

	strcpy(sp, str);

	return(sp);
}

usage() {
	fprintf(stderr, "quotsf: usage: quotsf sfsys\n");
	exit(1);
}
E 1
