/* symtab.h	1.2	(CARL)	4/25/84	15:47:17 */

# define ST_NL_INPUT	1			/* uv_numlist		*/
# define ST_NL_OUTPUT	2			/* uv_numlist		*/
# define ST_IDENT	3			/* uv_ident		*/
# define ST_NVAR	4			/* uv_var (number)	*/
# define ST_SVAR	5			/* uv_var (string)	*/

# define HSIZE		512

# define hl_numlist	hl_val.uv_numlist
# define hl_ident	hl_val.uv_ident
# define hl_var		hl_val.uv_var

/*
 * types of things that are managed
 * by a symbol table. each has its
 * own symbol table.
 */
union vals {
	struct numlist *	uv_numlist;	/* physical line numbers */
	struct ident *		uv_ident;	/* identifiers		*/
	struct var *		uv_var;		/* variables		*/
};

/*
 * structure of a symbol table
 * entry.
 */
struct hlist {
	char *			hl_sym;		/* symbolic name	*/
	struct hlist *		hl_next;	/* next hash entry	*/
	union vals		hl_val;		/* value to store	*/
};

extern struct hlist *lookup();
extern struct hlist *install();
