%{
/* lex.l	1.6	(CARL)	4/25/85	11:36:38 */

# include "parse.h"
# include "symtab.h"
# include "ident.h"
# include "aswdaemon.h"

int		cfnum;
char		cfstr[BUFSIZ];
%}

%%

"#".*"\n"	{
			debug(DB_LEX, "cflex: comment");
		}

[a-zA-Z_][a-zA-Z_0-9]* {
			struct hlist	*hl;

			debug(DB_LEX, "cflex: ident");
			if ((hl = lookup(yytext, ST_IDENT)) == NULL) {
				sscanf(yytext, "%s", &cfstr[0]);
				return(CF_IDENT);
			}

			strcpy(cfstr, hl->hl_ident->id_name);
			return(hl->hl_ident->id_val);
		}

\"[a-zA-Z_][a-zA-Z_0-9]*\" {
			extern char *index();
			register char *cp;

			debug(DB_LEX, "cflex: string");
# ifdef notdef
			/*
			 * change quotes to spaces so that
			 * we can use scanf.
			 */
			while ((cp = index(yytext, '"')) != NULL)
				*cp = ' ';
			scanf(yytext, "%s", cfstr);
# endif notdef
			strcpy(cfstr, &yytext[1]);
			cfstr[strlen(cfstr)-1] = NULL;
			return(CF_STRING);
		}

[0-9][0-9]*	{
			debug(DB_LEX, "cflex: number");
			sscanf(yytext, "%d", &cfnum);
			return(CF_NUMBER);
		}

";"		{
			debug(DB_LEX, "cflex: semi");
			return(CF_SEMI);
		}

","		{
			debug(DB_LEX, "cflex: comma");
			return(CF_COMMA);
		}

"["		{
			debug(DB_LEX, "cflex: lbrack");
			return(CF_LBRACK);
		}

"]"		{
			debug(DB_LEX, "cflex: rbrack");
			return(CF_RBRACK);
		}

"="		{
			debug(DB_LEX, "cflex: equal");
			return(CF_EQUAL);
		}

[ \t\n]*	{
			debug(DB_LEX, "cflex: blank");
		}

%%

static struct ident reswords[] = {
	{ "disconnect",	CF_DISCONNECT	},
	{ "connect",	CF_CONNECT	},
	{ "channel",	CF_CHANNEL	},
	{ "output",	CF_OUTPUT	},
	{ "input",	CF_INPUT	},
	{ "reset",	CF_RESET	},
	{ "init",	CF_INIT		},
	{ "from",	CF_FROM		},
	{ "dump",	CF_DUMP		},
	{ "set",	CF_SET		},
	{ "use",	CF_USE		},
	{ "is",		CF_IS		},
	{ "to",		CF_TO		},
	{ NULL,		-1		}
};

/*
 * instrw installs the reserved words
 */
instrw() {
	register struct ident *id;

	for (id = &reswords[0]; id->id_name != NULL; id++) {
		if (install(id->id_name, ST_IDENT, (char *) id) == NULL) {
			err(ERR_LEX, "instrw: can't install reserved words");
			return(RET_ERR);
		}
	}

	return(RET_OK);
}
