/* %M%	%I%	(CARL)	%G%	%U% */

# include <ctype.h>
# include <stdio.h>
# include "var.h"
# include "symtab.h"
# include "aswdaemon.h"

/*
 * start-up configuration stuff
 */

extern int setsw();

struct var vars[] = {
	/* message level variables */
	{ "error_msgs",		ST_NVAR,	(char *) &elevel,	NULL  },
	{ "info_msgs",		ST_NVAR,	(char *) &ilevel,	NULL  },
	{ "debug_msgs",		ST_NVAR,	(char *) &dlevel,	NULL  },
	/* configuration of particular behavior */
	{ "local_conn_only",	ST_NVAR,	(char *) &lconn,	NULL  },
	{ "single_output",	ST_NVAR,	(char *) &single_output,NULL  },
	/* misc string variables */
	{ "host",		ST_SVAR,	(char *) &hostnam[0],	NULL  },
	{ "switch",		ST_SVAR,	(char *) &swnam[0],	setsw },
	{ NULL,			-1,		NULL,			NULL  }
};

/*
 * cfget reads in the config
 * file.
 */
cfget() {
	extern char	*index();
	extern FILE	*asw_yyin;	/* in lex.c */
	static int	active;

	if (active != 0) {
		err(ERR_USER, "cfget: already reading config file");
		return(RET_ERR);
	}
	active = 1;

	/*
	 * using yyin isn't documented but it seems to
	 * be the only clean way to do what i want.
	 */
	if ((asw_yyin = fopen(conf_file, "r")) == NULL) {
		err(ERR_SYSTEM, "cfget: can't open config file: %s", conf_file);
		active = 0;
		return(RET_ERR);
	}

	info(INFO_INFO, "cfget: reading %s", conf_file);

	(void) asw_yyparse();

	fclose(asw_yyin);
	asw_yyin = NULL;

	active = 0;
	return(RET_OK);
}

/*
 * varset implements the command
 *	set var to number;
 * and
 *	set var to string;
 */
varset(hl, type, val)
	register struct hlist *hl;
	int type;
	char *val;
{
	switch (type) {
		case ST_NVAR:
			*hl->hl_var->vr_addr = (int) val;
			break;

		case ST_SVAR:
			strcpy(hl->hl_var->vr_addr, val);
			break;

		default:
			break;
	}

	if (hl->hl_var->vr_func != NULL)
		(*hl->hl_var->vr_func)(val);

	return(RET_OK);
}

/*
 * instvar installs all of the global
 * variables
 */
instvar() {
	register struct var *vr;

	for (vr = &vars[0]; vr->vr_name != NULL; vr++) {
		if (install(vr->vr_name, vr->vr_type, vr) == NULL) {
			err(ERR_SYMTAB, "varinst: can't install %s", vr->vr_name);
			return(RET_ERR);
		}
	}

	return(RET_OK);
}

/* for yacc */
asw_yywrap() {
	return(1);
};
