/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
# include "aswdaemon.h"
# include "client.h"
# include "clerr.h"

struct clerrtab clerrtab[] = {
	{ ASW_ERR_AOK,		"ok"				},
	{ ASW_ERR_CHAN,		"invalid channel"		},
	{ ASW_ERR_DEVIO,	"device or i/o error"		},
	{ ASW_ERR_PROG,		"daemon software error"		},
	{ ASW_ERR_SUBL,		"sublist error"			},
	{ ASW_ERR_SYNTAX,	"syntax error"			},
	{ ASW_ERR_NOTCONN,	"not connected"			},
	{ ASW_ERR_SYMCHAN,	"unknown symbolic channel"	},
	{ -1,			NULL				}
};

/*
 * return an error message to a
 * client. if flag is non-zero then
 * include the error message indicatd
 * by errno.
 */
clerrmsg(flag) {
	extern int errno, sys_nerr;
	extern char *sys_errlist[];
	register struct clerrtab *ce;
	register char *bp;
	char buf[BUFSIZ];

	if (client.cl_fsock == NULL)
		return;

	bp = &buf[0];

	/*
	 * linear search for the error message
	 * corresponding to this client's error.
	 */
	for (ce = &clerrtab[0]; ce->ce_str != NULL; ce++) {
		if (ce->ce_err == client.cl_err) {
			sprintf(bp, "%s", ce->ce_str);
			bp += strlen(bp);
			break;
		}
	}

	/* shouldn't happen */
	if (ce->ce_str == NULL) {
		sprintf(bp, "unknown error");
		bp += strlen(bp);
	}

	/*
	 * incorporate the errno message. must check that
	 * cl_err is set; sometimes errors local to the
	 * daemon set errno (log them if so).
	 */
	if ((errno != 0) && flag) {
		if (client.cl_err != ASW_ERR_AOK) {
			sprintf(bp, ": ");
			bp += strlen(bp);

			if ((unsigned) errno > sys_nerr)
				sprintf(bp, "error %d", errno);
			else
				sprintf(bp, sys_errlist[errno]);
			bp += strlen(bp);
		}
		else {
			char	buf2[BUFSIZ];

			if ((unsigned) errno > sys_nerr)
				sprintf(buf2, "error %d", errno);
			else
				sprintf(buf2, sys_errlist[errno]);
			info(INFO_USER, "clerrmsg: %s", buf2);
		}
	}

	/*
	 * strlen+1 so to send the trailing null
	 */
	if (write(client.cl_sock, buf, strlen(buf)+1) != strlen(buf)+1)
		err(ERR_SYSTEM, "clerrmsg: write: %m");
}
