/* %M%	%I%	(CARL)	%G%	%U% */

# define bit(n)		((1) << (n))

/* function return values */
# define RET_OK		(0)
# define RET_ERR	(-1)

/* debug messages */
# define DB_PARSE	bit(0)	/* parsing routines			*/
# define DB_LEX		bit(1)	/* lexing routines			*/
# define DB_IPC		bit(2)	/* interprocess routines		*/
# define DB_SYMTAB	bit(3)	/* symbol table routines		*/
# define DB_NUMLIST	bit(4)	/* number list routines			*/
# define DB_DRIVER	bit(5)	/* audio switch driver routines		*/
# define DB_CONNLIST	bit(6)	/* connection list routines		*/
# define DB_SYSTEM	bit(7)	/* low level routines; system calls	*/
# define DB_USER	bit(8)	/* user error (bad args, config file)	*/
# define DB_INFO	bit(9)	/* info messages of no particular class	*/

/* error messages */
# define ERR_PARSE	bit(0)	/* parsing routines			*/
# define ERR_LEX	bit(1)	/* lexing routines			*/
# define ERR_IPC	bit(2)	/* interprocess routines		*/
# define ERR_SYMTAB	bit(3)	/* symbol table routines		*/
# define ERR_NUMLIST	bit(4)	/* number list routines			*/
# define ERR_DRIVER	bit(5)	/* audio switch driver routines		*/
# define ERR_CONNLIST	bit(6)	/* connection list routines		*/
# define ERR_SYSTEM	bit(7)	/* low level routines; system calls	*/
# define ERR_USER	bit(8)	/* user error (bad args, config file)	*/
# define ERR_INFO	bit(9)	/* info messages of no particular class	*/

/* informative messages */
# define INFO_PARSE	bit(0)	/* parsing routines			*/
# define INFO_LEX	bit(1)	/* lexing routines			*/
# define INFO_IPC	bit(2)	/* interprocess routines		*/
# define INFO_SYMTAB	bit(3)	/* symbol table routines		*/
# define INFO_NUMLIST	bit(4)	/* number list routines			*/
# define INFO_DRIVER	bit(5)	/* audio switch driver routines		*/
# define INFO_CONNLIST	bit(6)	/* connection list routines		*/
# define INFO_SYSTEM	bit(7)	/* low level routines; system calls	*/
# define INFO_USER	bit(8)	/* user error (bad args, config file)	*/
# define INFO_INFO	bit(9)	/* info messages of no particular class	*/

# define NCLIENTS	5

# define MAXNAMLEN	80	/* maximum length of a pathname		*/

# define ELEVEL	1023		/* initial error messages		*/
# define ILEVEL	512		/* initial info messages		*/
# define DLEVEL	0		/* initial debug messages		*/

extern char	servnam[];	/* service name (in /etc/services)	*/
extern char	servproto[];	/* service protocol (in /etc/services)	*/
extern char	hostnam[];	/* aswdaemon host			*/
extern char	lhostnam[];	/* alternate aswdaemon host		*/
extern char	conf_file[];	/* configuration file			*/
extern char	devnam[];	/* name of /dev node to smart switcher	*/
extern char	swnam[];	/* name of switcher			*/

extern int	setup_done;	/* have completed setup()		*/
extern int	debug_mode;	/* running in debug mode		*/
extern int	sock;		/* master socket			*/

extern FILE *	asw_yyin;	/* file pointer used by lexical analyzer */

extern int	elevel;		/* level of error messages		*/
extern int	ilevel;		/* level of info messages		*/
extern int	dlevel;		/* level of debug messages		*/

extern int	lconn;		/* local socket connections only	*/
extern int	single_output;	/* break previous output connections	*/
