h11668
s 00003/00003/00215
d D 1.5 84/07/24 13:00:45 rusty 5 4
c changed error messages to use bits in elevel instead of ranges of values
e
s 00005/00004/00213
d D 1.4 84/07/24 12:20:25 rusty 4 3
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00010/00000/00207
d D 1.3 84/04/25 15:45:07 rusty 3 2
c many fixes to essentially add a new class of symbols to the symbol
c table; the class of variables. possibly other cosmetic changes
e
s 00043/00018/00164
d D 1.2 84/04/06 13:39:37 rusty 2 1
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00182/00000/00000
d D 1.1 84/04/03 11:03:28 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
I 4
# include "aswdaemon.h"
E 4
# include "symtab.h"
# include "numlist.h"
# include "ident.h"
I 3
# include "var.h"
E 3

/*
 * symbol table management routines
 */

I 2
/*
 * rather than have separate routines
 * for each symbol table we have an
 * array of symbol tables.
 */
E 2
struct symtab {
D 2
	int		ss_type;
	char *		ss_name;
	struct hlist **	ss_hlist;
E 2
I 2
	int		ss_type;	/* the ``type'' of the symbol table */
	char *		ss_name;	/* the string name (for diags)	*/
	struct hlist **	ss_hlist;	/* the symbol table itself	*/
E 2
};

extern struct symtab *getsymtab();
D 2
extern struct symtab *maksymtab();
E 2
extern struct hlist **makhlist();

I 2
/*
 * the array of the various symbol tables.
 */
E 2
static struct symtab symtab[] = {
	{ ST_NL_INPUT,	"input",	NULL },
	{ ST_NL_OUTPUT,	"output",	NULL },
	{ ST_IDENT,	"ident",	NULL },
I 3
	{ ST_NVAR,	"nvar",		NULL },
	{ ST_SVAR,	"svar",		NULL },
E 3
	{ -1,		NULL,		NULL }
};

I 2
/*
 * hash value routine. algorithm
 * copied from the ucb vax assembler.
 */
E 2
hash(sym)
	register char *sym;
{
	register int hashval;

	for (hashval = 0; *sym != NULL; hashval <<= 2, hashval += *sym++)
		continue;

	hashval += *(sym-1) << 5;
	hashval %= HSIZE;

	if (hashval < 0)
		hashval += HSIZE;

	return(hashval);
}

/*
 * find the symbol sym in the
 * symbol table
 */
struct hlist *
lookup(sym, type)
	register char *sym;
{
	register struct hlist *hl;
	register struct symtab *ss;

I 2
	/*
	 * first, get the symbol table
	 */
E 2
	if ((ss = getsymtab(type)) == NULL)
		return(NULL);

I 2
	/*
	 * regular symbol table search
	 */
E 2
	for (hl = ss->ss_hlist[hash(sym)]; hl != NULL; hl = hl->hl_next) {
		if ((hl->hl_sym != NULL) && (strcmp(sym, hl->hl_sym) == 0)) {
D 4
			debug(1, "lookup: found symbol %s in %s", sym, ss->ss_name);
E 4
I 4
			debug(DB_SYMTAB, "lookup: found symbol %s in %s", sym, ss->ss_name);
E 4
			return(hl);
		}
	}

D 4
	debug(1, "lookup: can't find symbol %s in %s", sym, ss->ss_name);
E 4
I 4
	debug(DB_SYMTAB, "lookup: can't find symbol %s in %s", sym, ss->ss_name);
E 4
I 2

E 2
	return(NULL);
}

/*
 * install a symbol in the symbol table.
 * if there is already a definition for
 * this symbol in the symbol table then
 * we clobber the previous definition
 * with this one.
 */
struct hlist *
install(sym, type, val)
	register char *sym;
	char *val;
{
D 2
	extern struct hlist *hlalloc();
E 2
I 2
	extern char *calloc();
E 2
	extern char *strsave();
	register struct symtab *ss;
	register struct hlist *hl;
	register int hashval;

	if ((hl = lookup(sym, type)) == NULL) {
D 2
		if ((hl = hlalloc(1)) == NULL) {
			err(1, "install: can't hlalloc");
E 2
I 2
		if ((hl = (struct hlist *) calloc(1, sizeof(struct hlist))) == NULL) {
D 5
			err(1, "install: can't calloc");
E 5
I 5
			err(ERR_SYMTAB, "install: can't calloc");
E 5
E 2
			return(NULL);
		}

		if ((hl->hl_sym = strsave(sym)) == NULL) {
D 5
			err(1, "install: can't strsave");
E 5
I 5
			err(ERR_SYMTAB, "install: can't strsave");
E 5
			return(NULL);
		}

		if ((ss = getsymtab(type)) == NULL)
			return(NULL);

D 4
		debug(1, "install: installing new sym %s in %s", sym, ss->ss_name);
E 4
I 4
		debug(DB_SYMTAB, "install: installing new sym %s in %s", sym, ss->ss_name);
E 4

		hashval = hash(hl->hl_sym);
		hl->hl_next = ss->ss_hlist[hashval];
		ss->ss_hlist[hashval] = hl;
	}
	else
D 4
		debug(1, "install: overwriting sym %s", sym);
E 4
I 4
		debug(DB_SYMTAB, "install: overwriting sym %s", sym);
E 4

I 2
	/* one way to deal with unions */
E 2
	switch (type) {
		case ST_NL_INPUT:
		case ST_NL_OUTPUT:
I 2
			if (hl->hl_numlist != NULL)
				free((char *) hl->hl_numlist);

E 2
			hl->hl_numlist = (struct numlist *) val;
			break;

		case ST_IDENT:
			hl->hl_ident = (struct ident *) val;
			break;

I 3
		case ST_NVAR:
		case ST_SVAR:
			hl->hl_var = (struct var *) val;
			break;

E 3
		default:
I 3
D 5
			err(1, "install: invalid type (%d)", type);
E 5
I 5
			err(ERR_SYMTAB, "install: invalid type (%d)", type);
E 5
			return(NULL);
E 3
			break;
	}

	return(hl);
}

D 2
struct hlist *
hlalloc(n) {
	extern char *calloc();
	register struct hlist *hl;

	if ((hl = (struct hlist *) calloc(n, sizeof(struct hlist))) == NULL)
		return(NULL);

	return(hl);
}

E 2
I 2
/*
 * routine to copy a string into
 * a new dynamically allocated
 * piece of memory.
 */
E 2
char *
strsave(str)
	register char *str;
{
	extern char *malloc();
	register char *sp;

	if ((sp = malloc(strlen(str) + 1)) == NULL)
		return(NULL);

	strcpy(sp, str);

	return(sp);
}

I 2
/*
 * routine to make/allocate a symbol table
 */
E 2
struct hlist **
makhlist() {
	extern char *calloc();
	register struct hlist **hl;

	if ((hl = (struct hlist **) calloc(HSIZE, sizeof(struct hlist *))) == NULL)
		return(NULL);

	return(hl);
}

I 2
/*
 * getsymtab gets a symbol table via a linear
 * search through the array of the symbol tables.
 * it initializes the symbol table the first
 * time it is accessed.
 */
E 2
struct symtab *
getsymtab(type) {
	register struct symtab *ss;

	for (ss = &symtab[0]; ss->ss_type != -1; ss++) {
		if (ss->ss_type == type) {
			if (ss->ss_hlist == NULL) {
				if ((ss->ss_hlist = makhlist()) == NULL)
					return(NULL);
			}

			return(ss);
		}
	}

	return(NULL);
}
E 1
