h43982
s 00000/00001/00179
d D 1.12 85/05/11 12:26:47 rusty 12 11
c deleted inclusion of <signal.h>
e
s 00002/00002/00178
d D 1.11 85/05/09 10:43:01 rusty 11 10
c bugfix; args to delconn were reversed
e
s 00005/00004/00175
d D 1.10 85/05/09 10:18:29 rusty 10 9
c changed some debug messages
e
s 00026/00007/00153
d D 1.9 85/03/14 16:12:39 rusty 9 8
c make args match with expectations (input & output types)
e
s 00003/00003/00157
d D 1.8 84/07/24 13:41:19 rusty 8 7
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00011/00011/00149
d D 1.7 84/07/24 13:01:15 rusty 7 6
c changed error messages to use bits in elevel instead of ranges of values
e
s 00004/00004/00156
d D 1.6 84/07/24 12:20:42 rusty 6 5
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00006/00006/00154
d D 1.5 84/04/18 17:53:43 rusty 5 4
c renamed smartsw.h to ss_defs.h
c changed all defines in ss_defs.h to SS_whatever
e
s 00016/00000/00144
d D 1.4 84/04/18 17:25:53 rusty 4 3
c fixed ss_disscon() to verify connection of channels
e
s 00018/00016/00126
d D 1.3 84/04/06 13:40:20 rusty 3 2
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00003/00004/00139
d D 1.2 84/04/02 17:52:47 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00143/00000/00000
d D 1.1 84/04/02 17:41:15 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/file.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
D 12
# include <signal.h>
E 12
# include <stdio.h>
# include "connlist.h"
# include "numlist.h"
D 5
# include "smartsw.h"
E 5
I 5
# include "ss_defs.h"
E 5
# include "client.h"
# include "clerr.h"
# include "switch.h"
# include "aswdaemon.h"

/*
 * disconnect routine for
 * cmd smart switcher
 */
D 9
ss_disconn(onl, inl)
	register struct numlist *onl;	/* output */
	register struct numlist *inl;	/* input  */
E 9
I 9
ss_disconn(nl1, nl2)
	struct numlist *nl1;
	struct numlist *nl2;
E 9
{
	register struct numlist *tonl, *tinl;
I 9
	register struct numlist *inl, *onl;
E 9
I 4
	register struct connlist *cl;
E 4
	short	num;
	int	ret;
	int	fd;

D 3
	debug(1, "disconn:");
E 3
I 3
D 6
	debug(1, "ss_disconn:");
E 6
I 6
D 10
	debug(DB_DRIVER, "ss_disconn:");
E 10
I 10
	/* debug(DB_DRIVER, "ss_disconn:"); */
E 10
E 6
E 3

D 9
	if ((onl == NULL) && (inl == NULL)) {
D 3
		err(1, "disconn: onl==NULL && inl==NULL");
E 3
I 3
D 7
		err(1, "ss_disconn: onl==NULL && inl==NULL");
E 7
I 7
		err(ERR_DRIVER, "ss_disconn: onl==NULL && inl==NULL");
E 9
I 9
	if ((nl1 == NULL) && (nl2 == NULL)) {
		err(ERR_DRIVER, "ss_disconn: nl1==NULL && nl2==NULL");
E 9
E 7
E 3
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}

I 9
	if (nl1->nl_type == NL_INPUT) {
		inl = nl1;
		onl = nl2;
	}
	else {
		inl = nl2;
		onl = nl1;
	}

	if (onl->nl_type == inl->nl_type) {
		info(INFO_DRIVER, "ss_disconn: can't disconnect same types");
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}

E 9
	if (onl == NULL)
		return(ss_disconn1(inl));

D 9
	if (inl == NULL)
		return(ss_disconn1(onl));
E 9
I 9
	if (inl == NULL) {
		err(ERR_USER, "ss_disconn: disconnecting only output disallowed");
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}
E 9

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
D 3
		err(1, "disconn: open(%s): %m", sw->sw_devnam);
E 3
I 3
D 7
		err(1, "ss_disconn: open(%s): %m", sw->sw_devnam);
E 7
I 7
		err(ERR_DRIVER, "ss_disconn: open(%s): %m", sw->sw_devnam);
E 7
E 3
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

	for (tonl = onl->nl_forw, tinl = inl->nl_forw; (tonl != onl) && (tinl != inl); tonl = tonl->nl_forw, tinl = tinl->nl_forw) {
		/* verify channels */
D 2
		if ((tonl->nl_num < MINCHAN) || (tonl->nl_num > MAXCHAN)) {
E 2
I 2
D 5
		if ((tonl->nl_num < MINCHAN) || (tonl->nl_num >= MAXCHAN)) {
E 5
I 5
		if ((tonl->nl_num < SS_MINCHAN) || (tonl->nl_num >= SS_MAXCHAN)) {
E 5
E 2
D 3
			info(2, "disconn: invalid output channel (%d)", tonl->nl_num);
E 3
I 3
D 8
			info(2, "ss_disconn: invalid output channel (%d)", tonl->nl_num);
E 8
I 8
			info(INFO_DRIVER, "ss_disconn: invalid output channel (%d)", tonl->nl_num);
E 8
E 3
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}
D 2

		if ((tinl->nl_num < MINCHAN) || (tinl->nl_num > MAXCHAN)) {
E 2
I 2
D 5
		if ((tinl->nl_num < MINCHAN) || (tinl->nl_num >= MAXCHAN)) {
E 5
I 5
		if ((tinl->nl_num < SS_MINCHAN) || (tinl->nl_num >= SS_MAXCHAN)) {
E 5
E 2
D 3
			info(2, "disconn: invalid input channel (%d)", tinl->nl_num);
E 3
I 3
D 8
			info(2, "ss_disconn: invalid input channel (%d)", tinl->nl_num);
E 8
I 8
			info(INFO_DRIVER, "ss_disconn: invalid input channel (%d)", tinl->nl_num);
E 8
E 3
			client.cl_err = ASW_ERR_CHAN;
I 4
			continue;
		}

		/*
		 * verify that the input space is really connected
		 * to the output space.
		 */
		if ((cl = isconn(tinl->nl_num, inl->nl_type)) == NULL) {
D 7
			err(1, "ss_disconn: not connected (%d)", tinl->nl_num);
E 7
I 7
			err(ERR_DRIVER, "ss_disconn: not connected (%d)", tinl->nl_num);
E 7
			client.cl_err = ASW_ERR_NOTCONN;
			continue;
		}
		if (cl->cl_output != tonl->nl_num) {
D 7
			err(1, "ss_disconn: %d not connected to %d", tinl->nl_num, tonl->nl_num);
E 7
I 7
			err(ERR_DRIVER, "ss_disconn: %d not connected to %d", tinl->nl_num, tonl->nl_num);
E 7
			client.cl_err = ASW_ERR_NOTCONN;
E 4
			continue;
		}

D 5
		num = DISCONN(tinl->nl_num, tonl->nl_num);
E 5
I 5
		num = SS_DISCONN(tinl->nl_num, tonl->nl_num);
E 5
D 3
		debug(1, "disconn: num = 0%o (0x%x)", num, num);
E 3
I 3
D 6
		debug(1, "ss_disconn: num = 0%o (0x%x)", num, num);
E 6
I 6
D 10
		debug(DB_DRIVER, "ss_disconn: num = 0%o (0x%x)", num, num);
E 10
I 10
		debug(DB_DRIVER, "ss_disconn: %d->%d", tinl->nl_num, tonl->nl_num);
E 10
E 6
E 3

		if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
D 3
			err(1, "disconn: write: %m");
E 3
I 3
D 7
			err(1, "ss_disconn: write: %m");
E 7
I 7
			err(ERR_DRIVER, "ss_disconn: write: %m");
E 7
E 3
			client.cl_err = ASW_ERR_DEVIO;
			continue;
		}

D 3
		(void) delconn(tinl->nl_num, tonl->nl_num);
E 3
I 3
D 11
		if (delconn(tinl->nl_num, tonl->nl_num) == RET_ERR)
D 7
			err(1, "ss_disconn: delconn failed");
E 7
I 7
			err(ERR_DRIVER, "ss_disconn: delconn failed");
E 11
I 11
		if (delconn(tonl->nl_num, tinl->nl_num) == RET_ERR)
			err(ERR_DRIVER, "ss_disconn: delconn(%d, %d) failed", tinl->nl_num, tonl->nl_num);
E 11
E 7
E 3
	}

	(void) close(fd);

	return(ret);
}

ss_disconn1(nl)
	register struct numlist *nl;
{
	register struct numlist *tnl;
	register struct connlist *cl;
	short	num;
	int	nconns;
	int	ret;
	int	fd;

D 3
	debug(1, "disconn1:");
E 3
I 3
D 6
	debug(1, "ss_disconn1:");
E 6
I 6
D 10
	debug(DB_DRIVER, "ss_disconn1:");
E 10
I 10
	/* debug(DB_DRIVER, "ss_disconn1:"); */
E 10
E 6
E 3

	if (nl == NULL) {
D 3
		err(1, "disconn1: nl==NULL");
E 3
I 3
D 7
		err(1, "ss_disconn1: nl==NULL");
E 7
I 7
		err(ERR_DRIVER, "ss_disconn1: nl==NULL");
E 7
E 3
		return(RET_ERR);
	}

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
D 3
		err(1, "disconn1: open(%s): %m", sw->sw_devnam);
E 3
I 3
D 7
		err(1, "ss_disconn1: open(%s): %m", sw->sw_devnam);
E 7
I 7
		err(ERR_DRIVER, "ss_disconn1: open(%s): %m", sw->sw_devnam);
E 7
E 3
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

	for (tnl = nl->nl_forw; tnl != nl; tnl = tnl->nl_forw) {
		/* verify channels */
D 2
		if ((tnl->nl_num < MINCHAN) || (tnl->nl_num > MAXCHAN)) {
E 2
I 2
D 5
		if ((tnl->nl_num < MINCHAN) || (tnl->nl_num >= MAXCHAN)) {
E 5
I 5
		if ((tnl->nl_num < SS_MINCHAN) || (tnl->nl_num >= SS_MAXCHAN)) {
E 5
E 2
D 3
			info(2, "disconn1: invalid output channel (%d)", tnl->nl_num);
E 3
I 3
D 8
			info(2, "ss_disconn1: invalid output channel (%d)", tnl->nl_num);
E 8
I 8
			info(INFO_DRIVER, "ss_disconn1: invalid output channel (%d)", tnl->nl_num);
E 8
E 3
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}

		nconns = 0;

		while ((cl = isconn(tnl->nl_num, nl->nl_type)) != NULL) {
D 5
			num = DISCONN(cl->cl_output, cl->cl_input);
E 5
I 5
			num = SS_DISCONN(cl->cl_output, cl->cl_input);
E 5
D 3
			debug(1, "disconn1: num = 0%o (0x%x)", num, num);
E 3
I 3
D 6
			debug(1, "ss_disconn1: num = 0%o (0x%x)", num, num);
E 6
I 6
D 10
			debug(DB_DRIVER, "ss_disconn1: num = 0%o (0x%x)", num, num);
E 10
I 10
			/* debug(DB_DRIVER, "ss_disconn1: num = 0%o (0x%x)", num, num); */
			debug(DB_DRIVER, "ss_disconn1: %d->%d", cl->cl_output, cl->cl_input);
E 10
E 6
E 3

			nconns++;

			if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
D 3
				err(1, "disconn1: write: %m");
E 3
I 3
D 7
				err(1, "ss_disconn1: write: %m");
E 7
I 7
				err(ERR_DRIVER, "ss_disconn1: write: %m");
E 7
E 3
				client.cl_err = ASW_ERR_DEVIO;
				continue;
			}

D 3
			(void) delconn(cl->cl_output, cl->cl_input);
E 3
I 3
			if (delconn(cl->cl_output, cl->cl_input) == RET_ERR)
D 7
				err(1, "ss_disconn1: delconn failed");
E 7
I 7
				err(ERR_DRIVER, "ss_disconn1: delconn failed");
E 7
E 3
		}

		if (nconns == 0) {
D 3
			err(1, "disconn1: not connected (%d)", tnl->nl_num);
E 3
I 3
D 7
			err(1, "ss_disconn1: not connected (%d)", tnl->nl_num);
E 7
I 7
			err(ERR_DRIVER, "ss_disconn1: not connected (%d)", tnl->nl_num);
E 7
E 3
			client.cl_err = ASW_ERR_NOTCONN;
		}
	}

out:	(void) close(fd);

	return(ret);
}
E 1
