h57258
s 00000/00001/00127
d D 1.12 85/05/11 12:26:41 rusty 12 11
c deleted inclusion of <signal.h>
e
s 00004/00003/00124
d D 1.11 85/05/09 10:18:18 rusty 11 10
c changed some debug messages
e
s 00002/00002/00125
d D 1.10 85/04/25 11:39:03 rusty 10 9
c changed name of "sout" var to "single_output"
e
s 00013/00010/00114
d D 1.9 84/11/18 15:09:59 rusty 9 8
c added some configuration variables to the config file instead of using #ifdef's in the code
e
s 00019/00007/00105
d D 1.8 84/11/18 14:43:18 rusty 8 7
c args coming in were assumed to be in a specific order but that isn't
c the case. ifdef'd out the code that always breaks previous connections of the
c output device.
e
s 00003/00003/00109
d D 1.7 84/07/24 13:41:15 rusty 7 6
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00006/00006/00106
d D 1.6 84/07/24 13:01:11 rusty 6 5
c changed error messages to use bits in elevel instead of ranges of values
e
s 00003/00003/00109
d D 1.5 84/07/24 12:20:37 rusty 5 4
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00005/00005/00107
d D 1.4 84/04/18 17:53:38 rusty 4 3
c renamed smartsw.h to ss_defs.h
c changed all defines in ss_defs.h to SS_whatever
e
s 00019/00015/00093
d D 1.3 84/04/06 13:40:12 rusty 3 2
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00002/00002/00106
d D 1.2 84/04/02 17:52:41 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00108/00000/00000
d D 1.1 84/04/02 17:40:18 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/file.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
D 12
# include <signal.h>
E 12
# include <stdio.h>
# include "connlist.h"
# include "numlist.h"
D 4
# include "smartsw.h"
E 4
I 4
# include "ss_defs.h"
E 4
# include "client.h"
# include "clerr.h"
# include "switch.h"
# include "aswdaemon.h"

/*
 * connect routine for
 * cmd smart switcher
 */
D 8
ss_conn(onl, inl)
	register struct numlist *onl;	/* output */
	register struct numlist *inl;	/* input  */
E 8
I 8
ss_conn(nl1, nl2)
	struct numlist *nl1;
	struct numlist *nl2;
E 8
{
	register struct numlist *tonl, *tinl;
I 8
	register struct numlist *onl, *inl;
E 8
	register struct connlist *cl;
	short num;
	int ret;
	int fd;

D 3
	debug(1, "conn:");
E 3
I 3
D 5
	debug(1, "ss_conn:");
E 5
I 5
D 11
	debug(DB_DRIVER, "ss_conn:");
E 11
I 11
	/* debug(DB_DRIVER, "ss_conn:"); */
E 11
E 5
E 3

D 8
	if (onl == NULL) {
D 3
		err(1, "conn: onl==NULL");
E 3
I 3
D 6
		err(1, "ss_conn: onl==NULL");
E 6
I 6
		err(ERR_DRIVER, "ss_conn: onl==NULL");
E 8
I 8
	if (nl1 == NULL) {
		err(ERR_DRIVER, "ss_conn: nl1==NULL");
E 8
E 6
E 3
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}
D 8
	if (inl == NULL) {
D 3
		err(1, "conn: inl==NULL");
E 3
I 3
D 6
		err(1, "ss_conn: inl==NULL");
E 6
I 6
		err(ERR_DRIVER, "ss_conn: inl==NULL");
E 8
I 8
	if (nl2 == NULL) {
		err(ERR_DRIVER, "ss_conn: nl2==NULL");
E 8
E 6
E 3
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}

I 8
	if (nl1->nl_type == NL_INPUT) {
		inl = nl1;
		onl = nl2;
	}
	else {
		inl = nl2;
		onl = nl1;
	}

E 8
	if (onl->nl_type == inl->nl_type) {
D 3
		info(2, "conn: can't connect same type");
E 3
I 3
D 7
		info(2, "ss_conn: can't connect same type");
E 7
I 7
		info(INFO_DRIVER, "ss_conn: can't connect same type");
E 7
E 3
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
D 3
		err(1, "conn: open(%s): %m", sw->sw_devnam);
E 3
I 3
D 6
		err(1, "ss_conn: open(%s): %m", sw->sw_devnam);
E 6
I 6
		err(ERR_DRIVER, "ss_conn: open(%s): %m", sw->sw_devnam);
E 6
E 3
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

D 3
	tinl = inl->nl_forw;

E 3
	/*
	 * for each input channel connect an output channel
	 * to it. if there are more output channels than
	 * input channels then output channels will be mixed
	 * together.
	 */
I 3
	tinl = inl->nl_forw;
E 3
	for (tonl = onl->nl_forw; tonl != onl; tonl = tonl->nl_forw) {
		/* verify channels */
D 2
		if ((tonl->nl_num < MINCHAN) || (tonl->nl_num > MAXCHAN)) {
E 2
I 2
D 4
		if ((tonl->nl_num < MINCHAN) || (tonl->nl_num >= MAXCHAN)) {
E 4
I 4
		if ((tonl->nl_num < SS_MINCHAN) || (tonl->nl_num >= SS_MAXCHAN)) {
E 4
E 2
D 3
			info(2, "conn: invalid output channel (%d)", tonl->nl_num);
E 3
I 3
D 7
			info(2, "ss_conn: invalid output channel (%d)", tonl->nl_num);
E 7
I 7
			info(INFO_DRIVER, "ss_conn: invalid output channel (%d)", tonl->nl_num);
E 7
E 3
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}
D 2
		if ((tinl->nl_num < MINCHAN) || (tinl->nl_num > MAXCHAN)) {
E 2
I 2
D 4
		if ((tinl->nl_num < MINCHAN) || (tinl->nl_num >= MAXCHAN)) {
E 4
I 4
		if ((tinl->nl_num < SS_MINCHAN) || (tinl->nl_num >= SS_MAXCHAN)) {
E 4
E 2
D 3
			info(2, "conn: invalid input channel (%d)", tinl->nl_num);
E 3
I 3
D 7
			info(2, "ss_conn: invalid input channel (%d)", tinl->nl_num);
E 7
I 7
			info(INFO_DRIVER, "ss_conn: invalid input channel (%d)", tinl->nl_num);
E 7
E 3
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}

I 8
D 9
# ifdef thanksbutnothanks
E 8
D 3
		/* break old connection */
E 3
I 3
		/* break previous connection */
E 3
		if ((cl = isconn(tonl->nl_num, CL_OUTPUT)) != NULL) {
D 4
			num = DISCONN(cl->cl_output, cl->cl_input);
E 4
I 4
			num = SS_DISCONN(cl->cl_output, cl->cl_input);
E 4
D 3
			debug(1, "conn: (disconn) num = 0%o (0x%x)", num, num);
E 3
I 3
D 5
			debug(1, "ss_conn: (disconn) num = 0%o (0x%x)", num, num);
E 5
I 5
			debug(DB_DRIVER, "ss_conn: (disconn) num = 0%o (0x%x)", num, num);
E 5
E 3
			if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
D 3
				err(1, "conn: write: %m");
E 3
I 3
D 6
				err(1, "ss_conn: write: %m");
E 6
I 6
				err(ERR_DRIVER, "ss_conn: write: %m");
E 6
E 3
				client.cl_err = ASW_ERR_DEVIO;
				continue;
E 9
I 9
		/*
D 10
		 * if sout is non-zero then always break previous
E 10
I 10
		 * if single_output is non-zero then always break previous
E 10
		 * connections of the output device.
		 */
D 10
		if (sout) {
E 10
I 10
		if (single_output) {
E 10
			if ((cl = isconn(tonl->nl_num, CL_OUTPUT)) != NULL) {
				num = SS_DISCONN(cl->cl_output, cl->cl_input);
D 11
				debug(DB_DRIVER, "ss_conn: (disconn) num = 0%o (0x%x)", num, num);
E 11
I 11
				/* debug(DB_DRIVER, "ss_conn: (disconn) num = 0%o (0x%x)", num, num); */
				debug(DB_DRIVER, "ss_conn: (disconn) %d->%d", cl->cl_output, cl->cl_input);
E 11
				if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
					err(ERR_DRIVER, "ss_conn: write: %m");
					client.cl_err = ASW_ERR_DEVIO;
					continue;
				}
E 9
			}
		}
I 8
D 9
# endif thanksbutnothanks
E 9
E 8

D 4
		num = CONN(tonl->nl_num, tinl->nl_num);
E 4
I 4
		num = SS_CONN(tonl->nl_num, tinl->nl_num);
E 4
D 3
		debug(1, "conn: (conn) num = 0%o (0x%x)", num, num);
E 3
I 3
D 5
		debug(1, "ss_conn: (conn) num = 0%o (0x%x)", num, num);
E 5
I 5
D 11
		debug(DB_DRIVER, "ss_conn: (conn) num = 0%o (0x%x)", num, num);
E 11
I 11
		debug(DB_DRIVER, "ss_conn: (conn) %d->%d", tonl->nl_num, tinl->nl_num);
E 11
E 5
E 3
		if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
D 3
			err(1, "conn: write: %m");
E 3
I 3
D 6
			err(1, "ss_conn: write: %m");
E 6
I 6
			err(ERR_DRIVER, "ss_conn: write: %m");
E 6
E 3
			client.cl_err = ASW_ERR_DEVIO;
			continue;
		}

D 3
		(void) addconn(tonl->nl_num, tinl->nl_num);
E 3
I 3
		if (addconn(tonl->nl_num, tinl->nl_num) == RET_ERR)
D 6
			err(1, "ss_conn: addconn failed");
E 6
I 6
			err(ERR_DRIVER, "ss_conn: addconn failed");
E 6
E 3

I 3
		/*
		 * if we're at the end of the list
		 * then loop back around.
		 */
E 3
		if ((tinl = tinl->nl_forw) == inl)
			tinl = inl->nl_forw;
	}

	(void) close(fd);

	return(ret);
}
E 1
