h12473
s 00008/00008/00262
d D 1.6 84/07/24 13:00:52 rusty 6 5
c changed error messages to use bits in elevel instead of ranges of values
e
s 00002/00002/00268
d D 1.5 84/07/24 12:20:32 rusty 5 4
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00024/00010/00246
d D 1.4 84/04/07 10:42:50 rusty 4 3
c minor changes to some comments
e
s 00067/00014/00189
d D 1.3 84/04/06 13:39:47 rusty 3 2
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00009/00002/00194
d D 1.2 84/04/02 17:52:34 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00196/00000/00000
d D 1.1 84/04/02 17:35:27 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
I 3
# include "aswdaemon.h"
E 3
# include "numlist.h"

/*
 * routines to manage number lists
 */

/*
D 3
 * if malloc ever runs out we'll
 * use this. mass confusion will
 * result but for the moment that's
 * all i care to do.
 */
static struct numlist onenum;

/*
E 3
D 4
 * maknl makes up the head of the list
 * and then calls addnl to add the
 * channel number to the list.
E 4
I 4
 * maknl makes up the head of a number
 * list and then calls addnl to add
 * the channel number to the list.
E 4
 */
struct numlist *
maknl(num, type) {
	extern char *malloc();
	register struct numlist *nl;

	if ((nl = (struct numlist *) malloc(sizeof(struct numlist))) == NULL) {
D 6
		err(1, "maknl: out of memory");
E 6
I 6
		err(ERR_NUMLIST, "maknl: out of memory");
E 6
D 3
		nl = &onenum;
E 3
I 3
		return(NULL);
E 3
	}

D 4
	nl->nl_num = -1;
E 4
I 4
	nl->nl_num = -1;	/* number list head */
E 4
	nl->nl_type = type;
	nl->nl_forw = nl;
	nl->nl_back = nl;

	return(addnl(nl, num));
}

/*
D 3
 * add number "num" to the numberlist "nl"
E 3
I 3
 * append number "num" to the numberlist "nl"
E 3
 */
struct numlist *
addnl(nl, num)
	register struct numlist *nl;
{
	extern char *malloc();
	register struct numlist *tnl;

	if (nl == NULL) {
D 6
		err(1, "addnl: nl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "addnl: nl==NULL");
E 6
		return(NULL);
	}

	if ((tnl = (struct numlist *) malloc(sizeof(struct numlist))) == NULL) {
D 6
		err(1, "addnl: out of memory");
E 6
I 6
		err(ERR_NUMLIST, "addnl: out of memory");
E 6
D 3
		tnl = &onenum;
E 3
I 3
		return(NULL);
E 3
	}

	tnl->nl_num = num;
	tnl->nl_type = nl->nl_type;

	/* link onto end of list */
	tnl->nl_forw = nl->nl_back->nl_forw;
	tnl->nl_back = nl->nl_back;
	nl->nl_back->nl_forw = tnl;
	nl->nl_back = tnl;

	return(nl);
}

/*
 * given a numlist "onl" and a numlist "inl"
 * use inl as a list of indices and return
 * those numbers from onl.
 *
 * e.g. if onl is (5, 9, 7, 4) and inl is (0, 1)
 * then subnl would return (5, 9). if inl were
 * (2, 3) then subnl would return (7, 4). if inl
D 4
 * were (0, 3) then subnl would return (5, 4).
E 4
I 4
 * were (3, 0) then subnl would return (4, 5).
 *
 * indices aren't constrained to be in any particular
 * order.
E 4
 */
struct numlist *
subnl(onl, inl)
	register struct numlist *onl;	/* original numlist */
	register struct numlist *inl;	/* indices numlist */
{
	register struct numlist *nl;	/* resulting numlist */
	register struct numlist *tonl;	/* temp onl pointer */
	register struct numlist *tinl;	/* temp inl pointer */
	register int count;

	if (onl == NULL) {
D 6
		err(1, "subnl: onl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "subnl: onl==NULL");
E 6
		return(NULL);
	}
	if (inl == NULL) {
D 6
		err(1, "subnl: inl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "subnl: inl==NULL");
E 6
		return(NULL);
	}

D 5
	debug(1, "subnl: onl=%s, inl=%s", prnumlist(onl), prnumlist(inl));
E 5
I 5
	debug(DB_NUMLIST, "subnl: onl=%s, inl=%s", prnumlist(onl), prnumlist(inl));
E 5

	nl = NULL;

I 4
	/*
	 * this is grossly inefficient. there probably is
	 * a more efficient way to do this.
	 */
E 4
	for (tinl = inl->nl_forw; tinl != inl; tinl = tinl->nl_forw) {
		count = 0;
		for (tonl = onl->nl_forw; tonl != onl; tonl = tonl->nl_forw) {
			if (tinl->nl_num == count) {
				if (nl == NULL) {
					if ((nl = maknl(tonl->nl_num, onl->nl_type)) == NULL)
						return(NULL);
				}
				else {
					if ((nl = addnl(nl, tonl->nl_num)) == NULL)
						return(NULL);
				}
			}
			count++;
		}
	}

D 5
	debug(1, "subnl: nl=%s", prnumlist(nl));
E 5
I 5
	debug(DB_NUMLIST, "subnl: nl=%s", prnumlist(nl));
E 5

	return(nl);
}

/*
I 3
 * construct a new numlist by
D 4
 * duplicating a previous one.
E 4
I 4
 * duplicating an existing one.
E 4
 */
struct numlist *
savenl(nl)
	register struct numlist *nl;
{
	register struct numlist *tnl;	/* temp nl pointer */
	register struct numlist *nnl;	/* new nl pointer */

	if (nl == NULL) {
D 6
		err(1, "savenl: nl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "savenl: nl==NULL");
E 6
		return(NULL);
	}

	nnl = NULL;
	for (tnl = nl->nl_forw; tnl != nl; tnl = tnl->nl_forw) {
		if (nnl == NULL) {
			if ((nnl = maknl(tnl->nl_num, tnl->nl_type)) == NULL)
				return(NULL);
		}
		else {
			if ((nnl = addnl(nnl, tnl->nl_num)) == NULL)
				return(NULL);
		}
	}

	return(nnl);
}

I 4
/*
 * free a number list
 */
E 4
freenl(nl)
	register struct numlist *nl;
{
	register struct numlist *tnl;	/* temp nl pointer */
	register struct numlist *forw;	/* temp forward nl pointer */

	if (nl == NULL) {
D 6
		err(1, "freenl: nl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "freenl: nl==NULL");
E 6
		return(RET_ERR);
	}

	/*
	 * unlink each numlist and free it
	 */
	for (tnl = nl->nl_forw; tnl != nl; tnl = forw) {
		/* unlink */
		tnl->nl_back->nl_forw = tnl->nl_forw;
		tnl->nl_forw->nl_back = tnl->nl_back;

		/* save forward link before tossing tnl */
		forw = tnl->nl_forw;

		free((char *) tnl);
	}

I 4
	/* free the head too */
E 4
	free((char *) nl);

	return(RET_OK);
}

/*
E 3
D 4
 * the type of a numberlist is sometimes
 * not known until late in the game of
 * parsing. this allows us to set the
 * type.
E 4
I 4
 * this allows us to set the
 * type of a numberlist. should
 * only need to set the type in
 * the head of the list, but for
 * safety's sake we'll set each
 * one.
E 4
 */
typenl(nl, type)
	register struct numlist *nl;
{
	register struct numlist *tnl;

	nl->nl_type = type;
I 4

E 4
	for (tnl = nl->nl_forw; tnl != nl; tnl = tnl->nl_forw)
		tnl->nl_type = type;
}

I 2
# define PRBUFFS	2

E 2
/*
 * return a string representation of
 * a numberlist. prnumlist returns the
 * address to a static array which is
 * overwritten on each call. ordinarily
 * something like
 *	printf("%s %s\n", prnumlist(nl1), prnumlist(nl2));
D 2
 * would fail so we use two separate
E 2
I 2
 * would fail so we use PRBUFFS separate
E 2
 * static arrays and alternate between
 * them.
 */
char *
prnumlist(nl)
	register struct numlist *nl;
{
	register struct numlist *tnl;
D 2
	static char bufs[2][BUFSIZ];
E 2
I 2
	static char bufs[PRBUFFS][BUFSIZ];
E 2
	static int flipflop;
	char numbuf[16];
	char *buf;
	int first;

	if (nl == NULL) {
D 6
		err(4, "prnumlist: nl==NULL");
E 6
I 6
		err(ERR_NUMLIST, "prnumlist: nl==NULL");
E 6
		return("?");
	}

I 2
	/*
	 * point buf at the next buffer. flipflop keeps track
	 * of the last one we used.
	 */
E 2
	buf = bufs[flipflop = flipflop++ % (sizeof(bufs) / sizeof(bufs[0]))];

	switch (nl->nl_type) {
		case NL_INPUT:
			strcpy(buf, "[input]");
			break;

		case NL_OUTPUT:
			strcpy(buf, "[output]");
			break;

		default:
I 2
D 3
			/* well ... */
E 2
			strcpy(buf, "[sideways]");
E 3
I 3
			strcpy(buf, "[sideways]");	/* well ... */
E 3
			break;
	}

	first = 1;
	for (tnl = nl->nl_forw; tnl != nl; tnl = tnl->nl_forw) {
		sprintf(numbuf, "%d", tnl->nl_num);
D 3
		strcat(buf, first ? " " : ", ");
E 3
I 3
		strcat(buf, first ? " " : ",");
E 3
		strcat(buf, numbuf);
		first = 0;
	}

	return(buf);
}
E 1
