h05001
s 00001/00001/00083
d D 1.7 84/07/24 13:41:35 rusty 7 6
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00002/00002/00082
d D 1.6 84/07/24 13:01:30 rusty 6 5
c changed error messages to use bits in elevel instead of ranges of values
e
s 00001/00001/00083
d D 1.5 84/07/24 12:20:57 rusty 5 4
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00007/00002/00077
d D 1.4 84/04/25 15:46:15 rusty 4 3
c many fixes to essentially add a new class of symbols to the symbol
c table; the class of variables. possibly other cosmetic changes
e
s 00003/00003/00076
d D 1.3 84/04/24 12:23:05 rusty 3 2
c removed conf structure and made level vars separate
e
s 00004/00000/00075
d D 1.2 84/04/10 08:09:16 rusty 2 1
c added /*VARARGS*/ in front of routines that needed it
e
s 00075/00000/00000
d D 1.1 84/04/09 17:29:26 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <syslog.h>
# include <sgtty.h>
# include <stdio.h>
D 4
# include "conf.h"
E 4
# include "aswdaemon.h"

/*
 * error logging and debug logging
 * routines. all logging routines
 * call the syslog() routine which
 * sends all messages to the syslog
 * daemon.
 */

I 2
/*VARARGS*/
E 2
err(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
D 3
	if (lvl <= conf.cf_elevel) {
E 3
I 3
D 6
	if (lvl <= elevel) {
E 6
I 6
	if (lvl & elevel) {
E 6
E 3
		if (setup_done)
			syslog(LOG_ERR, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

I 2
/*VARARGS*/
E 2
info(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
D 3
	if (lvl <= conf.cf_ilevel) {
E 3
I 3
D 5
	if (lvl <= ilevel) {
E 5
I 5
	if (lvl & ilevel) {
E 5
E 3
		if (setup_done)
			syslog(LOG_INFO, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

I 2
/*VARARGS*/
E 2
debug(lvl, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char *fmt;
{
D 3
	if (lvl <= conf.cf_dlevel) {
E 3
I 3
D 7
	if (lvl <= dlevel) {
E 7
I 7
	if (lvl & dlevel) {
E 7
E 3
D 4
		if (setup_done)
E 4
I 4
		if (setup_done) {
E 4
			syslog(LOG_DEBUG, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
I 4
			/*
			 * sometimes the syslog daemon
			 * gets swamped
			 */
			sleep(1);
		}
E 4
		else
			conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
	}
}

/*
 * error routine for yacc produced
 * parser
 */
asw_yyerror(str)
	char *str;
{
D 6
	err(1, "%s", str);
E 6
I 6
	err(ERR_PARSE, "%s", str);
E 6
}

I 2
/*VARARGS*/
E 2
conslog(fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9)
	char	*fmt;
{
	FILE	*fd;

	if ((fd = fopen("/dev/console", "w")) == NULL)
		return;

	fprintf(fd, fmt, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);

	fclose(fd);
}
E 1
