h61089
s 00030/00001/00193
d D 1.8 85/05/10 22:36:46 rusty 8 7
c added clget routines so other routines can examine connlist
e
s 00008/00000/00186
d D 1.7 85/05/09 10:17:43 rusty 7 6
c don't add connections to connlist when they're already in it
e
s 00005/00017/00181
d D 1.6 85/04/25 11:36:26 rusty 6 5
c added "dump" command
e
s 00004/00004/00194
d D 1.5 84/07/24 13:41:04 rusty 5 4
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00003/00003/00195
d D 1.4 84/07/24 13:00:59 rusty 4 3
c changed error messages to use bits in elevel instead of ranges of values
e
s 00038/00033/00160
d D 1.3 84/04/06 13:39:58 rusty 3 2
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00001/00001/00192
d D 1.2 84/04/02 17:52:28 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00193/00000/00000
d D 1.1 84/04/02 17:28:34 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include "connlist.h"
# include "aswdaemon.h"

/*
 * routines to manage connection lists
 */

D 8
static struct connlist *clhead = NULL;
E 8
I 8
static struct connlist	*clhead = NULL;
E 8

/*
D 3
 * if malloc ever runs out we'll
 * use this. mass confusion will
 * result but for the moment that's
 * all i care to do.
 */
static struct connlist oneconn;

/*
E 3
 * add connection of "inum" to "onum"
 * to the connlist.
 */
addconn(onum, inum) {
D 3
	extern char *malloc();
E 3
I 3
	extern char *calloc();
E 3
	register struct connlist *tcl;	/* temp connlist */

	if (clhead == NULL) {
		if (clsetup() == RET_ERR)
			return(RET_ERR);
	}

I 7
	/*
	 * linear search for this connection
	 */
	for (tcl = clhead->cl_forw; tcl != clhead; tcl = tcl->cl_forw) {
		if ((inum == tcl->cl_input) && (onum == tcl->cl_output))
			return(RET_OK); /* already connected */
	}

E 7
D 3
	if ((tcl = (struct connlist *) malloc(sizeof(struct connlist))) == NULL) {
E 3
I 3
	if ((tcl = (struct connlist *) calloc(1, sizeof(struct connlist))) == NULL) {
E 3
D 4
		err(1, "addconn: out of memory");
E 4
I 4
		err(ERR_CONNLIST, "addconn: out of memory");
E 4
D 3
		tcl = &oneconn;
E 3
I 3
		return(RET_ERR);
E 3
	}

	tcl->cl_input = inum;
	tcl->cl_output = onum;

	/* link onto end of list */
	tcl->cl_forw = clhead->cl_back->cl_forw;
	tcl->cl_back = clhead->cl_back;
	clhead->cl_back->cl_forw = tcl;
	clhead->cl_back = tcl;

	return(RET_OK);
}

/*
 * delete connection of "inum" to "onum"
 * from the connlist.
 */
delconn(onum, inum) {
	register struct connlist *tcl;
I 3
	register struct connlist *forw;
	register int dels;
E 3

	if (clhead == NULL) {
D 5
		info(3, "delconn: empty connlist");
E 5
I 5
		info(INFO_CONNLIST, "delconn: empty connlist");
E 5
		return(RET_ERR);
	}

	/*
	 * search the connection list looking for a
	 * connection between what we want to disconnect.
I 3
	 * just in case, we search the entire list in
	 * case there are multiple connections.
E 3
	 */
D 3
	for (tcl = clhead->cl_forw; tcl != clhead; tcl = tcl->cl_forw) {
E 3
I 3
	dels = 0;
	for (tcl = clhead->cl_forw; tcl != clhead; tcl = forw) {

		/* save forward link in case we toss tcl */
		forw = tcl->cl_forw;

E 3
		if ((tcl->cl_input == inum) && (tcl->cl_output == onum)) {
			/* unlink */
			tcl->cl_back->cl_forw = tcl->cl_forw;
			tcl->cl_forw->cl_back = tcl->cl_back;

			free((char *) tcl);

D 3
			return(RET_OK);
E 3
I 3
			dels++;
E 3
		}
	}

D 3
	info(3, "delconn: no such connection [%d,%d]", inum, onum);
E 3
I 3
	if (dels == 0) {
D 5
		info(3, "delconn: no such connection [%d,%d]", inum, onum);
E 5
I 5
		info(INFO_CONNLIST, "delconn: no such connection [%d,%d]", inum, onum);
E 5
		return(RET_ERR);
	}
E 3

D 3
	return(RET_ERR);
E 3
I 3
	return(RET_OK);
E 3
}

D 3

E 3
/*
 * delete all connections
 * from the connlist.
 */
clrconn() {
	register struct connlist *tcl;

	if (clhead == NULL) {
D 5
		info(3, "clrconn: empty connlist");
E 5
I 5
		info(INFO_CONNLIST, "clrconn: empty connlist");
E 5
		return(RET_ERR);
	}

	while ((tcl = clhead->cl_forw) != clhead) {
I 3
		/* unlink */
E 3
		tcl->cl_back->cl_forw = tcl->cl_forw;
		tcl->cl_forw->cl_back = tcl->cl_back;
I 3

E 3
		free((char *) tcl);
	}

	return(RET_OK);
}

struct connlist *
isconn(num, type) {
	register struct connlist *tcl;

	/*
D 2
	 * sometimes -1 might sneek in
E 2
I 2
	 * a previous bug sometimes let -1 sneek in
E 2
	 * (see parse.y).
	 */
	if ((type != CL_INPUT) && (type != CL_OUTPUT)) {
D 4
		err(1, "isconn: bad type (%d)", type);
E 4
I 4
		err(ERR_CONNLIST, "isconn: bad type (%d)", type);
E 4
		return(NULL);
	}

	if (clhead == NULL) {
D 5
		info(3, "isconn: empty connlist");
E 5
I 5
		info(INFO_CONNLIST, "isconn: empty connlist");
E 5
		return(NULL);
	}

	/*
	 * linear search for this connection
	 */
	for (tcl = clhead->cl_forw; tcl != clhead; tcl = tcl->cl_forw) {
		if ((num == tcl->cl_input) && (type == CL_INPUT))
			return(tcl);
		if ((num == tcl->cl_output) && (type == CL_OUTPUT))
			return(tcl);
	}

	return(NULL);
}

I 3
/*
 * routine to initialize clhead
 */
clsetup() {
	if ((clhead = (struct connlist *) calloc(1, sizeof(struct connlist))) == NULL) {
D 4
		err(1, "clsetup: out of memory (clhead)");
E 4
I 4
		err(ERR_CONNLIST, "clsetup: out of memory (clhead)");
E 4
		return(RET_ERR);
	}

	clhead->cl_back = clhead;
	clhead->cl_forw = clhead;

	return(RET_OK);
}

E 3
# define PRBUFFS	2

/*
 * return a string representation of
 * the connlist. prconnlist returns the
 * address to a static array which is
D 6
 * overwritten on each call. ordinarily
 * something like
D 3
 *	printf("%s %s\n", prconnlist(nl1), prconnlist(nl2));
E 3
I 3
 *	printf("%s %s\n", prconnlist(cl1), prconnlist(cl2));
E 3
 * would fail so we use PRBUFFS separate
 * static arrays and alternate between
 * them. this implies that only PRBUFFS
 * ``simultaneous'' calls can happen.
E 6
I 6
 * overwritten on each call.
E 6
 */
char *
prconnlist() {
	register struct connlist *tcl;
D 6
	static char bufs[PRBUFFS][BUFSIZ];
	static int flipflop;
E 6
I 6
	static char buf[BUFSIZ];
E 6
	char numbuf[16];
D 6
	char *buf;
E 6
	int first;

	if (clhead == NULL)
		return("");

D 6
	/*
	 * point buf at the next buffer. flipflop keeps track
	 * of the last one we used.
	 */
	buf = bufs[flipflop = flipflop++ % (sizeof(bufs) / sizeof(bufs[0]))];
E 6
I 6
	strcpy(buf, "");
E 6

	first = 1;
	for (tcl = clhead->cl_forw; tcl != clhead; tcl = tcl->cl_forw) {
D 6
		sprintf(numbuf, "[%d,%d]", tcl->cl_input, tcl->cl_output);
D 3
		strcat(buf, first ? " " : ", ");
E 3
I 3
		strcat(buf, first ? " " : ",");
E 6
I 6
		sprintf(numbuf, "%d->%d", tcl->cl_output, tcl->cl_input);
		strcat(buf, first ? "" : ",");
E 6
E 3
		strcat(buf, numbuf);
		first = 0;
	}

	return(buf);
I 8
}

/*
 * "clget" routines.
 *
 * clginit initializes the routines to the start of
 * the connlist list.
 *
 * clget gets the next connection from the connlist
 * or returns NULL if we've reached the end of the
 * list.
 */

static struct connlist		*clgnext;

clginit() {
	clgnext = clhead->cl_forw;
}

struct connlist *
clget() {
	register struct connlist	*tcl;

	tcl = clgnext;

	if ((clgnext = clgnext->cl_forw) == clhead)
		return(NULL);

	return(tcl);
E 8
D 3
}

/*
 * sets up clhead
 */
clsetup() {
	if ((clhead = (struct connlist *) malloc(sizeof(struct connlist))) == NULL) {
		err(1, "clsetup: out of memory (clhead)");
		return(RET_ERR);
	}

	clhead->cl_back = clhead;
	clhead->cl_forw = clhead;

	return(RET_OK);
E 3
}
E 1
