h63208
s 00001/00001/00114
d D 1.11 85/04/25 11:38:58 rusty 11 10
c changed name of "sout" var to "single_output"
e
s 00012/00002/00103
d D 1.10 85/03/14 16:14:24 rusty 10 9
c mods for "init" command
e
s 00005/00002/00100
d D 1.9 84/11/18 15:09:53 rusty 9 8
c added some configuration variables to the config file instead of using #ifdef's in the code
e
s 00003/00003/00099
d D 1.8 84/07/24 13:44:04 rusty 8 7
c changed error_level, info_level, debug_level to error_msgs, etc.
e
s 00001/00001/00101
d D 1.7 84/07/24 13:41:11 rusty 7 6
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00002/00002/00100
d D 1.6 84/07/24 13:01:05 rusty 6 5
c changed error messages to use bits in elevel instead of ranges of values
e
s 00001/00001/00101
d D 1.5 84/07/24 12:00:29 root 5 4
c bug fix for setting numeric variables
e
s 00050/00021/00052
d D 1.4 84/04/25 15:51:47 rusty 4 3
c many fixes to essentially add a new class of symbols to the symbol
c table; the class of variables. possibly other cosmetic changes
e
s 00003/00015/00070
d D 1.3 84/04/24 12:19:52 rusty 3 2
c removed conf structure and made level vars separate
e
s 00008/00000/00077
d D 1.2 84/04/02 17:52:21 rusty 2 1
c added a few comments, fixed a bug in ss_conn.c and ss_disconn.c
e
s 00077/00000/00000
d D 1.1 84/04/02 17:16:26 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <ctype.h>
# include <stdio.h>
D 4
# include "conf.h"
E 4
I 4
# include "var.h"
# include "symtab.h"
E 4
# include "aswdaemon.h"

/*
 * start-up configuration stuff
 */

D 3
struct conf conf;

E 3
D 4
struct cfvars cfvars[] = {
D 3
	{ "error_level",	(char *) &conf.cf_elevel },
	{ "info_level",		(char *) &conf.cf_ilevel },
	{ "debug_level",	(char *) &conf.cf_dlevel },
E 3
I 3
	{ "error_level",	(char *) &elevel },
	{ "info_level",		(char *) &ilevel },
	{ "debug_level",	(char *) &dlevel },
E 3
	{ NULL,		NULL }
E 4
I 4
extern int setsw();

struct var vars[] = {
D 9
	/* numeric variables */
E 9
I 9
	/* message level variables */
E 9
D 8
	{ "error_level",	ST_NVAR,	(char *) &elevel,	NULL  },
	{ "info_level",		ST_NVAR,	(char *) &ilevel,	NULL  },
	{ "debug_level",	ST_NVAR,	(char *) &dlevel,	NULL  },
E 8
I 8
	{ "error_msgs",		ST_NVAR,	(char *) &elevel,	NULL  },
	{ "info_msgs",		ST_NVAR,	(char *) &ilevel,	NULL  },
	{ "debug_msgs",		ST_NVAR,	(char *) &dlevel,	NULL  },
E 8
D 9
	/* string variables */
E 9
I 9
	/* configuration of particular behavior */
	{ "local_conn_only",	ST_NVAR,	(char *) &lconn,	NULL  },
D 11
	{ "single_output",	ST_NVAR,	(char *) &sout,		NULL  },
E 11
I 11
	{ "single_output",	ST_NVAR,	(char *) &single_output,NULL  },
E 11
	/* misc string variables */
E 9
	{ "host",		ST_SVAR,	(char *) &hostnam[0],	NULL  },
	{ "switch",		ST_SVAR,	(char *) &swnam[0],	setsw },
	{ NULL,			-1,		NULL,			NULL  }
E 4
};
D 3

config() {
	conf.cf_elevel = ELEVEL;
	conf.cf_ilevel = ILEVEL;
	conf.cf_dlevel = DLEVEL;

	(void) instrw();

	(void) cfget();
}
E 3

/*
 * cfget reads in the config
 * file.
 */
cfget() {
D 10
	extern char *index();
	extern FILE *asw_yyin;	/* in lex.c */
E 10
I 10
	extern char	*index();
	extern FILE	*asw_yyin;	/* in lex.c */
	static int	active;
E 10

I 10
	if (active != 0) {
		err(ERR_USER, "cfget: already reading config file");
		return(RET_ERR);
	}
	active = 1;

E 10
	/*
	 * using yyin isn't documented but it seems to
	 * be the only clean way to do what i want.
	 */
	if ((asw_yyin = fopen(conffile, "r")) == NULL) {
D 6
		err(1, "cfget: can't open config file: %s", conffile);
E 6
I 6
		err(ERR_SYSTEM, "cfget: can't open config file: %s", conffile);
I 10
		active = 0;
E 10
E 6
		return(RET_ERR);
	}

D 7
	info(1, "cfget: reading %s", conffile);
E 7
I 7
	info(INFO_INFO, "cfget: reading %s", conffile);
E 7

	(void) asw_yyparse();

	fclose(asw_yyin);
I 10
	asw_yyin = NULL;
E 10

I 10
	active = 0;
E 10
	return(RET_OK);
}

I 2
/*
D 4
 * cfvarset implements the command
E 4
I 4
 * varset implements the command
E 4
 *	set var to number;
I 4
 * and
 *	set var to string;
E 4
 */
E 2
D 4
cfvarset(cfname, num)
	char *cfname;
E 4
I 4
varset(hl, type, val)
	register struct hlist *hl;
	int type;
	char *val;
E 4
{
D 4
	register struct cfvars *cv;
E 4
I 4
	switch (type) {
		case ST_NVAR:
D 5
			*hl->hl_var->vr_addr = *val;
E 5
I 5
			*hl->hl_var->vr_addr = (int) val;
E 5
			break;
E 4

I 2
D 4
	/*
	 * linear search for the variable name
	 */
E 2
	for (cv = &cfvars[0]; cv->cv_name != NULL; cv++) {
		if (strcmp(cv->cv_name, cfname) == 0) {
			debug(1, "cfvarset: setting %s to %d", cfname, num);
			*cv->cv_addr = num;
			return(RET_OK);
		}
E 4
I 4
		case ST_SVAR:
			strcpy(hl->hl_var->vr_addr, val);
			break;

		default:
			break;
E 4
	}

D 4
	err(1, "cfvarset: no such config var %s", cfname);
E 4
I 4
	if (hl->hl_var->vr_func != NULL)
		(*hl->hl_var->vr_func)(val);
E 4

D 4
	return(RET_ERR);
E 4
I 4
	return(RET_OK);
}

/*
 * instvar installs all of the global
 * variables
 */
instvar() {
	register struct var *vr;

	for (vr = &vars[0]; vr->vr_name != NULL; vr++) {
		if (install(vr->vr_name, vr->vr_type, vr) == NULL) {
D 6
			err(1, "varinst: can't install %s", vr->vr_name);
E 6
I 6
			err(ERR_SYMTAB, "varinst: can't install %s", vr->vr_name);
E 6
			return(RET_ERR);
		}
	}

	return(RET_OK);
E 4
}

I 2
/* for yacc */
E 2
asw_yywrap() {
	return(1);
};
E 1
