h18409
s 00000/00000/00043
d D 1.2 85/11/26 23:02:15 dgl 2 1
c eliminated LOOKED_ALREADY from getheader to cure bug 
c re. trying to add property to stdin if no header exists yet.
e
s 00043/00000/00000
d D 1.1 85/11/25 09:59:38 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/carl.h>
#include <carl/procom.h>

/*
 * putplist - assign a property list to an iop
 * takes:
 * 	property list
 * 	iop
 * returns:
 * 	0 on success
 * 	-1 on errors
 * side effects:
 * 	if no property list existed on this iop before, 
 * 	then this property list will be used for any subsequent
 * 	calls with putprop() and putheader() or getprop() and
 * 	getheader()
 */

putplist(prop, iop)
	PROP *prop;
	FILE *iop;
{
	register struct fltbuf *f;
	
	if (iop == NULL)
		return(-1);

	if ((f = &fb[fileno(iop)]) != NULL)
		f->p = prop;
	
	/* 
	 * if we haven't already written header on this file, and
	 * if we have set the header here to non-NULL, say we've
	 * now got a header to send.
	 */
	if (f->prop != HDR_SENT && f->p != NULL)
		f->prop = HDR_PREPED;

	return(0);
}
E 1
