/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>
# include <carl/dx7.h>
# include <ctype.h>
# include <sys/param.h>

# define UCH(ch) ((unsigned char) ch)

int bug;
char *curfile, *prefix;
int voicen, channel;
extern int v32tov1(), v1tov32();
int (*massage)();
FILE *ofid;

main(argc, argv) 
	char **argv;
{
	extern u_char	ck_sum();
	int		ich, ch;
	u_char		uch;
	u_char		buf[5000];
	register int	len;
	FILE 		*fid;
	int 		nfds;
	int		n32vs = 0;

	ofid = stdout;

	while ((ch = crack(argc, argv, "hf|c|", 0)) != '\0') {
		switch (ch) {
			case 'f':
				prefix = arg_option;
				ofid = NULL;
				break;
			case 'c':
				channel = atol(arg_option);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if (arg_index == argc)
		usage(1);
	else
		for (nfds = 0; nfds < argc - arg_index && channel < 16; nfds++){
			curfile = argv[nfds + arg_index];
			if (fid = fopen(curfile, "r")) {
				while ((len = getvoice(buf, fid)) > 0
				    && channel < 16) {
					if (massage == 0) {
						if (isdx7v1(buf))
							massage = v1tov32;
						else if (isdx7v32(buf))
							massage = v32tov1;
						else
							woops(1);
					} else if ((isdx7v1(buf) 
					       && massage == v32tov1)
					    || (isdx7v32(buf)
					       && massage == v1tov32))
						woops(2);
					(*massage)(buf);
					if (massage == v1tov32 &&
					    ++voicen >= 32)
						n32vs = v32out();
				} 
			} else {
				fprintf(stderr, "fopen: ");
				perror(argv[nfds + arg_index]);
				exit(1);
			}
			fclose(fid);
		}

	if (massage == v1tov32) {
		if (voicen > 0 && voicen < 32) {
		    v32pad(voicen-1);
		    (void) v32out();
		}
	} 
	exit(0);
}

woops(ex)
{
	switch (ex) {
	case 1: fprintf(stderr, "mpuvcvt: wrong kind of voice\n"); break;
	case 2: fprintf(stderr, "mpuvcvt: not a voice\n"); break;
	}
	exit(ex);
}

usage(ex)
{
fprintf(stderr,
"usage: mpuvcvt [-c] mpu_data_file ...\n\
flag:\n\
	-cN	assign first voice bulk dump to MIDI channel N\n\
	-fX	place 1-voice data into separate files\n\
		in current working directory, or in the directory\n\
		given by X\n\
");
exit(ex);
}

u_char v32buf[32][128];

v1tov32(buf)
	u_char *buf;
{
	u_char *v = &buf[6];
	u_char *V = v32buf[voicen];
	int i, j, p;

	for (i = j = 0; i < DX7VOXLEN; i++) {
		p = i % DX7OPLEN;
		switch (p) {
		case 12:	/* keyboard level scaling right curve 12 => 11*/
			V[j+11] |= v[i] << 2; break;
		case 13:	/* keyboard rate scaling 13 => 12 */
			V[j+12] = v[i]; break;
		case 14:	/* amplitude mod. sens. 14 => 13 */
			V[j+13] = v[i]; break;
		case 15:	/* key vel. sens. 15 => 13<<2 */
			V[j+13] |= v[i] << 2; break;
		case 16:	/* op. output level 16 => 14 */
			V[j+14] = v[i]; break;
		case 17:	/* osc. mode 17 => 15 */
			V[j+15] = v[i]; break;
		case 18:	/* osc. freq. coarse 18 => 15<<1 */
			V[j+15] |= v[i] << 1; break;
		case 19:	/* osc. freq. fine 19 => 16 */
			V[j+16] = v[i]; break;
		case 20:	/* osc detune 20 => 12<<3; */
			V[j+12] |= v[i] << 3; j += 17; break;
		default:
			V[j+p] = v[i]; break;
		}
	}
	i = 126; p = 102;
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg rate */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* eg level */
	V[p++] = v[i++];	/* alg. sel. */
	V[111] = v[135];	/* feedback */
	V[111] |= v[136] << 3;	/* osc. key sync. */
	i = 137; p = 112;
	V[p++] = v[i++];	/* lfo speed */
	V[p++] = v[i++];	/* lfo delay */
	V[p++] = v[i++];	/* lfo pmd */
	V[p++] = v[i++];	/* lfo amd */
	V[116] = v[141];	/* lfo key sync */
	V[116] |= v[142] << 1;	/* lfo wave */
	V[116] |= v[143] << 4;	/* lfo pitch mod. sens. */
	V[117] = v[144];	/* transpose */
	i = 145; p = 118;
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
	V[p++] = v[i++];	/* voice name */
}

v32out()
{
	int v, p, check_sum = 0;

	putchar(0xff);			/* reset */
	putchar(0xf0);			/* system exclusive */
	putchar(0x43);			/* Yamaha id */
	putchar(channel++ & 0xf);	/* channel and substatus(==0) */
	putchar(0x09);			/* format */
	putchar(0x20);			/* byte count, msb */
	putchar(0x00);			/* byte count, lsb */
	for (v = 0; v < 32; v++) {
		for (p = 0; p < 128; p++) {
			int x = v32buf[v][p];
			putchar(x);
			check_sum += x;
		}
	}
	check_sum = 0x80 - (0x7f & check_sum);
	putchar(check_sum);
	putchar(0xf7);
	v32clr();
	return(1);
}

v32clr()
{
	register int i, j;

	voicen = 0;
	for (i = 0; i < 32; i++)
		for (j = 0; j < 128; j++)
			v32buf[i][j] = 0;
}

v32pad(vn)
{
	register int i, j;

	for (i = vn; i < 32; i++)
		for (j = 0; j < 128; j++)
			v32buf[i][j] = v32buf[vn][j];
}

v32tov1(buf)
	u_char *buf;
{
	int i, j, k, vn;
	struct v32 {
		u_char ops[6][17];
		u_char other[26];
	};
	struct V32 {
		u_char hdr[6];
		struct v32 v[32];
		u_char cksum;
		u_char eob;
	} *Vbuf = (struct V32 *) buf;
	u_char v[155];

	for (vn = 0; vn < 32; vn++) {
		for (i = k = 0; i < 6; i++, k += 21) {
			for (j = 0; j < 11; j++)
				v[k+j] = Vbuf->v[vn].ops[i][j];
			v[k+11] = Vbuf->v[vn].ops[i][11] & 3;
			v[k+12] = Vbuf->v[vn].ops[i][11] >> 2;
			v[k+13] = Vbuf->v[vn].ops[i][12] & 7;
			v[k+14] = Vbuf->v[vn].ops[i][13] & 3;
			v[k+15] = Vbuf->v[vn].ops[i][13] >> 2;
			v[k+16] = Vbuf->v[vn].ops[i][14];
			v[k+17] = Vbuf->v[vn].ops[i][15] & 1;
			v[k+18] = Vbuf->v[vn].ops[i][15] >> 1;
			v[k+19] = Vbuf->v[vn].ops[i][16];
			v[k+20] = Vbuf->v[vn].ops[i][12] >> 3;
		}
		i = 126, j = 0;
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];

		/* i = 134 */
		v[i++] = Vbuf->v[vn].other[j++] & 0x1f;
		v[i++] = Vbuf->v[vn].other[j] & 7;
		v[i++] = Vbuf->v[vn].other[j++] >> 3;
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j] & 1;
		v[i++] = Vbuf->v[vn].other[j] >> 1 & 7;
		v[i++] = Vbuf->v[vn].other[j++] >> 4 & 7;
		v[i++] = Vbuf->v[vn].other[j++];

		/* i = 145; */
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];
		v[i++] = Vbuf->v[vn].other[j++];

		(void) v1out(v);
	}
}

v1out(v)
	u_char *v;
{
	FILE *f; 
	register i; 
	int check_sum = 0;

	if (ofid != NULL)
		f = ofid;
	else {
		extern char* getv1name();
		char *name;
		char *z[MAXPATHLEN];

		if ((name = getv1name(v)) == NULL)
			return -1;
		if (strlen(prefix) + strlen(name) + 2 > MAXPATHLEN) {
			fprintf(stderr, "mpuvcvt: name too long\n");
			return -1;
		}
		if (prefix != NULL) {
			strcpy(z, prefix);
			if (*(prefix+strlen(prefix)) != '/')
			strcat(z, "/");
			strcat(z, name);
		} else
			strcpy(z, name);
		if ((f = fopen(z, "w")) == NULL) {
			fprintf(stderr, "fopen:");
			perror(z);
			exit(1);
		}
	}

	/* 1-voice header */
	putc(0xf0, f);
	putc(67, f);
	putc(channel & 0xff, f);
	putc(0, f);
	putc(1, f);
	putc(0x1b, f);

	/* voice template */
	for (i = 0; i < 155; i++) {
			putc(v[i], f);
			check_sum += v[i];
	}

	/* trailer */
	check_sum = 0x80 - (0x7f & check_sum);
	putc(check_sum, f);
	putc(0xf7, f);
	if (ofid == NULL)
		fclose(f);
	return 0;
}

char *
getv1name(v)
	u_char *v;
{
	static char n[BUFSIZ];
	register i;

	strncpy(n, &v[145], 10);
	for (i = 0; i < 10; i++) {
		if (!isprint(n[i])) {
			fprintf(stderr, "mpuvcvt: unprintable char in name\n");
			return NULL;
		}
		if (isspace(n[i]))
			n[i] = '_';
		if (isupper(n[i]))
			n[i] = tolower(n[i]);
	}
	if (n[0] == '-') {
		fprintf(stderr, "mpuvcvt: name begins with '-'");
		return NULL;
	}
	n[10] = '\0';
	strcat(n, ".dxv1");
	return n;
}
