/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

# define UCH(ch)	((unsigned char) ch)

static char		mpu[] = "/dev/mpu0";

u_char		cmds[BUFSIZ];

setup_cmds(val)
	u_char val;
{
	static int cnt;

	cmds[cnt++] = val;
	return(cnt);
}

int bug;

main(argc, argv) 
	char **argv;
{
	extern u_char	ck_sum();
	char 		buf[BUFSIZ];
	int		mpu_fd;
	int		setup_len = 0;
	u_char		run_mode = MPU_SEND_SYSTEM_MESSAGE;
	int		ich, ch, voicemode = 0, voicecnt = 0, channel = -1;
	u_char		uch;

	setup_cmds(UCH(0xff));	/* reset 		*/

	while ((ch = crack(argc, argv, "hvc|", 0)) != '\0') {
		switch (ch) {
			case 'v':
				voicemode = 1;
				break;
			case 'c':
				channel = atol(arg_option);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if ((mpu_fd = open(mpu, 2)) == -1) {
		fprintf(stderr, "open: ");
		perror(mpu);
		exit(1);
	}
	setup_len = setup_cmds(run_mode);	/* start stuffing */
	if (write(mpu_fd, cmds, setup_len) != setup_len) {
		perror("write1");
		exit(1);
	}

	if (voicemode) {
		u_char buf[BUFSIZ];
		register int len;

		if ((len = get_dx7_voice(buf, stdin)) <= 0) {
			fprintf(stderr, "no dx7 voice in data\n");
			exit(1);
		}
		if (channel >= 0)
			/* don't seem to need to recompute checksum */
			buf[2] = (buf[2] & 0x70) | (channel & 0xf);
		if (write(mpu_fd, buf, len) != len) {
			perror("write2");
			exit(1);
		}
	} else
		other(mpu_fd);


	close(mpu_fd);
}

get_dx7_voice(buf, fid)
	u_char *buf;
	FILE *fid;
{
	int n, ich, i, cksum = 0;
	u_char uch;

	/* get to SX data */
	while ((ich = getchar()) != EOF) {
		if (ich == SX_CMD) {
			ungetc(ich, fid);
			break;
		}
	}
	if (ich == EOF)
		return(-1);
	if ((n = fread(buf, sizeof(u_char), 163, fid)) != 163) {
		perror("fread");
		exit(1);
	}
	for (i = 0; i < 155; i++)
		cksum += buf[6+i];
	cksum = 0x80 - (0x7f & cksum);
	buf[161] = cksum;
	return(163);
}

other(mpu_fd)
	int mpu_fd;
{
	int 	n;
	u_char 	buf[BUFSIZ];

	while ((n = read(0, buf, BUFSIZ)) > 0) {
		if (write(mpu_fd, buf, n) != n) {
			perror("write");
			exit(1);
		}
	}
}

usage(ex)
{
fprintf(stderr,
"usage: mpusxstuff [flag] < mpu_data > mpu_data\n\
flags:\n\
	-v	input mpu_data contains dx7 voice specification\n\
	-cN	voice data will be put on midi channel N\n\
");
exit(ex);
}
