/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/mpu.h>

# define UCH(ch)	((unsigned char) ch)

static char		mpu[] = "/dev/mpu0";
static char		tty[] = "/dev/tty";

u_char		cmds[BUFSIZ];

setup_cmds(val)
	u_char val;
{
	static int cnt;

	cmds[cnt++] = val;
	return(cnt);
}

main(argc, argv) 
	char **argv;
{
	char 		buf[BUFSIZ],
			*cmd_file = NULL;
	register int	i;
	int		mpu_fd, tty_fd, otty = isatty(1), option;
	unsigned char	ch;
	int		n,
			wait = 1,
			setup_len = 0;
	u_char		run_mode = MPU_START_RECORD;

	setup_cmds(UCH(0xff));	/* reset 		*/

	while ((ch = crack(argc, argv, "xhwc|mMb|B|t|", 0)) != '\0') {
		switch (ch) {
			case 'x':
				setup_cmds(MPU_EXCLUSIVE_TO_HOST_ON);
				setup_cmds(MPU_SEND_MEASURE_END_OFF);
				run_mode = MPU_RECORD_STANDBY;
				break;
			case 'w':
				wait = 0;
				break;
			case 'c':
				cmd_file = arg_option;
				break;
			case 'm':
				setup_cmds(MPU_METRO_NO_ACC);
				break;
			case 'M':
				setup_cmds(MPU_METRO_ACC);
				break;
			case 'b':	/* beats per measure */
				setup_cmds(MPU_METRO_MEAS);
				ch = sfexpr(arg_option, 1.0);
				setup_cmds(ch);
				break;
			case 'B':
				{
				register int tmp = sfexpr(arg_option, 1.0);
				if (tmp < 48 || tmp > 192) {
					fprintf(stderr, "illegal timebase\n");
					exit(1);
				}
				tmp = (tmp - 48) / 24;
				setup_cmds(tmp + 0xc2);
				break;
				}
			case 't':
				setup_cmds(MPU_TEMPO);
				ch = sfexpr(arg_option, 1.0);
				setup_cmds(ch);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if ((mpu_fd = open(mpu, 2)) == -1) {
		fprintf(stderr, "open: ");
		perror(mpu);
		exit(1);
	}
	if ((tty_fd = open(tty, 2)) == -1) {
		fprintf(stderr, "open: ");
		perror(tty);
		exit(1);
	}
	setcbrk(tty_fd);

	if (wait) {
		fprintf(stderr, "Press [RETURN] to record\t");
		fflush(stderr);
		if (iwait(tty_fd, 60L) == 0) {
			fprintf(stderr, "timeout, aborting.\n");
			exit(1);
		} else
			read(tty_fd, &ch, 1);
	}

	if (cmd_file != NULL) {
		FILE *fid;
		if ((fid = fopen(cmd_file, "r")) == NULL) {
			perror("fopen");
			exit(1);
		}
		while (fscanf(fid, "%s", buf) == 1) {
			ch = sfexpr(buf, 1.0);
			if (write(mpu_fd, &ch, sizeof(char)) != sizeof(char)) {
				perror("write");
				exit(1);
			}
		}
	} else {
		setup_cmds(UCH(0x87));			/* bender on	   */
		setup_len = setup_cmds(run_mode);	/* start recording */
		if (write(mpu_fd, cmds, setup_len) != setup_len) {
			perror("write");
			exit(1);
		}
	}

	while (iwait(tty_fd, 0L) == 0) {
		if ((n = read(mpu_fd, buf, 1)) > 0) {
			if (otty) {
				for (i = 0; i < n; i++)
					printf("0x%02x\n", 
						buf[i] & (u_char) -1);
			}
			else {
				if (write(1, buf, n) != n) {
					perror("write");
					break;
				}
			}
		}
		else {
			perror("read");
			break;
		}
	}

	clrcbrk(tty_fd);
	close(tty_fd);
	close(mpu_fd);
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s",
"usage: mpurecord [flags] > mpu_data\n",
"flags:\n",
"\t-cS\tsend configuration file S to MPU instead of default initialization\n",
"\t-w\tdon't wait for [RETURN] to start\n",
"\t-m\tturn on MPU metronome, no accent\n",
"\t-M\tturn on MPU metronome, with accent\n",
"\t-bN\tset number of beats per measure to N\n",
"\t-BN\tset mpu internal timebase to 48, 72, 96, 120, 144, 168, 192\n",
"\t-tN\tset tempo to N beats per minute\n",
"\t-x\tenable recording system exclusive data\n"
);
exit(ex);
}
