h26234
s 00009/00003/00211
d D 1.4 86/09/03 13:53:51 dgl 4 3
c better error handling.
e
s 00033/00036/00181
d D 1.3 85/03/29 11:09:24 dgl 3 2
c added -r flag to suppress reset of synthesizers.
e
s 00016/00004/00201
d D 1.2 85/02/21 15:38:49 dgl 2 1
c added flag to set time base
e
s 00205/00000/00000
d D 1.1 84/12/21 11:45:19 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <signal.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

D 3
/* always emit reset code for dx7 */
# define RESET_DX7

E 3
# define MPU_TRACK(x) (1 << x)

char		mpu[] = MPU_DEV_0;
char		tty[] = "/dev/tty";
D 3
u_char		reset = RT_RESET;
E 3
u_char		mpu_cmds[BUFSIZ];
int		ifds[20] = {
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
	-1, -1, -1, -1, -1, -1, -1, -1, -1, -1
};

main(argc, argv) 
	char **argv;
{
D 3
	extern	int dx7_reset();
E 3
I 3
	extern	int synth_reset();
E 3
	u_char	buf[BUFSIZ];
	char	*cmd_file = NULL;
	int	mpu_fd,
		setup_len,
		track,
		ret_wait = 0,
		n,
		ch,
		nfds = 0,
		cur_fd = 0,
D 3
		itty = isatty(0);
E 3
I 3
		itty = isatty(0),
		s_reset = 1;
E 3

I 3

	/* always catch interrupts */
E 3
	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
D 3
		signal(SIGINT, dx7_reset);
E 3
I 3
		signal(SIGINT, synth_reset);
E 3

D 3
# ifdef RESET_DX7
	dx7_clear(mpu_cmds);
# else
	(void) setup_cmds(mpu_cmds, 0xff);		/* reset */
# endif RESET_DX7
E 3
I 3
	(void) setup_cmds(mpu_cmds, 0xff);		/* reset mpu */
E 3

D 2
	while ((ch = crack(argc, argv, "c|mMB|t|hw", 1)) != '\0') {
E 2
I 2
D 3
	while ((ch = crack(argc, argv, "c|mMb|B|t|hw", 1)) != '\0') {
E 3
I 3
	while ((ch = crack(argc, argv, "rc|mMb|B|t|hw", 1)) != '\0') {
E 3
E 2
		switch (ch) {
D 3
			case 'w':
				ret_wait = 1;
				break;
			case 'c':
				cmd_file = arg_option;
				break;
			case 'm':
				(void) setup_cmds(mpu_cmds, MPU_METRO_NO_ACC);
				break;
			case 'M':
				(void) setup_cmds(mpu_cmds, MPU_METRO_ACC);
				break;
D 2
			case 'B':
E 2
I 2
			case 'b':
E 2
				(void) setup_cmds(mpu_cmds, MPU_METRO_MEAS);
				ch = sfexpr(arg_option, 1.0);
				(void) setup_cmds(mpu_cmds, ch);
				break;
E 3
I 2
			case 'B':
				{
				register int tmp = sfexpr(arg_option, 1.0);
				if (tmp < 48 || tmp > 192) {
					fprintf(stderr, "illegal timebase\n");
					exit(1);
				}
				tmp = (tmp - 48) / 24;
				(void) setup_cmds(mpu_cmds, tmp + 0xc2);
				break;
				}
E 2
D 3
			case 't':
				(void) setup_cmds(mpu_cmds, MPU_TEMPO);
E 3
I 3
			case 'M':
				(void) setup_cmds(mpu_cmds, MPU_METRO_ACC);
				break;
			case 'b':
				(void) setup_cmds(mpu_cmds, MPU_METRO_MEAS);
E 3
				ch = sfexpr(arg_option, 1.0);
				(void) setup_cmds(mpu_cmds, ch);
				break;
I 3
			case 'c':
				cmd_file = arg_option;
				break;
E 3
			case 'h':
				usage(0);
I 3
			case 'm':
				(void) setup_cmds(mpu_cmds, MPU_METRO_NO_ACC);
				break;
			case 'r':
				s_reset = 0;
				break;
			case 't':
				(void) setup_cmds(mpu_cmds, MPU_TEMPO);
				ch = sfexpr(arg_option, 1.0);
				(void) setup_cmds(mpu_cmds, ch);
				break;
			case 'w':
				ret_wait = 1;
				break;
E 3
			default:
				usage(1);
		}
	}

	if (itty && argc == arg_index)
		usage(1);	/* no input files, and no stdin */
	else if (!itty) {	/* read from stdin */
		ifds[0] = 0;
		nfds = 1;
	} else {
		if (argc - arg_index >= 20) {
			fprintf(stderr, "mpuplay too many files!\n");
			usage(1);
		}
		for (nfds = 0; nfds < argc - arg_index; nfds++) {
			if ((ifds[nfds] = open(argv[nfds + arg_index], 0))
			    == -1) {
				fprintf(stderr, "mpuplay: %s ", 
					argv[nfds + arg_index]);
				perror("open");
			}
		}
	}

	/* open for reading and writing */
D 4
	if ((mpu_fd = open(mpu, 2)) == -1)
E 4
I 4
	if ((mpu_fd = open(mpu, 2)) == -1) {
		fprintf(stderr, "open:");
		perror(mpu);
E 4
		exit(1);
I 4
	}
E 4

	/* pre-write first midi buffer */
	/* tell the driver to expect track 0 data */
	track = 0;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(2);
	/* and write first data buffer */
	if ((n = read(ifds[cur_fd], buf, BUFSIZ)) > 0) {
		if (write(mpu_fd, buf, n) != n) {
			perror("write");
			exit(3);
		}
	}

	/* tell the driver to expect command data */
	track = MPU_TR_COM;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);
	/* user specified command file? */
	if (cmd_file != NULL) {
		FILE *cmd_fid;
		u_char str_buf[BUFSIZ], cmd;

		if ((cmd_fid = fopen(cmd_file, "r")) == NULL) {
D 4
			perror("fopen");
E 4
I 4
			fprintf(stderr, "fopen:");
			perror(cmd_file);
E 4
			exit(1);
		}
		while (fscanf(cmd_fid, "%s", str_buf) == 1) {
			cmd = sfexpr(str_buf, 1.0);
			setup_len = setup_cmds(mpu_cmds, cmd);
		}
		fclose(cmd_fid);
	} else {
		/* start up mpu */
		(void) setup_cmds(mpu_cmds, 0xec);		/* active track */
		(void) setup_cmds(mpu_cmds, MPU_TRACK(0));	/* track 0 */
		(void) setup_cmds(mpu_cmds, 0xb8);		/* clear play */
		(void) setup_cmds(mpu_cmds, 0x87);		/* bender on */
		setup_len = setup_cmds(mpu_cmds, 0x0a);	/* play on */
	}

	/* wait for user to say start? */
	if (ret_wait) {
		int tty_fd;

		if ((tty_fd = open(tty, 2)) == -1) {
			fprintf(stderr, "open: ");
			perror(tty);
			exit(1);
		}
		fprintf(stderr, "Press [RETURN] to play\t");
		fflush(stderr);
		if (iwait(tty_fd, 3600L) == 0) {
			fprintf(stderr, "timeout, aborting.\n");
			exit(1);
		} else
			read(tty_fd, &ch, 1);
	}

	/* go for it! */
	if (write(mpu_fd, mpu_cmds, setup_len) != setup_len) {
		perror("write");
		exit(5);
	}

	/* shove over the rest */
	/* tell the driver to expect track 0 data */
	track = 0;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1)
		exit(6);
	while (nfds--) {
		while ((n = read(ifds[cur_fd], buf, BUFSIZ)) > 0) {
			if (write(mpu_fd, buf, n) != n) {
				perror("write");
				exit(7);
			}
		}
		cur_fd++;
	}
D 4
	close(mpu_fd);
E 4
I 4
	if (close(mpu_fd) != 0)
		exit(8);
E 4
D 3
# ifdef RESET_DX7
	dx7_reset(-1);
# endif RESET_DX7
E 3
I 3
	if (s_reset)
		synth_reset(-1);
I 4
	exit(0);
E 4
E 3
}

usage(ex)
{
D 2
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s",
E 2
I 2
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s",
E 2
"usage:	mpuplay [flags] mpu_data_file ...\n",
"or:	mpuplay [flags] < mpu_data_file\n",
"flags:\n",
"\t-cS\tsend configuration file S to MPU\n",
"\t-w\twait for [RETURN] to start\n",
"\t-m\tturn on MPU metronome, no accent\n",
"\t-M\tturn on MPU metronome, with accent\n",
D 2
"\t-BN\tset number of beats per measure to N\n",
E 2
I 2
"\t-bN\tset number of beats per measure to N\n",
"\t-BN\tset mpu internal timebase to 48, 72, 96, 120, 144, 168, 192\n",
E 2
"\t-tN\tset tempo to N beats per minute\n",
D 3
"\t-rX\treset/initialize synthesizer type X\n"
E 3
I 3
"\t-rX\tsuppress synthesizer reset at finish\n"
E 3
);
exit(ex);
}
E 1
