/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include <carl/mpu.h>

int otty;
double tempo = MPU_DEFAULT_TEMPO;
double TB = MPU_DEFAULT_TIME_BASE;
double tps = MPU_TPS(MPU_DEFAULT_TEMPO, MPU_DEFAULT_TIME_BASE);


M_start()
{
	if (isatty(1)) {
		fprintf(stderr, "output must be a file or pipe\n");
		usage(1);
	}
}

typedef struct mpu_cmd smpc;

int nstnc, bug;

Player part()
{
	extern char 			*malloc();
	Instance smpc 			*mp;
	Instance FILE 			*fid;
	Instance int			first;
	Instance long			my_time;
	Instance u_char *		buf;
	Instance int			my_nstnc;

	P_start {
		my_nstnc = nstnc++;
		my_time = Now;	/* initialize when we start */

		if ((fid = fopen(Ps1, "r")) == NULL) {
			perror("fopen");
			exit(1);
		}
		if ((mp = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) 
		    == NULL) {
			perror("malloc");
			exit(1);
		}
		if ((buf = (u_char *) malloc(BUFSIZ)) == NULL) {
			perror("malloc");
			exit(1);
		}
	}

	if (first == 0)
		first = 1;
	else 
		put_mpu_cmd(mp, my_time);

	if ((mp = get_mpu_cmd(fid, mp)) == NULL) {
		Kill(Self);
		Return;
	}
	{	/* save the command in Instance memory */
		register int i;

		for (i = 0; i < mp->arg_cnt+1; i++)
			buf[i] = mp->mpu_cmd[i];
	}
	mp->mpu_cmd = buf;

	/* update absolute tick time */
	my_time += mp->mpu_time;
	Wait_until((double) my_time);
}

put_mpu_cmd(mp, time)
	struct mpu_cmd	*mp;
	long 		time;
{
	static u_char old_cmd;
	register int i, limit;

	if (mp->time_tag == RT_TCIP)	/* these are synthesized by ptime() */
		return;
	ptime(time);			/* print time tag */
	if (mp->cmd_type == SX_CMD)	/* sys. ex. cmds. have 6-byte hdr. */
		limit = 6;
	else
		limit = 3;		/* all others have 3 */
	if (mp->cmd_type == old_cmd	/* this status same as last? */
	    && mp->cmd_type != RT_TCWME)/* but not an f9? */
		mp->cmd_cont = 1;	/* skip status */
	else {
		mp->cmd_cont = 0;	/* force status output */
		old_cmd = mp->cmd_type;	/* save it for next time */
	}
	for (i = 0; i < limit; i++) {
		if (i == 0 && mp->cmd_cont)
			continue;
		if (i <= mp->arg_cnt)
			putchar(mp->mpu_cmd[i]);
	}
}

ptime(time)
	long time;
{
	static long 	ctime; 	/* current time */
	register long 	tmp;
	register u_char tc;

	for (tmp = time - ctime; tmp >= MPU_CLOCK_PERIOD; tmp -= MPU_CLOCK_PERIOD)
		putchar(0xf8);
	tc = tmp;
	putchar(tc);
	ctime = time;
}

typedef Player *Pptr;	/* fool a bug in Player preprocessor */

Player setup(0)
{
	int i, flag = 0;
	Pptr v;
	double begin = 0.0;
	double duration = HUGE;


	/* figure timebase first */
	for (i = 1; i < Argc; i++) {
		register char *x = Argv[i];

		if (*x++ == '-') {
			if (*x == 'B') {	/* time base */
				TB = sfexpr(++x, 1.0);
				tps = MPU_TPS(tempo,TB);
			} else if (*x == 't') {	/* tempo */
				tempo = sfexpr(++x, 1.0);
				tps = MPU_TPS(tempo,TB);
			}
		}
	}

	for (i = 1; i < Argc; i++) {
		register char *x = Argv[i];

		if (*x++ == '-') {
			if (*x == 'b')
				begin = sfexpr(++x, tps);
			else if (*x == 'd')
				duration = sfexpr(++x, tps);
			else if (*x == 'B' || *x == 't')
				continue;
			else {
				fprintf(stderr, "mpumerge: unknown flag: %s\n",
					Argv[i]);
				usage(1);
			}
			flag = 1;
			continue;
		} 
		if (!flag) {
			begin = 0.0;
			duration = HUGE;
		}

		if ((v = New_player(part, begin, duration, P_READY)) == NULL) {
			fprintf(stderr, "New_player failed\n");
			exit(1);
		}
		Set_ps(v, 1, Argv[i]);
		Silent(v);
		flag = 0;
	}
	Kill(Self);
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s",
"usage: mpumerge [flags] mpu_file [flags] mpu_file ... > merged_mpu_data\n",
"\tflags:\n",
"\t-bN\tset begin time of following file to N seconds\n",
"\t-dN\tset duration of following file to N seconds\n",
"\t-tN\tset tempo to N beats per minute\n",
"\t-BN\tset timebase to N ticks per second\n"
);
exit(ex);
}
