h52326
s 00004/00000/00168
d D 1.5 86/04/28 14:14:19 dgl 5 4
c mpuda now prints out the channel number of channel commands
c as the third field after the semicolon.
e
s 00003/00001/00165
d D 1.4 85/05/31 16:14:26 dgl 4 3
c fiddled with way system exclusive is formatted.
e
s 00003/00002/00163
d D 1.3 85/05/29 15:33:49 dgl 3 2
c changed da_cmd to da_midi_cmd
e
s 00003/00004/00162
d D 1.2 85/01/22 14:51:39 dgl 2 1
c put fclose() in the right place, made calling sequence to
c the raw midi handler agree with the formal arguments.
e
s 00166/00000/00000
d D 1.1 84/12/21 11:30:31 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include <math.h>
# include <carl/mpu.h>

int otty;

# define RAW 0
# define COOKED 1

main(argc, argv)
	char ** argv;
{
	int		mfg_id	= ID_DX7;
	int		ch, 
			tic_mode = 0,
			fmt = COOKED; 
	float		timefac = MPU_DEFAULT_TEMPO,
			tb = MPU_DEFAULT_TIME_BASE;
	FILE 		*ifid = stdin,
			*ofid = stdout;

	while ((ch = crack(argc, argv, "t|B|", 1)) != '\0') {
		switch(ch) {
			case 'B':
				tb = sfexpr(arg_option, 1.0);
				break;
			case 't':	/* set tempo */
				timefac = sfexpr(arg_option, 1.0);
				break;
		}
	}
	timefac = 1.0 / MPU_TPS(timefac, tb);
	arg_index = 0;
	while ((ch = crack(argc, argv, "Tt|B|m|hr", 0)) != '\0') {
		switch(ch) {
			case 't':
			case 'B':
				break;
			case 'T':	/* print time in mpu clock tics */
				tic_mode = 1;
				break;
			case 'm':
				mfg_id = sfexpr(arg_option, 1.0);
				break;
			case 'r':
				fmt = RAW;
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}
	if (argc > arg_index) {
		/* read files */
		while (argc > arg_index) {
			if ((ifid = fopen(argv[arg_index++], "r")) == NULL) {
				perror("fopen");
				exit(1);
			}
			switch (fmt) {
				case RAW:
					raw_midi(ifid, ofid, mfg_id);
					break;
				case COOKED:
					mpu_fmt(ifid, ofid, timefac, 
						tic_mode, mfg_id);
					break;
D 2
			fclose(ifid);
E 2
			}
I 2
			fclose(ifid);
E 2
		}
	} else {
		/* read stdin */
		switch (fmt) {
				case RAW:
D 2
					raw_midi(mfg_id);
E 2
I 2
					raw_midi(stdin, ofid, mfg_id);
E 2
					break;
				case COOKED:
D 2
					mpu_fmt(ifid, ofid, timefac, tic_mode, 
E 2
I 2
					mpu_fmt(stdin, ofid, timefac, tic_mode, 
E 2
						mfg_id);
					break;
D 2
			fclose(ifid);
E 2
		}
	}
	exit(0);
}

mpu_fmt(ifid, ofid, timefac, tic_mode, mfg_id)
	FILE 	*ifid, 
		*ofid;
	float 	timefac;
	int 	tic_mode,
		mfg_id;
{
	extern char *	malloc();
	struct mpu_cmd 	*mp;
	u_long		cnt = 0;

	if ((mp = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL) {
		perror("malloc");
		exit(1);
	}

	while ((mp = get_mpu_cmd(ifid, mp)) != NULL) {
		register int i, limit;
		static long time;

		if (mp->time_tag == RT_TCIP)
			fprintf(ofid, "   ");
		else
			fprintf(ofid, "%2x ", mp->time_tag);
		if (mp->cmd_type == SX_CMD)
D 4
			limit = 6;
E 4
I 4
			limit = 1;
E 4
		else
			limit = 3;
		for (i = 0; i < limit; i++) {
			if (i == 0 && mp->cmd_cont)
				fprintf(ofid, "   ");
			else if (i <= mp->arg_cnt)
				fprintf(ofid, "%2x ", mp->mpu_cmd[i]);
			else
				fprintf(ofid, "   ");
		}
I 4
		if (limit == 1)
			fprintf(ofid, "      ");
E 4
		fprintf(ofid, "; ");
		time += mp->mpu_time;
		if (tic_mode)
			fprintf(ofid, "%6d ", time);
		else
			fprintf(ofid, "%8.3f ", time * timefac);
		fprintf(ofid, "%6d ", cnt++);
I 5
		if (mp->cmd_cont || ((mp->mpu_cmd[0] & 0xf0) == 0xf0))
			fprintf(ofid, "   ");
		else	/* print channel number */
			fprintf(ofid, "%2d ", mp->mpu_cmd[0] & 0xf);
E 5
D 3
		da_cmd(ofid, mp->mpu_cmd, mfg_id);
E 3
I 3
		da_midi_cmd(ofid, mp->mpu_cmd, mfg_id);
E 3
	}
I 3
	free(mp);
E 3
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s%s",
"usage: mpuda [flags] < mpu_data > disassembly\n",
"   or: mpuda [flags] mpu_data ... > disassembly\n",
"flags:\n",
"\t-tN\tset tempo in beats per minute (default=100)\n",
"\t-BN\tset time base in ticks per second (default=120)\n",
"\t-T\tprint tick time, not realtime\n",
"\t-mN\tset manufacturer's id number for controller disassembly\n",
"\t-r\traw midi data, without MPU time tags\n"
);
exit(ex);
}

raw_midi(ifid, ofid, mfg_id)
	FILE 	*ifid,
		*ofid;
	int mfg_id;
{
	u_char 	*c;

	while ((c = midi_cmd_in(ifid)) != NULL) {
D 3
		da_cmd(ofid, c, mfg_id);
E 3
I 3
		da_midi_cmd(ofid, c, mfg_id);
E 3
	}
}
E 1
