# include <stdio.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>

u_char	cmds[] = {
	0xff,		/* reset */
	0xec,		/* active track */
	0x01,		/* track 0 */
	0xb8 		/* clear play */
};

main() 
{
	u_char	buf[BUFSIZ];
	int	fd, track, n;

	if ((fd = open("/dev/mpu0", 2)) == -1)
		exit(2);

	/* initialize mpu */
	if (write(fd, cmds, sizeof(cmds)) != sizeof(cmds))
		exit(3);

	/* tell the driver to send data to track 0 */
	track = 0;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);

	while ((n = read(0, buf, BUFSIZ)) > 0)
		if (write(fd, buf, n) != n)
			exit(5);

	/* tell the driver to send command data */
	track = MPU_TR_COM;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(6);

	buf[0] = 0x0a;
	if (write(fd, buf, sizeof(u_char))) 	/* start play */
		exit(7);
	close(fd);
	exit(0);
}
