/* get_mpu_cmd.c	1.1	(CARL)	12/21/84	11:09:12 */

# include <stdio.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/mpu.h>

/*
 * get_mpu_cmd -	get midi command in mpu format
 * Note: 	the mc->mpu_cmd field points to static memory.
 * 	Save it if you are doing simultaneous get_mpu_cmd()'s,
 * 	otherwise it may get garbaged.
 */

struct mpu_cmd *
get_mpu_cmd(stream, mc)
	FILE *stream;
	struct mpu_cmd *mc;
{
	u_char *	c;
	int 		ch;
	u_long		time = 0;

	if ((ch = getc(stream)) != EOF) {
		if (ch == RT_RESET || ch ==  SX_CMD || ch == SX_EOB 
		    || ch == MPU_DATA_END) {
			mc->time_tag = RT_TCIP;	/* don't print time_tag */
			ungetc(ch, stream);
		} else if (ch == RT_TCIP) {
			time += 240;
			mc->time_tag = ch;	/* don't print time_tag */
			ungetc(ch, stream);
		} else if (ch < 240) {
			time += ch;
			mc->time_tag = ch;
			if ((ch = getc(stream)) == EOF)
				return(NULL);
			if (ch == RT_TCIP)
				time += 240;
			ungetc(ch, stream);
		}
		mc->mpu_time = time;
		if ((c = midi_cmd_in(stream)) != NULL)
			mc->mpu_cmd = c;
		mc->arg_cnt = midi_cmd_in_arg_cnt();
		mc->cmd_type = midi_cmd_in_cmd_type();
		if (mc->cmd_type == RT_TCWME)
			mc->cmd_cont = 0;
		else
			mc->cmd_cont = midi_cmd_in_cont();
		return(mc);
	}
	return(NULL);
}
