/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/time.h>
# include <sys/types.h>
# include <carl/midi.h>

# define TRW_SEL_TTY	1
# define TRW_SEL_RFD	2
# define TRW_SEL_WFD	3

/*
 * trw_sel -	wait for tty/read/write fd, or timeout
 * takes:
 * 	rfd, wfd , tfd 	-	unix file descriptors
 * 	time -		time in seconds for timeout
 * returns:
 * 	TRW_SEL_TTY for tfd, TRW_SEL_RFD for rfd, TRW_SEL_WFD for wfd.  
 * 	Returns first fd to be available, prioritized to return tfd first,
 * 	then rfd, lastly wfd.
 * notes:
 * 	If tfd and rfd are <= 0, the argument to select will be NULL for
 * 	read fids.  If wfd is <= 0, the argument to select will be NULL for
 * 	write fids.
 * 	Returns 0 if timeout interval elapsed with no activity on
 * 	any fd; -1 on errors from select().
 */

trw_sel(tfd, rfd, wfd, time)
	int tfd, rfd, wfd; 
	u_long time;
{
	register int 	 n; 
	int 		 rfds = 0, 
			*rfdsp = NULL, 
			 wfds = 0, 
			*wfdsp = NULL;
	struct timeval timeout;

	timeout.tv_sec = time;
	timeout.tv_usec = 0;
	if (tfd > 0)
		rfds = 1 << tfd;
	if (rfd > 0)
		rfds |= 1 << rfd;
	if (wfd > 0)
		wfds = 1 << wfd;
	if (rfds != 0)
		rfdsp = &rfds;
	if (wfds != 0)
		wfdsp = &wfds;
	if ((n = select(sizeof(int)*8, rfdsp, wfdsp, (int *)0, &timeout)) <= 0)
		return(n);	/* error, or timeout with nothing to read */
	if (tfd != 0 && (rfds & 1 << tfd))
		return(TRW_SEL_TTY);
	else if (rfd != 0 && (rfds & 1 << rfd))
		return(TRW_SEL_RFD); 
	else if (wfd != 0 && (wfds & 1 << wfd)) 
		return(TRW_SEL_WFD);
	else
		return(-1);	/* impossible */
}
