/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/time.h>
# include <sys/file.h>

/*
 * keypressed -	say whether a key was pressed
 * takes:
 * 	fd -	file descriptor
 * returns:
 * 	the value from select(), !0 if input is pending on that fd
 * notes:
 * 	if passed the fd for /dev/tty, it tells you when someone
 * 	bangs on the keyboard.  If the line protocol for the terminal
 * 	is cooked, it only returns true when [RETURN] is pressed,
 * 	in raw mode, it returns true on all keys pressed.
 */

keypressed(fd)
	int fd;
{
	int nids, readfds;
	struct timeval timeout;

	timeout.tv_sec = timeout.tv_usec = 0;
	readfds = 1 << fd;
	return(select(sizeof(int)*8, &readfds, (int *)0, (int *)0, &timeout));
}


/*
 * main()
 * {
 * 	int fd = open("/dev/tty", O_RDWR);
 * 
 * 	if (fd < 0) {
 * 		perror("open");
 * 		exit(1);
 * 	}
 * 
 * 	/1* setraw(fd); *1/
 * 	while (!keypressed(fd))
 * 		continue;
 * 
 * 	/1* clrraw(fd); *1/
 * 	printf("!\n");
 * 	exit(0);
 * }
 */
